/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v1.model.HostTags;
import com.datadog.api.client.v1.model.TagToHosts;
import com.datadoghq.jakarta.ws.rs.client.Invocation;
import com.datadoghq.jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class TagsApi {
    private ApiClient apiClient;

    public TagsApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public TagsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public HostTags createHostTags(String hostName, HostTags body) throws ApiException {
        return this.createHostTagsWithHttpInfo(hostName, body, new CreateHostTagsOptionalParameters()).getData();
    }

    public CompletableFuture<HostTags> createHostTagsAsync(String hostName, HostTags body) {
        return this.createHostTagsWithHttpInfoAsync(hostName, body, new CreateHostTagsOptionalParameters()).thenApply(response -> (HostTags)response.getData());
    }

    public HostTags createHostTags(String hostName, HostTags body, CreateHostTagsOptionalParameters parameters) throws ApiException {
        return this.createHostTagsWithHttpInfo(hostName, body, parameters).getData();
    }

    public CompletableFuture<HostTags> createHostTagsAsync(String hostName, HostTags body, CreateHostTagsOptionalParameters parameters) {
        return this.createHostTagsWithHttpInfoAsync(hostName, body, parameters).thenApply(response -> (HostTags)response.getData());
    }

    public ApiResponse<HostTags> createHostTagsWithHttpInfo(String hostName, HostTags body, CreateHostTagsOptionalParameters parameters) throws ApiException {
        HostTags localVarPostBody = body;
        if (hostName == null) {
            throw new ApiException(400, "Missing the required parameter 'hostName' when calling createHostTags");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createHostTags");
        }
        String source = parameters.source;
        String localVarPath = "/api/v1/tags/hosts/{host_name}".replaceAll("\\{host_name\\}", this.apiClient.escapeString(hostName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "source", source));
        Invocation.Builder builder = this.apiClient.createBuilder("v1.TagsApi.createHostTags", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<HostTags>(){});
    }

    public CompletableFuture<ApiResponse<HostTags>> createHostTagsWithHttpInfoAsync(String hostName, HostTags body, CreateHostTagsOptionalParameters parameters) {
        Invocation.Builder builder;
        HostTags localVarPostBody = body;
        if (hostName == null) {
            CompletableFuture<ApiResponse<HostTags>> result = new CompletableFuture<ApiResponse<HostTags>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'hostName' when calling createHostTags"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<HostTags>> result = new CompletableFuture<ApiResponse<HostTags>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createHostTags"));
            return result;
        }
        String source = parameters.source;
        String localVarPath = "/api/v1/tags/hosts/{host_name}".replaceAll("\\{host_name\\}", this.apiClient.escapeString(hostName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "source", source));
        try {
            builder = this.apiClient.createBuilder("v1.TagsApi.createHostTags", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<HostTags>> result = new CompletableFuture<ApiResponse<HostTags>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<HostTags>(){});
    }

    public void deleteHostTags(String hostName) throws ApiException {
        this.deleteHostTagsWithHttpInfo(hostName, new DeleteHostTagsOptionalParameters());
    }

    public CompletableFuture<Void> deleteHostTagsAsync(String hostName) {
        return this.deleteHostTagsWithHttpInfoAsync(hostName, new DeleteHostTagsOptionalParameters()).thenApply(response -> (Void)response.getData());
    }

    public void deleteHostTags(String hostName, DeleteHostTagsOptionalParameters parameters) throws ApiException {
        this.deleteHostTagsWithHttpInfo(hostName, parameters);
    }

    public CompletableFuture<Void> deleteHostTagsAsync(String hostName, DeleteHostTagsOptionalParameters parameters) {
        return this.deleteHostTagsWithHttpInfoAsync(hostName, parameters).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteHostTagsWithHttpInfo(String hostName, DeleteHostTagsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (hostName == null) {
            throw new ApiException(400, "Missing the required parameter 'hostName' when calling deleteHostTags");
        }
        String source = parameters.source;
        String localVarPath = "/api/v1/tags/hosts/{host_name}".replaceAll("\\{host_name\\}", this.apiClient.escapeString(hostName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "source", source));
        Invocation.Builder builder = this.apiClient.createBuilder("v1.TagsApi.deleteHostTags", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteHostTagsWithHttpInfoAsync(String hostName, DeleteHostTagsOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (hostName == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'hostName' when calling deleteHostTags"));
            return result;
        }
        String source = parameters.source;
        String localVarPath = "/api/v1/tags/hosts/{host_name}".replaceAll("\\{host_name\\}", this.apiClient.escapeString(hostName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "source", source));
        try {
            builder = this.apiClient.createBuilder("v1.TagsApi.deleteHostTags", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public HostTags getHostTags(String hostName) throws ApiException {
        return this.getHostTagsWithHttpInfo(hostName, new GetHostTagsOptionalParameters()).getData();
    }

    public CompletableFuture<HostTags> getHostTagsAsync(String hostName) {
        return this.getHostTagsWithHttpInfoAsync(hostName, new GetHostTagsOptionalParameters()).thenApply(response -> (HostTags)response.getData());
    }

    public HostTags getHostTags(String hostName, GetHostTagsOptionalParameters parameters) throws ApiException {
        return this.getHostTagsWithHttpInfo(hostName, parameters).getData();
    }

    public CompletableFuture<HostTags> getHostTagsAsync(String hostName, GetHostTagsOptionalParameters parameters) {
        return this.getHostTagsWithHttpInfoAsync(hostName, parameters).thenApply(response -> (HostTags)response.getData());
    }

    public ApiResponse<HostTags> getHostTagsWithHttpInfo(String hostName, GetHostTagsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (hostName == null) {
            throw new ApiException(400, "Missing the required parameter 'hostName' when calling getHostTags");
        }
        String source = parameters.source;
        String localVarPath = "/api/v1/tags/hosts/{host_name}".replaceAll("\\{host_name\\}", this.apiClient.escapeString(hostName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "source", source));
        Invocation.Builder builder = this.apiClient.createBuilder("v1.TagsApi.getHostTags", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<HostTags>(){});
    }

    public CompletableFuture<ApiResponse<HostTags>> getHostTagsWithHttpInfoAsync(String hostName, GetHostTagsOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (hostName == null) {
            CompletableFuture<ApiResponse<HostTags>> result = new CompletableFuture<ApiResponse<HostTags>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'hostName' when calling getHostTags"));
            return result;
        }
        String source = parameters.source;
        String localVarPath = "/api/v1/tags/hosts/{host_name}".replaceAll("\\{host_name\\}", this.apiClient.escapeString(hostName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "source", source));
        try {
            builder = this.apiClient.createBuilder("v1.TagsApi.getHostTags", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<HostTags>> result = new CompletableFuture<ApiResponse<HostTags>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<HostTags>(){});
    }

    public TagToHosts listHostTags() throws ApiException {
        return this.listHostTagsWithHttpInfo(new ListHostTagsOptionalParameters()).getData();
    }

    public CompletableFuture<TagToHosts> listHostTagsAsync() {
        return this.listHostTagsWithHttpInfoAsync(new ListHostTagsOptionalParameters()).thenApply(response -> (TagToHosts)response.getData());
    }

    public TagToHosts listHostTags(ListHostTagsOptionalParameters parameters) throws ApiException {
        return this.listHostTagsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<TagToHosts> listHostTagsAsync(ListHostTagsOptionalParameters parameters) {
        return this.listHostTagsWithHttpInfoAsync(parameters).thenApply(response -> (TagToHosts)response.getData());
    }

    public ApiResponse<TagToHosts> listHostTagsWithHttpInfo(ListHostTagsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        String source = parameters.source;
        String localVarPath = "/api/v1/tags/hosts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "source", source));
        Invocation.Builder builder = this.apiClient.createBuilder("v1.TagsApi.listHostTags", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<TagToHosts>(){});
    }

    public CompletableFuture<ApiResponse<TagToHosts>> listHostTagsWithHttpInfoAsync(ListHostTagsOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String source = parameters.source;
        String localVarPath = "/api/v1/tags/hosts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "source", source));
        try {
            builder = this.apiClient.createBuilder("v1.TagsApi.listHostTags", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<TagToHosts>> result = new CompletableFuture<ApiResponse<TagToHosts>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<TagToHosts>(){});
    }

    public HostTags updateHostTags(String hostName, HostTags body) throws ApiException {
        return this.updateHostTagsWithHttpInfo(hostName, body, new UpdateHostTagsOptionalParameters()).getData();
    }

    public CompletableFuture<HostTags> updateHostTagsAsync(String hostName, HostTags body) {
        return this.updateHostTagsWithHttpInfoAsync(hostName, body, new UpdateHostTagsOptionalParameters()).thenApply(response -> (HostTags)response.getData());
    }

    public HostTags updateHostTags(String hostName, HostTags body, UpdateHostTagsOptionalParameters parameters) throws ApiException {
        return this.updateHostTagsWithHttpInfo(hostName, body, parameters).getData();
    }

    public CompletableFuture<HostTags> updateHostTagsAsync(String hostName, HostTags body, UpdateHostTagsOptionalParameters parameters) {
        return this.updateHostTagsWithHttpInfoAsync(hostName, body, parameters).thenApply(response -> (HostTags)response.getData());
    }

    public ApiResponse<HostTags> updateHostTagsWithHttpInfo(String hostName, HostTags body, UpdateHostTagsOptionalParameters parameters) throws ApiException {
        HostTags localVarPostBody = body;
        if (hostName == null) {
            throw new ApiException(400, "Missing the required parameter 'hostName' when calling updateHostTags");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateHostTags");
        }
        String source = parameters.source;
        String localVarPath = "/api/v1/tags/hosts/{host_name}".replaceAll("\\{host_name\\}", this.apiClient.escapeString(hostName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "source", source));
        Invocation.Builder builder = this.apiClient.createBuilder("v1.TagsApi.updateHostTags", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<HostTags>(){});
    }

    public CompletableFuture<ApiResponse<HostTags>> updateHostTagsWithHttpInfoAsync(String hostName, HostTags body, UpdateHostTagsOptionalParameters parameters) {
        Invocation.Builder builder;
        HostTags localVarPostBody = body;
        if (hostName == null) {
            CompletableFuture<ApiResponse<HostTags>> result = new CompletableFuture<ApiResponse<HostTags>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'hostName' when calling updateHostTags"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<HostTags>> result = new CompletableFuture<ApiResponse<HostTags>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateHostTags"));
            return result;
        }
        String source = parameters.source;
        String localVarPath = "/api/v1/tags/hosts/{host_name}".replaceAll("\\{host_name\\}", this.apiClient.escapeString(hostName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "source", source));
        try {
            builder = this.apiClient.createBuilder("v1.TagsApi.updateHostTags", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<HostTags>> result = new CompletableFuture<ApiResponse<HostTags>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<HostTags>(){});
    }

    public static class UpdateHostTagsOptionalParameters {
        private String source;

        public UpdateHostTagsOptionalParameters source(String source) {
            this.source = source;
            return this;
        }
    }

    public static class ListHostTagsOptionalParameters {
        private String source;

        public ListHostTagsOptionalParameters source(String source) {
            this.source = source;
            return this;
        }
    }

    public static class GetHostTagsOptionalParameters {
        private String source;

        public GetHostTagsOptionalParameters source(String source) {
            this.source = source;
            return this;
        }
    }

    public static class DeleteHostTagsOptionalParameters {
        private String source;

        public DeleteHostTagsOptionalParameters source(String source) {
            this.source = source;
            return this;
        }
    }

    public static class CreateHostTagsOptionalParameters {
        private String source;

        public CreateHostTagsOptionalParameters source(String source) {
            this.source = source;
            return this;
        }
    }
}

