/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.PaginationIterable;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.ContainerItem;
import com.datadog.api.client.v2.model.ContainersResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.concurrent.CompletableFuture;

public class ContainersApi {
    private ApiClient apiClient;

    public ContainersApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public ContainersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ContainersResponse listContainers() throws ApiException {
        return this.listContainersWithHttpInfo(new ListContainersOptionalParameters()).getData();
    }

    public CompletableFuture<ContainersResponse> listContainersAsync() {
        return this.listContainersWithHttpInfoAsync(new ListContainersOptionalParameters()).thenApply(response -> (ContainersResponse)response.getData());
    }

    public ContainersResponse listContainers(ListContainersOptionalParameters parameters) throws ApiException {
        return this.listContainersWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<ContainersResponse> listContainersAsync(ListContainersOptionalParameters parameters) {
        return this.listContainersWithHttpInfoAsync(parameters).thenApply(response -> (ContainersResponse)response.getData());
    }

    public PaginationIterable<ContainerItem> listContainersWithPagination() {
        ListContainersOptionalParameters parameters = new ListContainersOptionalParameters();
        return this.listContainersWithPagination(parameters);
    }

    public PaginationIterable<ContainerItem> listContainersWithPagination(ListContainersOptionalParameters parameters) {
        Integer limit;
        String resultsPath = "getData";
        String valueGetterPath = "getMeta.getPagination.getNextCursor";
        String valueSetterPath = "pageCursor";
        Boolean valueSetterParamOptional = true;
        if (parameters.pageSize == null) {
            limit = 1000;
            parameters.pageSize(limit);
        } else {
            limit = parameters.pageSize;
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("optionalParams", parameters);
        PaginationIterable<ContainerItem> iterator = new PaginationIterable<ContainerItem>(this, "listContainers", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, true, limit, args);
        return iterator;
    }

    public ApiResponse<ContainersResponse> listContainersWithHttpInfo(ListContainersOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        String filterTags = parameters.filterTags;
        String groupBy = parameters.groupBy;
        String sort = parameters.sort;
        Integer pageSize = parameters.pageSize;
        String pageCursor = parameters.pageCursor;
        String localVarPath = "/api/v2/containers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[tags]", filterTags));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "group_by", groupBy));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[cursor]", pageCursor));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ContainersApi.listContainers", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ContainersResponse>(){});
    }

    public CompletableFuture<ApiResponse<ContainersResponse>> listContainersWithHttpInfoAsync(ListContainersOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String filterTags = parameters.filterTags;
        String groupBy = parameters.groupBy;
        String sort = parameters.sort;
        Integer pageSize = parameters.pageSize;
        String pageCursor = parameters.pageCursor;
        String localVarPath = "/api/v2/containers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[tags]", filterTags));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "group_by", groupBy));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[cursor]", pageCursor));
        try {
            builder = this.apiClient.createBuilder("v2.ContainersApi.listContainers", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ContainersResponse>> result = new CompletableFuture<ApiResponse<ContainersResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ContainersResponse>(){});
    }

    public static class ListContainersOptionalParameters {
        private String filterTags;
        private String groupBy;
        private String sort;
        private Integer pageSize;
        private String pageCursor;

        public ListContainersOptionalParameters filterTags(String filterTags) {
            this.filterTags = filterTags;
            return this;
        }

        public ListContainersOptionalParameters groupBy(String groupBy) {
            this.groupBy = groupBy;
            return this;
        }

        public ListContainersOptionalParameters sort(String sort) {
            this.sort = sort;
            return this;
        }

        public ListContainersOptionalParameters pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListContainersOptionalParameters pageCursor(String pageCursor) {
            this.pageCursor = pageCursor;
            return this;
        }
    }
}

