/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.SecurityMonitoringRuleQueryAggregation;
import com.datadog.api.client.v2.model.SecurityMonitoringStandardDataSource;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"aggregation", "dataSource", "distinctFields", "groupByFields", "hasOptionalGroupByFields", "metrics", "name", "query"})
public class HistoricalJobQuery {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_AGGREGATION = "aggregation";
    private SecurityMonitoringRuleQueryAggregation aggregation;
    public static final String JSON_PROPERTY_DATA_SOURCE = "dataSource";
    private SecurityMonitoringStandardDataSource dataSource = SecurityMonitoringStandardDataSource.LOGS;
    public static final String JSON_PROPERTY_DISTINCT_FIELDS = "distinctFields";
    private List<String> distinctFields = null;
    public static final String JSON_PROPERTY_GROUP_BY_FIELDS = "groupByFields";
    private List<String> groupByFields = null;
    public static final String JSON_PROPERTY_HAS_OPTIONAL_GROUP_BY_FIELDS = "hasOptionalGroupByFields";
    private Boolean hasOptionalGroupByFields;
    public static final String JSON_PROPERTY_METRICS = "metrics";
    private List<String> metrics = null;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_QUERY = "query";
    private String query;
    private Map<String, Object> additionalProperties;

    public HistoricalJobQuery aggregation(SecurityMonitoringRuleQueryAggregation aggregation) {
        this.aggregation = aggregation;
        this.unparsed |= !aggregation.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="aggregation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SecurityMonitoringRuleQueryAggregation getAggregation() {
        return this.aggregation;
    }

    public void setAggregation(SecurityMonitoringRuleQueryAggregation aggregation) {
        if (!aggregation.isValid()) {
            this.unparsed = true;
        }
        this.aggregation = aggregation;
    }

    public HistoricalJobQuery dataSource(SecurityMonitoringStandardDataSource dataSource) {
        this.dataSource = dataSource;
        this.unparsed |= !dataSource.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="dataSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SecurityMonitoringStandardDataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(SecurityMonitoringStandardDataSource dataSource) {
        if (!dataSource.isValid()) {
            this.unparsed = true;
        }
        this.dataSource = dataSource;
    }

    public HistoricalJobQuery distinctFields(List<String> distinctFields) {
        this.distinctFields = distinctFields;
        return this;
    }

    public HistoricalJobQuery addDistinctFieldsItem(String distinctFieldsItem) {
        if (this.distinctFields == null) {
            this.distinctFields = new ArrayList<String>();
        }
        this.distinctFields.add(distinctFieldsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="distinctFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDistinctFields() {
        return this.distinctFields;
    }

    public void setDistinctFields(List<String> distinctFields) {
        this.distinctFields = distinctFields;
    }

    public HistoricalJobQuery groupByFields(List<String> groupByFields) {
        this.groupByFields = groupByFields;
        return this;
    }

    public HistoricalJobQuery addGroupByFieldsItem(String groupByFieldsItem) {
        if (this.groupByFields == null) {
            this.groupByFields = new ArrayList<String>();
        }
        this.groupByFields.add(groupByFieldsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="groupByFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getGroupByFields() {
        return this.groupByFields;
    }

    public void setGroupByFields(List<String> groupByFields) {
        this.groupByFields = groupByFields;
    }

    @Nullable
    @JsonProperty(value="hasOptionalGroupByFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasOptionalGroupByFields() {
        return this.hasOptionalGroupByFields;
    }

    public HistoricalJobQuery metrics(List<String> metrics) {
        this.metrics = metrics;
        return this;
    }

    public HistoricalJobQuery addMetricsItem(String metricsItem) {
        if (this.metrics == null) {
            this.metrics = new ArrayList<String>();
        }
        this.metrics.add(metricsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="metrics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<String> metrics) {
        this.metrics = metrics;
    }

    public HistoricalJobQuery name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public HistoricalJobQuery query(String query) {
        this.query = query;
        return this;
    }

    @Nullable
    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    @JsonAnySetter
    public HistoricalJobQuery putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoricalJobQuery historicalJobQuery = (HistoricalJobQuery)o;
        return Objects.equals(this.aggregation, historicalJobQuery.aggregation) && Objects.equals(this.dataSource, historicalJobQuery.dataSource) && Objects.equals(this.distinctFields, historicalJobQuery.distinctFields) && Objects.equals(this.groupByFields, historicalJobQuery.groupByFields) && Objects.equals(this.hasOptionalGroupByFields, historicalJobQuery.hasOptionalGroupByFields) && Objects.equals(this.metrics, historicalJobQuery.metrics) && Objects.equals(this.name, historicalJobQuery.name) && Objects.equals(this.query, historicalJobQuery.query) && Objects.equals(this.additionalProperties, historicalJobQuery.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.aggregation, this.dataSource, this.distinctFields, this.groupByFields, this.hasOptionalGroupByFields, this.metrics, this.name, this.query, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HistoricalJobQuery {\n");
        sb.append("    aggregation: ").append(this.toIndentedString(this.aggregation)).append("\n");
        sb.append("    dataSource: ").append(this.toIndentedString(this.dataSource)).append("\n");
        sb.append("    distinctFields: ").append(this.toIndentedString(this.distinctFields)).append("\n");
        sb.append("    groupByFields: ").append(this.toIndentedString(this.groupByFields)).append("\n");
        sb.append("    hasOptionalGroupByFields: ").append(this.toIndentedString(this.hasOptionalGroupByFields)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

