/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.FiltersPerProduct;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"created_at", "created_by", "name", "principals", "product_filters"})
public class DatasetAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private JsonNullable<OffsetDateTime> createdAt = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CREATED_BY = "created_by";
    private UUID createdBy;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PRINCIPALS = "principals";
    private List<String> principals = new ArrayList<String>();
    public static final String JSON_PROPERTY_PRODUCT_FILTERS = "product_filters";
    private List<FiltersPerProduct> productFilters = new ArrayList<FiltersPerProduct>();
    private Map<String, Object> additionalProperties;

    public DatasetAttributes() {
    }

    @JsonCreator
    public DatasetAttributes(@JsonProperty(required=true, value="name") String name, @JsonProperty(required=true, value="principals") List<String> principals, @JsonProperty(required=true, value="product_filters") List<FiltersPerProduct> productFilters) {
        this.name = name;
        this.principals = principals;
        this.productFilters = productFilters;
    }

    public DatasetAttributes createdAt(OffsetDateTime createdAt) {
        this.createdAt = JsonNullable.of((Object)createdAt);
        return this;
    }

    @Nullable
    @JsonIgnore
    public OffsetDateTime getCreatedAt() {
        return (OffsetDateTime)this.createdAt.orElse(null);
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<OffsetDateTime> getCreatedAt_JsonNullable() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    public void setCreatedAt_JsonNullable(JsonNullable<OffsetDateTime> createdAt) {
        this.createdAt = createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = JsonNullable.of((Object)createdAt);
    }

    public DatasetAttributes createdBy(UUID createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @Nullable
    @JsonProperty(value="created_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(UUID createdBy) {
        this.createdBy = createdBy;
    }

    public DatasetAttributes name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DatasetAttributes principals(List<String> principals) {
        this.principals = principals;
        return this;
    }

    public DatasetAttributes addPrincipalsItem(String principalsItem) {
        this.principals.add(principalsItem);
        return this;
    }

    @JsonProperty(value="principals")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getPrincipals() {
        return this.principals;
    }

    public void setPrincipals(List<String> principals) {
        this.principals = principals;
    }

    public DatasetAttributes productFilters(List<FiltersPerProduct> productFilters) {
        this.productFilters = productFilters;
        for (FiltersPerProduct item : productFilters) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public DatasetAttributes addProductFiltersItem(FiltersPerProduct productFiltersItem) {
        this.productFilters.add(productFiltersItem);
        this.unparsed |= productFiltersItem.unparsed;
        return this;
    }

    @JsonProperty(value="product_filters")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<FiltersPerProduct> getProductFilters() {
        return this.productFilters;
    }

    public void setProductFilters(List<FiltersPerProduct> productFilters) {
        this.productFilters = productFilters;
    }

    @JsonAnySetter
    public DatasetAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatasetAttributes datasetAttributes = (DatasetAttributes)o;
        return Objects.equals(this.createdAt, datasetAttributes.createdAt) && Objects.equals(this.createdBy, datasetAttributes.createdBy) && Objects.equals(this.name, datasetAttributes.name) && Objects.equals(this.principals, datasetAttributes.principals) && Objects.equals(this.productFilters, datasetAttributes.productFilters) && Objects.equals(this.additionalProperties, datasetAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.createdBy, this.name, this.principals, this.productFilters, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DatasetAttributes {\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    principals: ").append(this.toIndentedString(this.principals)).append("\n");
        sb.append("    productFilters: ").append(this.toIndentedString(this.productFilters)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

