/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.MicrosoftTeamsCreateTenantBasedHandleRequest;
import com.datadog.api.client.v2.model.MicrosoftTeamsCreateWorkflowsWebhookHandleRequest;
import com.datadog.api.client.v2.model.MicrosoftTeamsGetChannelByNameResponse;
import com.datadog.api.client.v2.model.MicrosoftTeamsTenantBasedHandleResponse;
import com.datadog.api.client.v2.model.MicrosoftTeamsTenantBasedHandlesResponse;
import com.datadog.api.client.v2.model.MicrosoftTeamsUpdateTenantBasedHandleRequest;
import com.datadog.api.client.v2.model.MicrosoftTeamsUpdateWorkflowsWebhookHandleRequest;
import com.datadog.api.client.v2.model.MicrosoftTeamsWorkflowsWebhookHandleResponse;
import com.datadog.api.client.v2.model.MicrosoftTeamsWorkflowsWebhookHandlesResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class MicrosoftTeamsIntegrationApi {
    private ApiClient apiClient;

    public MicrosoftTeamsIntegrationApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public MicrosoftTeamsIntegrationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public MicrosoftTeamsTenantBasedHandleResponse createTenantBasedHandle(MicrosoftTeamsCreateTenantBasedHandleRequest body) throws ApiException {
        return this.createTenantBasedHandleWithHttpInfo(body).getData();
    }

    public CompletableFuture<MicrosoftTeamsTenantBasedHandleResponse> createTenantBasedHandleAsync(MicrosoftTeamsCreateTenantBasedHandleRequest body) {
        return this.createTenantBasedHandleWithHttpInfoAsync(body).thenApply(response -> (MicrosoftTeamsTenantBasedHandleResponse)response.getData());
    }

    public ApiResponse<MicrosoftTeamsTenantBasedHandleResponse> createTenantBasedHandleWithHttpInfo(MicrosoftTeamsCreateTenantBasedHandleRequest body) throws ApiException {
        MicrosoftTeamsCreateTenantBasedHandleRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createTenantBasedHandle");
        }
        String localVarPath = "/api/v2/integration/ms-teams/configuration/tenant-based-handles";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.MicrosoftTeamsIntegrationApi.createTenantBasedHandle", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MicrosoftTeamsTenantBasedHandleResponse>(){});
    }

    public CompletableFuture<ApiResponse<MicrosoftTeamsTenantBasedHandleResponse>> createTenantBasedHandleWithHttpInfoAsync(MicrosoftTeamsCreateTenantBasedHandleRequest body) {
        Invocation.Builder builder;
        MicrosoftTeamsCreateTenantBasedHandleRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<MicrosoftTeamsTenantBasedHandleResponse>> result = new CompletableFuture<ApiResponse<MicrosoftTeamsTenantBasedHandleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createTenantBasedHandle"));
            return result;
        }
        String localVarPath = "/api/v2/integration/ms-teams/configuration/tenant-based-handles";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.MicrosoftTeamsIntegrationApi.createTenantBasedHandle", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MicrosoftTeamsTenantBasedHandleResponse>> result = new CompletableFuture<ApiResponse<MicrosoftTeamsTenantBasedHandleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MicrosoftTeamsTenantBasedHandleResponse>(){});
    }

    public MicrosoftTeamsWorkflowsWebhookHandleResponse createWorkflowsWebhookHandle(MicrosoftTeamsCreateWorkflowsWebhookHandleRequest body) throws ApiException {
        return this.createWorkflowsWebhookHandleWithHttpInfo(body).getData();
    }

    public CompletableFuture<MicrosoftTeamsWorkflowsWebhookHandleResponse> createWorkflowsWebhookHandleAsync(MicrosoftTeamsCreateWorkflowsWebhookHandleRequest body) {
        return this.createWorkflowsWebhookHandleWithHttpInfoAsync(body).thenApply(response -> (MicrosoftTeamsWorkflowsWebhookHandleResponse)response.getData());
    }

    public ApiResponse<MicrosoftTeamsWorkflowsWebhookHandleResponse> createWorkflowsWebhookHandleWithHttpInfo(MicrosoftTeamsCreateWorkflowsWebhookHandleRequest body) throws ApiException {
        MicrosoftTeamsCreateWorkflowsWebhookHandleRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createWorkflowsWebhookHandle");
        }
        String localVarPath = "/api/v2/integration/ms-teams/configuration/workflows-webhook-handles";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.MicrosoftTeamsIntegrationApi.createWorkflowsWebhookHandle", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MicrosoftTeamsWorkflowsWebhookHandleResponse>(){});
    }

    public CompletableFuture<ApiResponse<MicrosoftTeamsWorkflowsWebhookHandleResponse>> createWorkflowsWebhookHandleWithHttpInfoAsync(MicrosoftTeamsCreateWorkflowsWebhookHandleRequest body) {
        Invocation.Builder builder;
        MicrosoftTeamsCreateWorkflowsWebhookHandleRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<MicrosoftTeamsWorkflowsWebhookHandleResponse>> result = new CompletableFuture<ApiResponse<MicrosoftTeamsWorkflowsWebhookHandleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createWorkflowsWebhookHandle"));
            return result;
        }
        String localVarPath = "/api/v2/integration/ms-teams/configuration/workflows-webhook-handles";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.MicrosoftTeamsIntegrationApi.createWorkflowsWebhookHandle", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MicrosoftTeamsWorkflowsWebhookHandleResponse>> result = new CompletableFuture<ApiResponse<MicrosoftTeamsWorkflowsWebhookHandleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MicrosoftTeamsWorkflowsWebhookHandleResponse>(){});
    }

    public void deleteTenantBasedHandle(String handleId) throws ApiException {
        this.deleteTenantBasedHandleWithHttpInfo(handleId);
    }

    public CompletableFuture<Void> deleteTenantBasedHandleAsync(String handleId) {
        return this.deleteTenantBasedHandleWithHttpInfoAsync(handleId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteTenantBasedHandleWithHttpInfo(String handleId) throws ApiException {
        Object localVarPostBody = null;
        if (handleId == null) {
            throw new ApiException(400, "Missing the required parameter 'handleId' when calling deleteTenantBasedHandle");
        }
        String localVarPath = "/api/v2/integration/ms-teams/configuration/tenant-based-handles/{handle_id}".replaceAll("\\{handle_id\\}", this.apiClient.escapeString(handleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.MicrosoftTeamsIntegrationApi.deleteTenantBasedHandle", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteTenantBasedHandleWithHttpInfoAsync(String handleId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (handleId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'handleId' when calling deleteTenantBasedHandle"));
            return result;
        }
        String localVarPath = "/api/v2/integration/ms-teams/configuration/tenant-based-handles/{handle_id}".replaceAll("\\{handle_id\\}", this.apiClient.escapeString(handleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.MicrosoftTeamsIntegrationApi.deleteTenantBasedHandle", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteWorkflowsWebhookHandle(String handleId) throws ApiException {
        this.deleteWorkflowsWebhookHandleWithHttpInfo(handleId);
    }

    public CompletableFuture<Void> deleteWorkflowsWebhookHandleAsync(String handleId) {
        return this.deleteWorkflowsWebhookHandleWithHttpInfoAsync(handleId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteWorkflowsWebhookHandleWithHttpInfo(String handleId) throws ApiException {
        Object localVarPostBody = null;
        if (handleId == null) {
            throw new ApiException(400, "Missing the required parameter 'handleId' when calling deleteWorkflowsWebhookHandle");
        }
        String localVarPath = "/api/v2/integration/ms-teams/configuration/workflows-webhook-handles/{handle_id}".replaceAll("\\{handle_id\\}", this.apiClient.escapeString(handleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.MicrosoftTeamsIntegrationApi.deleteWorkflowsWebhookHandle", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteWorkflowsWebhookHandleWithHttpInfoAsync(String handleId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (handleId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'handleId' when calling deleteWorkflowsWebhookHandle"));
            return result;
        }
        String localVarPath = "/api/v2/integration/ms-teams/configuration/workflows-webhook-handles/{handle_id}".replaceAll("\\{handle_id\\}", this.apiClient.escapeString(handleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.MicrosoftTeamsIntegrationApi.deleteWorkflowsWebhookHandle", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public MicrosoftTeamsGetChannelByNameResponse getChannelByName(String tenantName, String teamName, String channelName) throws ApiException {
        return this.getChannelByNameWithHttpInfo(tenantName, teamName, channelName).getData();
    }

    public CompletableFuture<MicrosoftTeamsGetChannelByNameResponse> getChannelByNameAsync(String tenantName, String teamName, String channelName) {
        return this.getChannelByNameWithHttpInfoAsync(tenantName, teamName, channelName).thenApply(response -> (MicrosoftTeamsGetChannelByNameResponse)response.getData());
    }

    public ApiResponse<MicrosoftTeamsGetChannelByNameResponse> getChannelByNameWithHttpInfo(String tenantName, String teamName, String channelName) throws ApiException {
        Object localVarPostBody = null;
        if (tenantName == null) {
            throw new ApiException(400, "Missing the required parameter 'tenantName' when calling getChannelByName");
        }
        if (teamName == null) {
            throw new ApiException(400, "Missing the required parameter 'teamName' when calling getChannelByName");
        }
        if (channelName == null) {
            throw new ApiException(400, "Missing the required parameter 'channelName' when calling getChannelByName");
        }
        String localVarPath = "/api/v2/integration/ms-teams/configuration/channel/{tenant_name}/{team_name}/{channel_name}".replaceAll("\\{tenant_name\\}", this.apiClient.escapeString(tenantName.toString())).replaceAll("\\{team_name\\}", this.apiClient.escapeString(teamName.toString())).replaceAll("\\{channel_name\\}", this.apiClient.escapeString(channelName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.MicrosoftTeamsIntegrationApi.getChannelByName", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MicrosoftTeamsGetChannelByNameResponse>(){});
    }

    public CompletableFuture<ApiResponse<MicrosoftTeamsGetChannelByNameResponse>> getChannelByNameWithHttpInfoAsync(String tenantName, String teamName, String channelName) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (tenantName == null) {
            CompletableFuture<ApiResponse<MicrosoftTeamsGetChannelByNameResponse>> result = new CompletableFuture<ApiResponse<MicrosoftTeamsGetChannelByNameResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'tenantName' when calling getChannelByName"));
            return result;
        }
        if (teamName == null) {
            CompletableFuture<ApiResponse<MicrosoftTeamsGetChannelByNameResponse>> result = new CompletableFuture<ApiResponse<MicrosoftTeamsGetChannelByNameResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'teamName' when calling getChannelByName"));
            return result;
        }
        if (channelName == null) {
            CompletableFuture<ApiResponse<MicrosoftTeamsGetChannelByNameResponse>> result = new CompletableFuture<ApiResponse<MicrosoftTeamsGetChannelByNameResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'channelName' when calling getChannelByName"));
            return result;
        }
        String localVarPath = "/api/v2/integration/ms-teams/configuration/channel/{tenant_name}/{team_name}/{channel_name}".replaceAll("\\{tenant_name\\}", this.apiClient.escapeString(tenantName.toString())).replaceAll("\\{team_name\\}", this.apiClient.escapeString(teamName.toString())).replaceAll("\\{channel_name\\}", this.apiClient.escapeString(channelName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.MicrosoftTeamsIntegrationApi.getChannelByName", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MicrosoftTeamsGetChannelByNameResponse>> result = new CompletableFuture<ApiResponse<MicrosoftTeamsGetChannelByNameResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MicrosoftTeamsGetChannelByNameResponse>(){});
    }

    public MicrosoftTeamsTenantBasedHandleResponse getTenantBasedHandle(String handleId) throws ApiException {
        return this.getTenantBasedHandleWithHttpInfo(handleId).getData();
    }

    public CompletableFuture<MicrosoftTeamsTenantBasedHandleResponse> getTenantBasedHandleAsync(String handleId) {
        return this.getTenantBasedHandleWithHttpInfoAsync(handleId).thenApply(response -> (MicrosoftTeamsTenantBasedHandleResponse)response.getData());
    }

    public ApiResponse<MicrosoftTeamsTenantBasedHandleResponse> getTenantBasedHandleWithHttpInfo(String handleId) throws ApiException {
        Object localVarPostBody = null;
        if (handleId == null) {
            throw new ApiException(400, "Missing the required parameter 'handleId' when calling getTenantBasedHandle");
        }
        String localVarPath = "/api/v2/integration/ms-teams/configuration/tenant-based-handles/{handle_id}".replaceAll("\\{handle_id\\}", this.apiClient.escapeString(handleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.MicrosoftTeamsIntegrationApi.getTenantBasedHandle", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MicrosoftTeamsTenantBasedHandleResponse>(){});
    }

    public CompletableFuture<ApiResponse<MicrosoftTeamsTenantBasedHandleResponse>> getTenantBasedHandleWithHttpInfoAsync(String handleId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (handleId == null) {
            CompletableFuture<ApiResponse<MicrosoftTeamsTenantBasedHandleResponse>> result = new CompletableFuture<ApiResponse<MicrosoftTeamsTenantBasedHandleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'handleId' when calling getTenantBasedHandle"));
            return result;
        }
        String localVarPath = "/api/v2/integration/ms-teams/configuration/tenant-based-handles/{handle_id}".replaceAll("\\{handle_id\\}", this.apiClient.escapeString(handleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.MicrosoftTeamsIntegrationApi.getTenantBasedHandle", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MicrosoftTeamsTenantBasedHandleResponse>> result = new CompletableFuture<ApiResponse<MicrosoftTeamsTenantBasedHandleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MicrosoftTeamsTenantBasedHandleResponse>(){});
    }

    public MicrosoftTeamsWorkflowsWebhookHandleResponse getWorkflowsWebhookHandle(String handleId) throws ApiException {
        return this.getWorkflowsWebhookHandleWithHttpInfo(handleId).getData();
    }

    public CompletableFuture<MicrosoftTeamsWorkflowsWebhookHandleResponse> getWorkflowsWebhookHandleAsync(String handleId) {
        return this.getWorkflowsWebhookHandleWithHttpInfoAsync(handleId).thenApply(response -> (MicrosoftTeamsWorkflowsWebhookHandleResponse)response.getData());
    }

    public ApiResponse<MicrosoftTeamsWorkflowsWebhookHandleResponse> getWorkflowsWebhookHandleWithHttpInfo(String handleId) throws ApiException {
        Object localVarPostBody = null;
        if (handleId == null) {
            throw new ApiException(400, "Missing the required parameter 'handleId' when calling getWorkflowsWebhookHandle");
        }
        String localVarPath = "/api/v2/integration/ms-teams/configuration/workflows-webhook-handles/{handle_id}".replaceAll("\\{handle_id\\}", this.apiClient.escapeString(handleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.MicrosoftTeamsIntegrationApi.getWorkflowsWebhookHandle", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MicrosoftTeamsWorkflowsWebhookHandleResponse>(){});
    }

    public CompletableFuture<ApiResponse<MicrosoftTeamsWorkflowsWebhookHandleResponse>> getWorkflowsWebhookHandleWithHttpInfoAsync(String handleId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (handleId == null) {
            CompletableFuture<ApiResponse<MicrosoftTeamsWorkflowsWebhookHandleResponse>> result = new CompletableFuture<ApiResponse<MicrosoftTeamsWorkflowsWebhookHandleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'handleId' when calling getWorkflowsWebhookHandle"));
            return result;
        }
        String localVarPath = "/api/v2/integration/ms-teams/configuration/workflows-webhook-handles/{handle_id}".replaceAll("\\{handle_id\\}", this.apiClient.escapeString(handleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.MicrosoftTeamsIntegrationApi.getWorkflowsWebhookHandle", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MicrosoftTeamsWorkflowsWebhookHandleResponse>> result = new CompletableFuture<ApiResponse<MicrosoftTeamsWorkflowsWebhookHandleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MicrosoftTeamsWorkflowsWebhookHandleResponse>(){});
    }

    public MicrosoftTeamsTenantBasedHandlesResponse listTenantBasedHandles() throws ApiException {
        return this.listTenantBasedHandlesWithHttpInfo(new ListTenantBasedHandlesOptionalParameters()).getData();
    }

    public CompletableFuture<MicrosoftTeamsTenantBasedHandlesResponse> listTenantBasedHandlesAsync() {
        return this.listTenantBasedHandlesWithHttpInfoAsync(new ListTenantBasedHandlesOptionalParameters()).thenApply(response -> (MicrosoftTeamsTenantBasedHandlesResponse)response.getData());
    }

    public MicrosoftTeamsTenantBasedHandlesResponse listTenantBasedHandles(ListTenantBasedHandlesOptionalParameters parameters) throws ApiException {
        return this.listTenantBasedHandlesWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<MicrosoftTeamsTenantBasedHandlesResponse> listTenantBasedHandlesAsync(ListTenantBasedHandlesOptionalParameters parameters) {
        return this.listTenantBasedHandlesWithHttpInfoAsync(parameters).thenApply(response -> (MicrosoftTeamsTenantBasedHandlesResponse)response.getData());
    }

    public ApiResponse<MicrosoftTeamsTenantBasedHandlesResponse> listTenantBasedHandlesWithHttpInfo(ListTenantBasedHandlesOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        String tenantId = parameters.tenantId;
        String name = parameters.name;
        String localVarPath = "/api/v2/integration/ms-teams/configuration/tenant-based-handles";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "tenant_id", tenantId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "name", name));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.MicrosoftTeamsIntegrationApi.listTenantBasedHandles", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MicrosoftTeamsTenantBasedHandlesResponse>(){});
    }

    public CompletableFuture<ApiResponse<MicrosoftTeamsTenantBasedHandlesResponse>> listTenantBasedHandlesWithHttpInfoAsync(ListTenantBasedHandlesOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String tenantId = parameters.tenantId;
        String name = parameters.name;
        String localVarPath = "/api/v2/integration/ms-teams/configuration/tenant-based-handles";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "tenant_id", tenantId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "name", name));
        try {
            builder = this.apiClient.createBuilder("v2.MicrosoftTeamsIntegrationApi.listTenantBasedHandles", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MicrosoftTeamsTenantBasedHandlesResponse>> result = new CompletableFuture<ApiResponse<MicrosoftTeamsTenantBasedHandlesResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MicrosoftTeamsTenantBasedHandlesResponse>(){});
    }

    public MicrosoftTeamsWorkflowsWebhookHandlesResponse listWorkflowsWebhookHandles() throws ApiException {
        return this.listWorkflowsWebhookHandlesWithHttpInfo(new ListWorkflowsWebhookHandlesOptionalParameters()).getData();
    }

    public CompletableFuture<MicrosoftTeamsWorkflowsWebhookHandlesResponse> listWorkflowsWebhookHandlesAsync() {
        return this.listWorkflowsWebhookHandlesWithHttpInfoAsync(new ListWorkflowsWebhookHandlesOptionalParameters()).thenApply(response -> (MicrosoftTeamsWorkflowsWebhookHandlesResponse)response.getData());
    }

    public MicrosoftTeamsWorkflowsWebhookHandlesResponse listWorkflowsWebhookHandles(ListWorkflowsWebhookHandlesOptionalParameters parameters) throws ApiException {
        return this.listWorkflowsWebhookHandlesWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<MicrosoftTeamsWorkflowsWebhookHandlesResponse> listWorkflowsWebhookHandlesAsync(ListWorkflowsWebhookHandlesOptionalParameters parameters) {
        return this.listWorkflowsWebhookHandlesWithHttpInfoAsync(parameters).thenApply(response -> (MicrosoftTeamsWorkflowsWebhookHandlesResponse)response.getData());
    }

    public ApiResponse<MicrosoftTeamsWorkflowsWebhookHandlesResponse> listWorkflowsWebhookHandlesWithHttpInfo(ListWorkflowsWebhookHandlesOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        String name = parameters.name;
        String localVarPath = "/api/v2/integration/ms-teams/configuration/workflows-webhook-handles";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "name", name));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.MicrosoftTeamsIntegrationApi.listWorkflowsWebhookHandles", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MicrosoftTeamsWorkflowsWebhookHandlesResponse>(){});
    }

    public CompletableFuture<ApiResponse<MicrosoftTeamsWorkflowsWebhookHandlesResponse>> listWorkflowsWebhookHandlesWithHttpInfoAsync(ListWorkflowsWebhookHandlesOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String name = parameters.name;
        String localVarPath = "/api/v2/integration/ms-teams/configuration/workflows-webhook-handles";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "name", name));
        try {
            builder = this.apiClient.createBuilder("v2.MicrosoftTeamsIntegrationApi.listWorkflowsWebhookHandles", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MicrosoftTeamsWorkflowsWebhookHandlesResponse>> result = new CompletableFuture<ApiResponse<MicrosoftTeamsWorkflowsWebhookHandlesResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MicrosoftTeamsWorkflowsWebhookHandlesResponse>(){});
    }

    public MicrosoftTeamsTenantBasedHandleResponse updateTenantBasedHandle(String handleId, MicrosoftTeamsUpdateTenantBasedHandleRequest body) throws ApiException {
        return this.updateTenantBasedHandleWithHttpInfo(handleId, body).getData();
    }

    public CompletableFuture<MicrosoftTeamsTenantBasedHandleResponse> updateTenantBasedHandleAsync(String handleId, MicrosoftTeamsUpdateTenantBasedHandleRequest body) {
        return this.updateTenantBasedHandleWithHttpInfoAsync(handleId, body).thenApply(response -> (MicrosoftTeamsTenantBasedHandleResponse)response.getData());
    }

    public ApiResponse<MicrosoftTeamsTenantBasedHandleResponse> updateTenantBasedHandleWithHttpInfo(String handleId, MicrosoftTeamsUpdateTenantBasedHandleRequest body) throws ApiException {
        MicrosoftTeamsUpdateTenantBasedHandleRequest localVarPostBody = body;
        if (handleId == null) {
            throw new ApiException(400, "Missing the required parameter 'handleId' when calling updateTenantBasedHandle");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateTenantBasedHandle");
        }
        String localVarPath = "/api/v2/integration/ms-teams/configuration/tenant-based-handles/{handle_id}".replaceAll("\\{handle_id\\}", this.apiClient.escapeString(handleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.MicrosoftTeamsIntegrationApi.updateTenantBasedHandle", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MicrosoftTeamsTenantBasedHandleResponse>(){});
    }

    public CompletableFuture<ApiResponse<MicrosoftTeamsTenantBasedHandleResponse>> updateTenantBasedHandleWithHttpInfoAsync(String handleId, MicrosoftTeamsUpdateTenantBasedHandleRequest body) {
        Invocation.Builder builder;
        MicrosoftTeamsUpdateTenantBasedHandleRequest localVarPostBody = body;
        if (handleId == null) {
            CompletableFuture<ApiResponse<MicrosoftTeamsTenantBasedHandleResponse>> result = new CompletableFuture<ApiResponse<MicrosoftTeamsTenantBasedHandleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'handleId' when calling updateTenantBasedHandle"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<MicrosoftTeamsTenantBasedHandleResponse>> result = new CompletableFuture<ApiResponse<MicrosoftTeamsTenantBasedHandleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateTenantBasedHandle"));
            return result;
        }
        String localVarPath = "/api/v2/integration/ms-teams/configuration/tenant-based-handles/{handle_id}".replaceAll("\\{handle_id\\}", this.apiClient.escapeString(handleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.MicrosoftTeamsIntegrationApi.updateTenantBasedHandle", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MicrosoftTeamsTenantBasedHandleResponse>> result = new CompletableFuture<ApiResponse<MicrosoftTeamsTenantBasedHandleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MicrosoftTeamsTenantBasedHandleResponse>(){});
    }

    public MicrosoftTeamsWorkflowsWebhookHandleResponse updateWorkflowsWebhookHandle(String handleId, MicrosoftTeamsUpdateWorkflowsWebhookHandleRequest body) throws ApiException {
        return this.updateWorkflowsWebhookHandleWithHttpInfo(handleId, body).getData();
    }

    public CompletableFuture<MicrosoftTeamsWorkflowsWebhookHandleResponse> updateWorkflowsWebhookHandleAsync(String handleId, MicrosoftTeamsUpdateWorkflowsWebhookHandleRequest body) {
        return this.updateWorkflowsWebhookHandleWithHttpInfoAsync(handleId, body).thenApply(response -> (MicrosoftTeamsWorkflowsWebhookHandleResponse)response.getData());
    }

    public ApiResponse<MicrosoftTeamsWorkflowsWebhookHandleResponse> updateWorkflowsWebhookHandleWithHttpInfo(String handleId, MicrosoftTeamsUpdateWorkflowsWebhookHandleRequest body) throws ApiException {
        MicrosoftTeamsUpdateWorkflowsWebhookHandleRequest localVarPostBody = body;
        if (handleId == null) {
            throw new ApiException(400, "Missing the required parameter 'handleId' when calling updateWorkflowsWebhookHandle");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateWorkflowsWebhookHandle");
        }
        String localVarPath = "/api/v2/integration/ms-teams/configuration/workflows-webhook-handles/{handle_id}".replaceAll("\\{handle_id\\}", this.apiClient.escapeString(handleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.MicrosoftTeamsIntegrationApi.updateWorkflowsWebhookHandle", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MicrosoftTeamsWorkflowsWebhookHandleResponse>(){});
    }

    public CompletableFuture<ApiResponse<MicrosoftTeamsWorkflowsWebhookHandleResponse>> updateWorkflowsWebhookHandleWithHttpInfoAsync(String handleId, MicrosoftTeamsUpdateWorkflowsWebhookHandleRequest body) {
        Invocation.Builder builder;
        MicrosoftTeamsUpdateWorkflowsWebhookHandleRequest localVarPostBody = body;
        if (handleId == null) {
            CompletableFuture<ApiResponse<MicrosoftTeamsWorkflowsWebhookHandleResponse>> result = new CompletableFuture<ApiResponse<MicrosoftTeamsWorkflowsWebhookHandleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'handleId' when calling updateWorkflowsWebhookHandle"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<MicrosoftTeamsWorkflowsWebhookHandleResponse>> result = new CompletableFuture<ApiResponse<MicrosoftTeamsWorkflowsWebhookHandleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateWorkflowsWebhookHandle"));
            return result;
        }
        String localVarPath = "/api/v2/integration/ms-teams/configuration/workflows-webhook-handles/{handle_id}".replaceAll("\\{handle_id\\}", this.apiClient.escapeString(handleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.MicrosoftTeamsIntegrationApi.updateWorkflowsWebhookHandle", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MicrosoftTeamsWorkflowsWebhookHandleResponse>> result = new CompletableFuture<ApiResponse<MicrosoftTeamsWorkflowsWebhookHandleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MicrosoftTeamsWorkflowsWebhookHandleResponse>(){});
    }

    public static class ListWorkflowsWebhookHandlesOptionalParameters {
        private String name;

        public ListWorkflowsWebhookHandlesOptionalParameters name(String name) {
            this.name = name;
            return this;
        }
    }

    public static class ListTenantBasedHandlesOptionalParameters {
        private String tenantId;
        private String name;

        public ListTenantBasedHandlesOptionalParameters tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public ListTenantBasedHandlesOptionalParameters name(String name) {
            this.name = name;
            return this;
        }
    }
}

