/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.AwsCURConfigPatchRequest;
import com.datadog.api.client.v2.model.AwsCURConfigPostRequest;
import com.datadog.api.client.v2.model.AwsCURConfigResponse;
import com.datadog.api.client.v2.model.AwsCURConfigsResponse;
import com.datadog.api.client.v2.model.AzureUCConfigPairsResponse;
import com.datadog.api.client.v2.model.AzureUCConfigPatchRequest;
import com.datadog.api.client.v2.model.AzureUCConfigPostRequest;
import com.datadog.api.client.v2.model.AzureUCConfigsResponse;
import com.datadog.api.client.v2.model.BudgetArray;
import com.datadog.api.client.v2.model.BudgetWithEntries;
import com.datadog.api.client.v2.model.CustomCostsFileGetResponse;
import com.datadog.api.client.v2.model.CustomCostsFileLineItem;
import com.datadog.api.client.v2.model.CustomCostsFileListResponse;
import com.datadog.api.client.v2.model.CustomCostsFileUploadResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class CloudCostManagementApi {
    private ApiClient apiClient;

    public CloudCostManagementApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public CloudCostManagementApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public AwsCURConfigResponse createCostAWSCURConfig(AwsCURConfigPostRequest body) throws ApiException {
        return this.createCostAWSCURConfigWithHttpInfo(body).getData();
    }

    public CompletableFuture<AwsCURConfigResponse> createCostAWSCURConfigAsync(AwsCURConfigPostRequest body) {
        return this.createCostAWSCURConfigWithHttpInfoAsync(body).thenApply(response -> (AwsCURConfigResponse)response.getData());
    }

    public ApiResponse<AwsCURConfigResponse> createCostAWSCURConfigWithHttpInfo(AwsCURConfigPostRequest body) throws ApiException {
        AwsCURConfigPostRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createCostAWSCURConfig");
        }
        String localVarPath = "/api/v2/cost/aws_cur_config";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.createCostAWSCURConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsCURConfigResponse>(){});
    }

    public CompletableFuture<ApiResponse<AwsCURConfigResponse>> createCostAWSCURConfigWithHttpInfoAsync(AwsCURConfigPostRequest body) {
        Invocation.Builder builder;
        AwsCURConfigPostRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<AwsCURConfigResponse>> result = new CompletableFuture<ApiResponse<AwsCURConfigResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createCostAWSCURConfig"));
            return result;
        }
        String localVarPath = "/api/v2/cost/aws_cur_config";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.createCostAWSCURConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AwsCURConfigResponse>> result = new CompletableFuture<ApiResponse<AwsCURConfigResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsCURConfigResponse>(){});
    }

    public AzureUCConfigPairsResponse createCostAzureUCConfigs(AzureUCConfigPostRequest body) throws ApiException {
        return this.createCostAzureUCConfigsWithHttpInfo(body).getData();
    }

    public CompletableFuture<AzureUCConfigPairsResponse> createCostAzureUCConfigsAsync(AzureUCConfigPostRequest body) {
        return this.createCostAzureUCConfigsWithHttpInfoAsync(body).thenApply(response -> (AzureUCConfigPairsResponse)response.getData());
    }

    public ApiResponse<AzureUCConfigPairsResponse> createCostAzureUCConfigsWithHttpInfo(AzureUCConfigPostRequest body) throws ApiException {
        AzureUCConfigPostRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createCostAzureUCConfigs");
        }
        String localVarPath = "/api/v2/cost/azure_uc_config";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.createCostAzureUCConfigs", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AzureUCConfigPairsResponse>(){});
    }

    public CompletableFuture<ApiResponse<AzureUCConfigPairsResponse>> createCostAzureUCConfigsWithHttpInfoAsync(AzureUCConfigPostRequest body) {
        Invocation.Builder builder;
        AzureUCConfigPostRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<AzureUCConfigPairsResponse>> result = new CompletableFuture<ApiResponse<AzureUCConfigPairsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createCostAzureUCConfigs"));
            return result;
        }
        String localVarPath = "/api/v2/cost/azure_uc_config";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.createCostAzureUCConfigs", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AzureUCConfigPairsResponse>> result = new CompletableFuture<ApiResponse<AzureUCConfigPairsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AzureUCConfigPairsResponse>(){});
    }

    public void deleteBudget(String budgetId) throws ApiException {
        this.deleteBudgetWithHttpInfo(budgetId);
    }

    public CompletableFuture<Void> deleteBudgetAsync(String budgetId) {
        return this.deleteBudgetWithHttpInfoAsync(budgetId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteBudgetWithHttpInfo(String budgetId) throws ApiException {
        Object localVarPostBody = null;
        if (budgetId == null) {
            throw new ApiException(400, "Missing the required parameter 'budgetId' when calling deleteBudget");
        }
        String localVarPath = "/api/v2/cost/budget/{budget_id}".replaceAll("\\{budget_id\\}", this.apiClient.escapeString(budgetId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.deleteBudget", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteBudgetWithHttpInfoAsync(String budgetId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (budgetId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'budgetId' when calling deleteBudget"));
            return result;
        }
        String localVarPath = "/api/v2/cost/budget/{budget_id}".replaceAll("\\{budget_id\\}", this.apiClient.escapeString(budgetId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.deleteBudget", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteCostAWSCURConfig(String cloudAccountId) throws ApiException {
        this.deleteCostAWSCURConfigWithHttpInfo(cloudAccountId);
    }

    public CompletableFuture<Void> deleteCostAWSCURConfigAsync(String cloudAccountId) {
        return this.deleteCostAWSCURConfigWithHttpInfoAsync(cloudAccountId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteCostAWSCURConfigWithHttpInfo(String cloudAccountId) throws ApiException {
        Object localVarPostBody = null;
        if (cloudAccountId == null) {
            throw new ApiException(400, "Missing the required parameter 'cloudAccountId' when calling deleteCostAWSCURConfig");
        }
        String localVarPath = "/api/v2/cost/aws_cur_config/{cloud_account_id}".replaceAll("\\{cloud_account_id\\}", this.apiClient.escapeString(cloudAccountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.deleteCostAWSCURConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteCostAWSCURConfigWithHttpInfoAsync(String cloudAccountId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (cloudAccountId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'cloudAccountId' when calling deleteCostAWSCURConfig"));
            return result;
        }
        String localVarPath = "/api/v2/cost/aws_cur_config/{cloud_account_id}".replaceAll("\\{cloud_account_id\\}", this.apiClient.escapeString(cloudAccountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.deleteCostAWSCURConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteCostAzureUCConfig(String cloudAccountId) throws ApiException {
        this.deleteCostAzureUCConfigWithHttpInfo(cloudAccountId);
    }

    public CompletableFuture<Void> deleteCostAzureUCConfigAsync(String cloudAccountId) {
        return this.deleteCostAzureUCConfigWithHttpInfoAsync(cloudAccountId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteCostAzureUCConfigWithHttpInfo(String cloudAccountId) throws ApiException {
        Object localVarPostBody = null;
        if (cloudAccountId == null) {
            throw new ApiException(400, "Missing the required parameter 'cloudAccountId' when calling deleteCostAzureUCConfig");
        }
        String localVarPath = "/api/v2/cost/azure_uc_config/{cloud_account_id}".replaceAll("\\{cloud_account_id\\}", this.apiClient.escapeString(cloudAccountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.deleteCostAzureUCConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteCostAzureUCConfigWithHttpInfoAsync(String cloudAccountId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (cloudAccountId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'cloudAccountId' when calling deleteCostAzureUCConfig"));
            return result;
        }
        String localVarPath = "/api/v2/cost/azure_uc_config/{cloud_account_id}".replaceAll("\\{cloud_account_id\\}", this.apiClient.escapeString(cloudAccountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.deleteCostAzureUCConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteCustomCostsFile(String fileId) throws ApiException {
        this.deleteCustomCostsFileWithHttpInfo(fileId);
    }

    public CompletableFuture<Void> deleteCustomCostsFileAsync(String fileId) {
        return this.deleteCustomCostsFileWithHttpInfoAsync(fileId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteCustomCostsFileWithHttpInfo(String fileId) throws ApiException {
        Object localVarPostBody = null;
        if (fileId == null) {
            throw new ApiException(400, "Missing the required parameter 'fileId' when calling deleteCustomCostsFile");
        }
        String localVarPath = "/api/v2/cost/custom_costs/{file_id}".replaceAll("\\{file_id\\}", this.apiClient.escapeString(fileId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.deleteCustomCostsFile", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteCustomCostsFileWithHttpInfoAsync(String fileId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (fileId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'fileId' when calling deleteCustomCostsFile"));
            return result;
        }
        String localVarPath = "/api/v2/cost/custom_costs/{file_id}".replaceAll("\\{file_id\\}", this.apiClient.escapeString(fileId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.deleteCustomCostsFile", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public BudgetWithEntries getBudget(String budgetId) throws ApiException {
        return this.getBudgetWithHttpInfo(budgetId).getData();
    }

    public CompletableFuture<BudgetWithEntries> getBudgetAsync(String budgetId) {
        return this.getBudgetWithHttpInfoAsync(budgetId).thenApply(response -> (BudgetWithEntries)response.getData());
    }

    public ApiResponse<BudgetWithEntries> getBudgetWithHttpInfo(String budgetId) throws ApiException {
        Object localVarPostBody = null;
        if (budgetId == null) {
            throw new ApiException(400, "Missing the required parameter 'budgetId' when calling getBudget");
        }
        String localVarPath = "/api/v2/cost/budget/{budget_id}".replaceAll("\\{budget_id\\}", this.apiClient.escapeString(budgetId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.getBudget", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<BudgetWithEntries>(){});
    }

    public CompletableFuture<ApiResponse<BudgetWithEntries>> getBudgetWithHttpInfoAsync(String budgetId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (budgetId == null) {
            CompletableFuture<ApiResponse<BudgetWithEntries>> result = new CompletableFuture<ApiResponse<BudgetWithEntries>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'budgetId' when calling getBudget"));
            return result;
        }
        String localVarPath = "/api/v2/cost/budget/{budget_id}".replaceAll("\\{budget_id\\}", this.apiClient.escapeString(budgetId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.getBudget", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<BudgetWithEntries>> result = new CompletableFuture<ApiResponse<BudgetWithEntries>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<BudgetWithEntries>(){});
    }

    public CustomCostsFileGetResponse getCustomCostsFile(String fileId) throws ApiException {
        return this.getCustomCostsFileWithHttpInfo(fileId).getData();
    }

    public CompletableFuture<CustomCostsFileGetResponse> getCustomCostsFileAsync(String fileId) {
        return this.getCustomCostsFileWithHttpInfoAsync(fileId).thenApply(response -> (CustomCostsFileGetResponse)response.getData());
    }

    public ApiResponse<CustomCostsFileGetResponse> getCustomCostsFileWithHttpInfo(String fileId) throws ApiException {
        Object localVarPostBody = null;
        if (fileId == null) {
            throw new ApiException(400, "Missing the required parameter 'fileId' when calling getCustomCostsFile");
        }
        String localVarPath = "/api/v2/cost/custom_costs/{file_id}".replaceAll("\\{file_id\\}", this.apiClient.escapeString(fileId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.getCustomCostsFile", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CustomCostsFileGetResponse>(){});
    }

    public CompletableFuture<ApiResponse<CustomCostsFileGetResponse>> getCustomCostsFileWithHttpInfoAsync(String fileId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (fileId == null) {
            CompletableFuture<ApiResponse<CustomCostsFileGetResponse>> result = new CompletableFuture<ApiResponse<CustomCostsFileGetResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'fileId' when calling getCustomCostsFile"));
            return result;
        }
        String localVarPath = "/api/v2/cost/custom_costs/{file_id}".replaceAll("\\{file_id\\}", this.apiClient.escapeString(fileId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.getCustomCostsFile", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CustomCostsFileGetResponse>> result = new CompletableFuture<ApiResponse<CustomCostsFileGetResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CustomCostsFileGetResponse>(){});
    }

    public BudgetArray listBudgets() throws ApiException {
        return this.listBudgetsWithHttpInfo().getData();
    }

    public CompletableFuture<BudgetArray> listBudgetsAsync() {
        return this.listBudgetsWithHttpInfoAsync().thenApply(response -> (BudgetArray)response.getData());
    }

    public ApiResponse<BudgetArray> listBudgetsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/cost/budgets";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.listBudgets", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<BudgetArray>(){});
    }

    public CompletableFuture<ApiResponse<BudgetArray>> listBudgetsWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/cost/budgets";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.listBudgets", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<BudgetArray>> result = new CompletableFuture<ApiResponse<BudgetArray>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<BudgetArray>(){});
    }

    public AwsCURConfigsResponse listCostAWSCURConfigs() throws ApiException {
        return this.listCostAWSCURConfigsWithHttpInfo().getData();
    }

    public CompletableFuture<AwsCURConfigsResponse> listCostAWSCURConfigsAsync() {
        return this.listCostAWSCURConfigsWithHttpInfoAsync().thenApply(response -> (AwsCURConfigsResponse)response.getData());
    }

    public ApiResponse<AwsCURConfigsResponse> listCostAWSCURConfigsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/cost/aws_cur_config";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.listCostAWSCURConfigs", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsCURConfigsResponse>(){});
    }

    public CompletableFuture<ApiResponse<AwsCURConfigsResponse>> listCostAWSCURConfigsWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/cost/aws_cur_config";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.listCostAWSCURConfigs", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AwsCURConfigsResponse>> result = new CompletableFuture<ApiResponse<AwsCURConfigsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsCURConfigsResponse>(){});
    }

    public AzureUCConfigsResponse listCostAzureUCConfigs() throws ApiException {
        return this.listCostAzureUCConfigsWithHttpInfo().getData();
    }

    public CompletableFuture<AzureUCConfigsResponse> listCostAzureUCConfigsAsync() {
        return this.listCostAzureUCConfigsWithHttpInfoAsync().thenApply(response -> (AzureUCConfigsResponse)response.getData());
    }

    public ApiResponse<AzureUCConfigsResponse> listCostAzureUCConfigsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/cost/azure_uc_config";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.listCostAzureUCConfigs", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AzureUCConfigsResponse>(){});
    }

    public CompletableFuture<ApiResponse<AzureUCConfigsResponse>> listCostAzureUCConfigsWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/cost/azure_uc_config";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.listCostAzureUCConfigs", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AzureUCConfigsResponse>> result = new CompletableFuture<ApiResponse<AzureUCConfigsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AzureUCConfigsResponse>(){});
    }

    public CustomCostsFileListResponse listCustomCostsFiles() throws ApiException {
        return this.listCustomCostsFilesWithHttpInfo().getData();
    }

    public CompletableFuture<CustomCostsFileListResponse> listCustomCostsFilesAsync() {
        return this.listCustomCostsFilesWithHttpInfoAsync().thenApply(response -> (CustomCostsFileListResponse)response.getData());
    }

    public ApiResponse<CustomCostsFileListResponse> listCustomCostsFilesWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/cost/custom_costs";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.listCustomCostsFiles", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CustomCostsFileListResponse>(){});
    }

    public CompletableFuture<ApiResponse<CustomCostsFileListResponse>> listCustomCostsFilesWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/cost/custom_costs";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.listCustomCostsFiles", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CustomCostsFileListResponse>> result = new CompletableFuture<ApiResponse<CustomCostsFileListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CustomCostsFileListResponse>(){});
    }

    public AwsCURConfigsResponse updateCostAWSCURConfig(String cloudAccountId, AwsCURConfigPatchRequest body) throws ApiException {
        return this.updateCostAWSCURConfigWithHttpInfo(cloudAccountId, body).getData();
    }

    public CompletableFuture<AwsCURConfigsResponse> updateCostAWSCURConfigAsync(String cloudAccountId, AwsCURConfigPatchRequest body) {
        return this.updateCostAWSCURConfigWithHttpInfoAsync(cloudAccountId, body).thenApply(response -> (AwsCURConfigsResponse)response.getData());
    }

    public ApiResponse<AwsCURConfigsResponse> updateCostAWSCURConfigWithHttpInfo(String cloudAccountId, AwsCURConfigPatchRequest body) throws ApiException {
        AwsCURConfigPatchRequest localVarPostBody = body;
        if (cloudAccountId == null) {
            throw new ApiException(400, "Missing the required parameter 'cloudAccountId' when calling updateCostAWSCURConfig");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateCostAWSCURConfig");
        }
        String localVarPath = "/api/v2/cost/aws_cur_config/{cloud_account_id}".replaceAll("\\{cloud_account_id\\}", this.apiClient.escapeString(cloudAccountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.updateCostAWSCURConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsCURConfigsResponse>(){});
    }

    public CompletableFuture<ApiResponse<AwsCURConfigsResponse>> updateCostAWSCURConfigWithHttpInfoAsync(String cloudAccountId, AwsCURConfigPatchRequest body) {
        Invocation.Builder builder;
        AwsCURConfigPatchRequest localVarPostBody = body;
        if (cloudAccountId == null) {
            CompletableFuture<ApiResponse<AwsCURConfigsResponse>> result = new CompletableFuture<ApiResponse<AwsCURConfigsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'cloudAccountId' when calling updateCostAWSCURConfig"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<AwsCURConfigsResponse>> result = new CompletableFuture<ApiResponse<AwsCURConfigsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateCostAWSCURConfig"));
            return result;
        }
        String localVarPath = "/api/v2/cost/aws_cur_config/{cloud_account_id}".replaceAll("\\{cloud_account_id\\}", this.apiClient.escapeString(cloudAccountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.updateCostAWSCURConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AwsCURConfigsResponse>> result = new CompletableFuture<ApiResponse<AwsCURConfigsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsCURConfigsResponse>(){});
    }

    public AzureUCConfigPairsResponse updateCostAzureUCConfigs(String cloudAccountId, AzureUCConfigPatchRequest body) throws ApiException {
        return this.updateCostAzureUCConfigsWithHttpInfo(cloudAccountId, body).getData();
    }

    public CompletableFuture<AzureUCConfigPairsResponse> updateCostAzureUCConfigsAsync(String cloudAccountId, AzureUCConfigPatchRequest body) {
        return this.updateCostAzureUCConfigsWithHttpInfoAsync(cloudAccountId, body).thenApply(response -> (AzureUCConfigPairsResponse)response.getData());
    }

    public ApiResponse<AzureUCConfigPairsResponse> updateCostAzureUCConfigsWithHttpInfo(String cloudAccountId, AzureUCConfigPatchRequest body) throws ApiException {
        AzureUCConfigPatchRequest localVarPostBody = body;
        if (cloudAccountId == null) {
            throw new ApiException(400, "Missing the required parameter 'cloudAccountId' when calling updateCostAzureUCConfigs");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateCostAzureUCConfigs");
        }
        String localVarPath = "/api/v2/cost/azure_uc_config/{cloud_account_id}".replaceAll("\\{cloud_account_id\\}", this.apiClient.escapeString(cloudAccountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.updateCostAzureUCConfigs", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AzureUCConfigPairsResponse>(){});
    }

    public CompletableFuture<ApiResponse<AzureUCConfigPairsResponse>> updateCostAzureUCConfigsWithHttpInfoAsync(String cloudAccountId, AzureUCConfigPatchRequest body) {
        Invocation.Builder builder;
        AzureUCConfigPatchRequest localVarPostBody = body;
        if (cloudAccountId == null) {
            CompletableFuture<ApiResponse<AzureUCConfigPairsResponse>> result = new CompletableFuture<ApiResponse<AzureUCConfigPairsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'cloudAccountId' when calling updateCostAzureUCConfigs"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<AzureUCConfigPairsResponse>> result = new CompletableFuture<ApiResponse<AzureUCConfigPairsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateCostAzureUCConfigs"));
            return result;
        }
        String localVarPath = "/api/v2/cost/azure_uc_config/{cloud_account_id}".replaceAll("\\{cloud_account_id\\}", this.apiClient.escapeString(cloudAccountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.updateCostAzureUCConfigs", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AzureUCConfigPairsResponse>> result = new CompletableFuture<ApiResponse<AzureUCConfigPairsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AzureUCConfigPairsResponse>(){});
    }

    public CustomCostsFileUploadResponse uploadCustomCostsFile(List<CustomCostsFileLineItem> body) throws ApiException {
        return this.uploadCustomCostsFileWithHttpInfo(body).getData();
    }

    public CompletableFuture<CustomCostsFileUploadResponse> uploadCustomCostsFileAsync(List<CustomCostsFileLineItem> body) {
        return this.uploadCustomCostsFileWithHttpInfoAsync(body).thenApply(response -> (CustomCostsFileUploadResponse)response.getData());
    }

    public ApiResponse<CustomCostsFileUploadResponse> uploadCustomCostsFileWithHttpInfo(List<CustomCostsFileLineItem> body) throws ApiException {
        List<CustomCostsFileLineItem> localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling uploadCustomCostsFile");
        }
        String localVarPath = "/api/v2/cost/custom_costs";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.uploadCustomCostsFile", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CustomCostsFileUploadResponse>(){});
    }

    public CompletableFuture<ApiResponse<CustomCostsFileUploadResponse>> uploadCustomCostsFileWithHttpInfoAsync(List<CustomCostsFileLineItem> body) {
        Invocation.Builder builder;
        List<CustomCostsFileLineItem> localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<CustomCostsFileUploadResponse>> result = new CompletableFuture<ApiResponse<CustomCostsFileUploadResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling uploadCustomCostsFile"));
            return result;
        }
        String localVarPath = "/api/v2/cost/custom_costs";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.uploadCustomCostsFile", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CustomCostsFileUploadResponse>> result = new CompletableFuture<ApiResponse<CustomCostsFileUploadResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CustomCostsFileUploadResponse>(){});
    }

    public BudgetWithEntries upsertBudget(BudgetWithEntries body) throws ApiException {
        return this.upsertBudgetWithHttpInfo(body).getData();
    }

    public CompletableFuture<BudgetWithEntries> upsertBudgetAsync(BudgetWithEntries body) {
        return this.upsertBudgetWithHttpInfoAsync(body).thenApply(response -> (BudgetWithEntries)response.getData());
    }

    public ApiResponse<BudgetWithEntries> upsertBudgetWithHttpInfo(BudgetWithEntries body) throws ApiException {
        BudgetWithEntries localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling upsertBudget");
        }
        String localVarPath = "/api/v2/cost/budget";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.upsertBudget", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<BudgetWithEntries>(){});
    }

    public CompletableFuture<ApiResponse<BudgetWithEntries>> upsertBudgetWithHttpInfoAsync(BudgetWithEntries body) {
        Invocation.Builder builder;
        BudgetWithEntries localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<BudgetWithEntries>> result = new CompletableFuture<ApiResponse<BudgetWithEntries>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling upsertBudget"));
            return result;
        }
        String localVarPath = "/api/v2/cost/budget";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.upsertBudget", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<BudgetWithEntries>> result = new CompletableFuture<ApiResponse<BudgetWithEntries>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<BudgetWithEntries>(){});
    }
}

