/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.ObservabilityPipeline;
import com.datadog.api.client.v2.model.ObservabilityPipelineCreateRequest;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class ObservabilityPipelinesApi {
    private ApiClient apiClient;

    public ObservabilityPipelinesApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public ObservabilityPipelinesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ObservabilityPipeline createPipeline(ObservabilityPipelineCreateRequest body) throws ApiException {
        return this.createPipelineWithHttpInfo(body).getData();
    }

    public CompletableFuture<ObservabilityPipeline> createPipelineAsync(ObservabilityPipelineCreateRequest body) {
        return this.createPipelineWithHttpInfoAsync(body).thenApply(response -> (ObservabilityPipeline)response.getData());
    }

    public ApiResponse<ObservabilityPipeline> createPipelineWithHttpInfo(ObservabilityPipelineCreateRequest body) throws ApiException {
        String operationId = "createPipeline";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        ObservabilityPipelineCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createPipeline");
        }
        String localVarPath = "/api/v2/remote_config/products/obs_pipelines/pipelines";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ObservabilityPipelinesApi.createPipeline", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ObservabilityPipeline>(){});
    }

    public CompletableFuture<ApiResponse<ObservabilityPipeline>> createPipelineWithHttpInfoAsync(ObservabilityPipelineCreateRequest body) {
        Invocation.Builder builder;
        String operationId = "createPipeline";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<ObservabilityPipeline>> result = new CompletableFuture<ApiResponse<ObservabilityPipeline>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        ObservabilityPipelineCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<ObservabilityPipeline>> result = new CompletableFuture<ApiResponse<ObservabilityPipeline>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createPipeline"));
            return result;
        }
        String localVarPath = "/api/v2/remote_config/products/obs_pipelines/pipelines";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ObservabilityPipelinesApi.createPipeline", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ObservabilityPipeline>> result = new CompletableFuture<ApiResponse<ObservabilityPipeline>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ObservabilityPipeline>(){});
    }

    public void deletePipeline(String pipelineId) throws ApiException {
        this.deletePipelineWithHttpInfo(pipelineId);
    }

    public CompletableFuture<Void> deletePipelineAsync(String pipelineId) {
        return this.deletePipelineWithHttpInfoAsync(pipelineId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deletePipelineWithHttpInfo(String pipelineId) throws ApiException {
        String operationId = "deletePipeline";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (pipelineId == null) {
            throw new ApiException(400, "Missing the required parameter 'pipelineId' when calling deletePipeline");
        }
        String localVarPath = "/api/v2/remote_config/products/obs_pipelines/pipelines/{pipeline_id}".replaceAll("\\{pipeline_id\\}", this.apiClient.escapeString(pipelineId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ObservabilityPipelinesApi.deletePipeline", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deletePipelineWithHttpInfoAsync(String pipelineId) {
        Invocation.Builder builder;
        String operationId = "deletePipeline";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (pipelineId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'pipelineId' when calling deletePipeline"));
            return result;
        }
        String localVarPath = "/api/v2/remote_config/products/obs_pipelines/pipelines/{pipeline_id}".replaceAll("\\{pipeline_id\\}", this.apiClient.escapeString(pipelineId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ObservabilityPipelinesApi.deletePipeline", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public ObservabilityPipeline getPipeline(String pipelineId) throws ApiException {
        return this.getPipelineWithHttpInfo(pipelineId).getData();
    }

    public CompletableFuture<ObservabilityPipeline> getPipelineAsync(String pipelineId) {
        return this.getPipelineWithHttpInfoAsync(pipelineId).thenApply(response -> (ObservabilityPipeline)response.getData());
    }

    public ApiResponse<ObservabilityPipeline> getPipelineWithHttpInfo(String pipelineId) throws ApiException {
        String operationId = "getPipeline";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (pipelineId == null) {
            throw new ApiException(400, "Missing the required parameter 'pipelineId' when calling getPipeline");
        }
        String localVarPath = "/api/v2/remote_config/products/obs_pipelines/pipelines/{pipeline_id}".replaceAll("\\{pipeline_id\\}", this.apiClient.escapeString(pipelineId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ObservabilityPipelinesApi.getPipeline", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ObservabilityPipeline>(){});
    }

    public CompletableFuture<ApiResponse<ObservabilityPipeline>> getPipelineWithHttpInfoAsync(String pipelineId) {
        Invocation.Builder builder;
        String operationId = "getPipeline";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<ObservabilityPipeline>> result = new CompletableFuture<ApiResponse<ObservabilityPipeline>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (pipelineId == null) {
            CompletableFuture<ApiResponse<ObservabilityPipeline>> result = new CompletableFuture<ApiResponse<ObservabilityPipeline>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'pipelineId' when calling getPipeline"));
            return result;
        }
        String localVarPath = "/api/v2/remote_config/products/obs_pipelines/pipelines/{pipeline_id}".replaceAll("\\{pipeline_id\\}", this.apiClient.escapeString(pipelineId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ObservabilityPipelinesApi.getPipeline", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ObservabilityPipeline>> result = new CompletableFuture<ApiResponse<ObservabilityPipeline>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ObservabilityPipeline>(){});
    }

    public ObservabilityPipeline updatePipeline(String pipelineId, ObservabilityPipeline body) throws ApiException {
        return this.updatePipelineWithHttpInfo(pipelineId, body).getData();
    }

    public CompletableFuture<ObservabilityPipeline> updatePipelineAsync(String pipelineId, ObservabilityPipeline body) {
        return this.updatePipelineWithHttpInfoAsync(pipelineId, body).thenApply(response -> (ObservabilityPipeline)response.getData());
    }

    public ApiResponse<ObservabilityPipeline> updatePipelineWithHttpInfo(String pipelineId, ObservabilityPipeline body) throws ApiException {
        String operationId = "updatePipeline";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        ObservabilityPipeline localVarPostBody = body;
        if (pipelineId == null) {
            throw new ApiException(400, "Missing the required parameter 'pipelineId' when calling updatePipeline");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updatePipeline");
        }
        String localVarPath = "/api/v2/remote_config/products/obs_pipelines/pipelines/{pipeline_id}".replaceAll("\\{pipeline_id\\}", this.apiClient.escapeString(pipelineId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ObservabilityPipelinesApi.updatePipeline", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ObservabilityPipeline>(){});
    }

    public CompletableFuture<ApiResponse<ObservabilityPipeline>> updatePipelineWithHttpInfoAsync(String pipelineId, ObservabilityPipeline body) {
        Invocation.Builder builder;
        String operationId = "updatePipeline";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<ObservabilityPipeline>> result = new CompletableFuture<ApiResponse<ObservabilityPipeline>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        ObservabilityPipeline localVarPostBody = body;
        if (pipelineId == null) {
            CompletableFuture<ApiResponse<ObservabilityPipeline>> result = new CompletableFuture<ApiResponse<ObservabilityPipeline>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'pipelineId' when calling updatePipeline"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<ObservabilityPipeline>> result = new CompletableFuture<ApiResponse<ObservabilityPipeline>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updatePipeline"));
            return result;
        }
        String localVarPath = "/api/v2/remote_config/products/obs_pipelines/pipelines/{pipeline_id}".replaceAll("\\{pipeline_id\\}", this.apiClient.escapeString(pipelineId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ObservabilityPipelinesApi.updatePipeline", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ObservabilityPipeline>> result = new CompletableFuture<ApiResponse<ObservabilityPipeline>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ObservabilityPipeline>(){});
    }
}

