/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.DeployAppResponse;
import com.datadog.api.client.v2.model.DisableAppResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class AppDeploymentApi {
    private ApiClient apiClient;

    public AppDeploymentApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public AppDeploymentApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public DeployAppResponse deployApp(String appId) throws ApiException {
        return this.deployAppWithHttpInfo(appId).getData();
    }

    public CompletableFuture<DeployAppResponse> deployAppAsync(String appId) {
        return this.deployAppWithHttpInfoAsync(appId).thenApply(response -> (DeployAppResponse)response.getData());
    }

    public ApiResponse<DeployAppResponse> deployAppWithHttpInfo(String appId) throws ApiException {
        String operationId = "deployApp";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling deployApp");
        }
        String localVarPath = "/api/v2/app-builder/apps/{app_id}/deployment".replaceAll("\\{app_id\\}", this.apiClient.escapeString(appId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AppDeploymentApi.deployApp", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DeployAppResponse>(){});
    }

    public CompletableFuture<ApiResponse<DeployAppResponse>> deployAppWithHttpInfoAsync(String appId) {
        Invocation.Builder builder;
        String operationId = "deployApp";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<DeployAppResponse>> result = new CompletableFuture<ApiResponse<DeployAppResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (appId == null) {
            CompletableFuture<ApiResponse<DeployAppResponse>> result = new CompletableFuture<ApiResponse<DeployAppResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'appId' when calling deployApp"));
            return result;
        }
        String localVarPath = "/api/v2/app-builder/apps/{app_id}/deployment".replaceAll("\\{app_id\\}", this.apiClient.escapeString(appId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AppDeploymentApi.deployApp", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DeployAppResponse>> result = new CompletableFuture<ApiResponse<DeployAppResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DeployAppResponse>(){});
    }

    public DisableAppResponse disableApp(String appId) throws ApiException {
        return this.disableAppWithHttpInfo(appId).getData();
    }

    public CompletableFuture<DisableAppResponse> disableAppAsync(String appId) {
        return this.disableAppWithHttpInfoAsync(appId).thenApply(response -> (DisableAppResponse)response.getData());
    }

    public ApiResponse<DisableAppResponse> disableAppWithHttpInfo(String appId) throws ApiException {
        String operationId = "disableApp";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling disableApp");
        }
        String localVarPath = "/api/v2/app-builder/apps/{app_id}/deployment".replaceAll("\\{app_id\\}", this.apiClient.escapeString(appId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AppDeploymentApi.disableApp", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DisableAppResponse>(){});
    }

    public CompletableFuture<ApiResponse<DisableAppResponse>> disableAppWithHttpInfoAsync(String appId) {
        Invocation.Builder builder;
        String operationId = "disableApp";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<DisableAppResponse>> result = new CompletableFuture<ApiResponse<DisableAppResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (appId == null) {
            CompletableFuture<ApiResponse<DisableAppResponse>> result = new CompletableFuture<ApiResponse<DisableAppResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'appId' when calling disableApp"));
            return result;
        }
        String localVarPath = "/api/v2/app-builder/apps/{app_id}/deployment".replaceAll("\\{app_id\\}", this.apiClient.escapeString(appId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AppDeploymentApi.disableApp", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DisableAppResponse>> result = new CompletableFuture<ApiResponse<DisableAppResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DisableAppResponse>(){});
    }
}

