/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.DashboardGlobalTime;
import com.datadog.api.client.v1.model.DashboardShareType;
import com.datadog.api.client.v1.model.DashboardType;
import com.datadog.api.client.v1.model.SelectableTemplateVariableItems;
import com.datadog.api.client.v1.model.SharedDashboardAuthor;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"author", "created_at", "dashboard_id", "dashboard_type", "global_time", "global_time_selectable_enabled", "public_url", "selectable_template_vars", "share_list", "share_type", "token"})
public class SharedDashboard {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_AUTHOR = "author";
    private SharedDashboardAuthor author;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_DASHBOARD_ID = "dashboard_id";
    private String dashboardId;
    public static final String JSON_PROPERTY_DASHBOARD_TYPE = "dashboard_type";
    private DashboardType dashboardType;
    public static final String JSON_PROPERTY_GLOBAL_TIME = "global_time";
    private DashboardGlobalTime globalTime;
    public static final String JSON_PROPERTY_GLOBAL_TIME_SELECTABLE_ENABLED = "global_time_selectable_enabled";
    private JsonNullable<Boolean> globalTimeSelectableEnabled = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PUBLIC_URL = "public_url";
    private String publicUrl;
    public static final String JSON_PROPERTY_SELECTABLE_TEMPLATE_VARS = "selectable_template_vars";
    private JsonNullable<List<SelectableTemplateVariableItems>> selectableTemplateVars = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SHARE_LIST = "share_list";
    private JsonNullable<List<String>> shareList = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SHARE_TYPE = "share_type";
    private JsonNullable<DashboardShareType> shareType = JsonNullable.undefined();
    public static final String JSON_PROPERTY_TOKEN = "token";
    private String token;
    private Map<String, Object> additionalProperties;

    public SharedDashboard() {
    }

    @JsonCreator
    public SharedDashboard(@JsonProperty(required=true, value="dashboard_id") String dashboardId, @JsonProperty(required=true, value="dashboard_type") DashboardType dashboardType) {
        this.dashboardId = dashboardId;
        this.dashboardType = dashboardType;
        this.unparsed |= !dashboardType.isValid();
    }

    @Nullable
    @JsonProperty(value="author")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SharedDashboardAuthor getAuthor() {
        return this.author;
    }

    @Nullable
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public SharedDashboard dashboardId(String dashboardId) {
        this.dashboardId = dashboardId;
        return this;
    }

    @JsonProperty(value="dashboard_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDashboardId() {
        return this.dashboardId;
    }

    public void setDashboardId(String dashboardId) {
        this.dashboardId = dashboardId;
    }

    public SharedDashboard dashboardType(DashboardType dashboardType) {
        this.dashboardType = dashboardType;
        this.unparsed |= !dashboardType.isValid();
        return this;
    }

    @JsonProperty(value="dashboard_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public DashboardType getDashboardType() {
        return this.dashboardType;
    }

    public void setDashboardType(DashboardType dashboardType) {
        if (!dashboardType.isValid()) {
            this.unparsed = true;
        }
        this.dashboardType = dashboardType;
    }

    public SharedDashboard globalTime(DashboardGlobalTime globalTime) {
        this.globalTime = globalTime;
        this.unparsed |= globalTime.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="global_time")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DashboardGlobalTime getGlobalTime() {
        return this.globalTime;
    }

    public void setGlobalTime(DashboardGlobalTime globalTime) {
        this.globalTime = globalTime;
    }

    public SharedDashboard globalTimeSelectableEnabled(Boolean globalTimeSelectableEnabled) {
        this.globalTimeSelectableEnabled = JsonNullable.of((Object)globalTimeSelectableEnabled);
        return this;
    }

    @Nullable
    @JsonIgnore
    public Boolean getGlobalTimeSelectableEnabled() {
        return (Boolean)this.globalTimeSelectableEnabled.orElse(null);
    }

    @JsonProperty(value="global_time_selectable_enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Boolean> getGlobalTimeSelectableEnabled_JsonNullable() {
        return this.globalTimeSelectableEnabled;
    }

    @JsonProperty(value="global_time_selectable_enabled")
    public void setGlobalTimeSelectableEnabled_JsonNullable(JsonNullable<Boolean> globalTimeSelectableEnabled) {
        this.globalTimeSelectableEnabled = globalTimeSelectableEnabled;
    }

    public void setGlobalTimeSelectableEnabled(Boolean globalTimeSelectableEnabled) {
        this.globalTimeSelectableEnabled = JsonNullable.of((Object)globalTimeSelectableEnabled);
    }

    @Nullable
    @JsonProperty(value="public_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPublicUrl() {
        return this.publicUrl;
    }

    public SharedDashboard selectableTemplateVars(List<SelectableTemplateVariableItems> selectableTemplateVars) {
        this.selectableTemplateVars = JsonNullable.of(selectableTemplateVars);
        return this;
    }

    public SharedDashboard addSelectableTemplateVarsItem(SelectableTemplateVariableItems selectableTemplateVarsItem) {
        if (this.selectableTemplateVars == null || !this.selectableTemplateVars.isPresent()) {
            this.selectableTemplateVars = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.selectableTemplateVars.get()).add(selectableTemplateVarsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @JsonIgnore
    public List<SelectableTemplateVariableItems> getSelectableTemplateVars() {
        return (List)this.selectableTemplateVars.orElse(null);
    }

    @JsonProperty(value="selectable_template_vars")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<SelectableTemplateVariableItems>> getSelectableTemplateVars_JsonNullable() {
        return this.selectableTemplateVars;
    }

    @JsonProperty(value="selectable_template_vars")
    public void setSelectableTemplateVars_JsonNullable(JsonNullable<List<SelectableTemplateVariableItems>> selectableTemplateVars) {
        this.selectableTemplateVars = selectableTemplateVars;
    }

    public void setSelectableTemplateVars(List<SelectableTemplateVariableItems> selectableTemplateVars) {
        this.selectableTemplateVars = JsonNullable.of(selectableTemplateVars);
    }

    public SharedDashboard shareList(List<String> shareList) {
        this.shareList = JsonNullable.of(shareList);
        return this;
    }

    public SharedDashboard addShareListItem(String shareListItem) {
        if (this.shareList == null || !this.shareList.isPresent()) {
            this.shareList = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.shareList.get()).add(shareListItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @JsonIgnore
    public List<String> getShareList() {
        return (List)this.shareList.orElse(null);
    }

    @JsonProperty(value="share_list")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getShareList_JsonNullable() {
        return this.shareList;
    }

    @JsonProperty(value="share_list")
    public void setShareList_JsonNullable(JsonNullable<List<String>> shareList) {
        this.shareList = shareList;
    }

    public void setShareList(List<String> shareList) {
        this.shareList = JsonNullable.of(shareList);
    }

    public SharedDashboard shareType(DashboardShareType shareType) {
        this.shareType = JsonNullable.of((Object)shareType);
        return this;
    }

    @Nullable
    @JsonIgnore
    public DashboardShareType getShareType() {
        return (DashboardShareType)this.shareType.orElse(null);
    }

    @JsonProperty(value="share_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<DashboardShareType> getShareType_JsonNullable() {
        return this.shareType;
    }

    @JsonProperty(value="share_type")
    public void setShareType_JsonNullable(JsonNullable<DashboardShareType> shareType) {
        this.shareType = shareType;
    }

    public void setShareType(DashboardShareType shareType) {
        if (!shareType.isValid()) {
            this.unparsed = true;
        }
        this.shareType = JsonNullable.of((Object)shareType);
    }

    @Nullable
    @JsonProperty(value="token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getToken() {
        return this.token;
    }

    @JsonAnySetter
    public SharedDashboard putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SharedDashboard sharedDashboard = (SharedDashboard)o;
        return Objects.equals(this.author, sharedDashboard.author) && Objects.equals(this.createdAt, sharedDashboard.createdAt) && Objects.equals(this.dashboardId, sharedDashboard.dashboardId) && Objects.equals(this.dashboardType, sharedDashboard.dashboardType) && Objects.equals(this.globalTime, sharedDashboard.globalTime) && Objects.equals(this.globalTimeSelectableEnabled, sharedDashboard.globalTimeSelectableEnabled) && Objects.equals(this.publicUrl, sharedDashboard.publicUrl) && Objects.equals(this.selectableTemplateVars, sharedDashboard.selectableTemplateVars) && Objects.equals(this.shareList, sharedDashboard.shareList) && Objects.equals(this.shareType, sharedDashboard.shareType) && Objects.equals(this.token, sharedDashboard.token) && Objects.equals(this.additionalProperties, sharedDashboard.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.author, this.createdAt, this.dashboardId, this.dashboardType, this.globalTime, this.globalTimeSelectableEnabled, this.publicUrl, this.selectableTemplateVars, this.shareList, this.shareType, this.token, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SharedDashboard {\n");
        sb.append("    author: ").append(this.toIndentedString(this.author)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    dashboardId: ").append(this.toIndentedString(this.dashboardId)).append("\n");
        sb.append("    dashboardType: ").append(this.toIndentedString(this.dashboardType)).append("\n");
        sb.append("    globalTime: ").append(this.toIndentedString(this.globalTime)).append("\n");
        sb.append("    globalTimeSelectableEnabled: ").append(this.toIndentedString(this.globalTimeSelectableEnabled)).append("\n");
        sb.append("    publicUrl: ").append(this.toIndentedString(this.publicUrl)).append("\n");
        sb.append("    selectableTemplateVars: ").append(this.toIndentedString(this.selectableTemplateVars)).append("\n");
        sb.append("    shareList: ").append(this.toIndentedString(this.shareList)).append("\n");
        sb.append("    shareType: ").append(this.toIndentedString(this.shareType)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

