/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"host", "interval", "metric", "points", "tags", "type"})
public class Series {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_HOST = "host";
    private String host;
    public static final String JSON_PROPERTY_INTERVAL = "interval";
    private JsonNullable<Long> interval = JsonNullable.undefined();
    public static final String JSON_PROPERTY_METRIC = "metric";
    private String metric;
    public static final String JSON_PROPERTY_POINTS = "points";
    private List<List<Double>> points = new ArrayList<List<Double>>();
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type = "";
    private Map<String, Object> additionalProperties;

    public Series() {
    }

    @JsonCreator
    public Series(@JsonProperty(required=true, value="metric") String metric, @JsonProperty(required=true, value="points") List<List<Double>> points) {
        this.metric = metric;
        this.points = points;
    }

    public Series host(String host) {
        this.host = host;
        return this;
    }

    @Nullable
    @JsonProperty(value="host")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Series interval(Long interval) {
        this.interval = JsonNullable.of((Object)interval);
        return this;
    }

    @Nullable
    @JsonIgnore
    public Long getInterval() {
        return (Long)this.interval.orElse(null);
    }

    @JsonProperty(value="interval")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Long> getInterval_JsonNullable() {
        return this.interval;
    }

    @JsonProperty(value="interval")
    public void setInterval_JsonNullable(JsonNullable<Long> interval) {
        this.interval = interval;
    }

    public void setInterval(Long interval) {
        this.interval = JsonNullable.of((Object)interval);
    }

    public Series metric(String metric) {
        this.metric = metric;
        return this;
    }

    @JsonProperty(value="metric")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getMetric() {
        return this.metric;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public Series points(List<List<Double>> points) {
        this.points = points;
        return this;
    }

    public Series addPointsItem(List<Double> pointsItem) {
        this.points.add(pointsItem);
        return this;
    }

    @JsonProperty(value="points")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<List<Double>> getPoints() {
        return this.points;
    }

    public void setPoints(List<List<Double>> points) {
        this.points = points;
    }

    public Series tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public Series addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public Series type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @JsonAnySetter
    public Series putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Series series = (Series)o;
        return Objects.equals(this.host, series.host) && Objects.equals(this.interval, series.interval) && Objects.equals(this.metric, series.metric) && Objects.equals(this.points, series.points) && Objects.equals(this.tags, series.tags) && Objects.equals(this.type, series.type) && Objects.equals(this.additionalProperties, series.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.interval, this.metric, this.points, this.tags, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Series {\n");
        sb.append("    host: ").append(this.toIndentedString(this.host)).append("\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    metric: ").append(this.toIndentedString(this.metric)).append("\n");
        sb.append("    points: ").append(this.toIndentedString(this.points)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

