/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v1.model.PagerDutyService;
import com.datadog.api.client.v1.model.PagerDutyServiceKey;
import com.datadog.api.client.v1.model.PagerDutyServiceName;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class PagerDutyIntegrationApi {
    private ApiClient apiClient;

    public PagerDutyIntegrationApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public PagerDutyIntegrationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public PagerDutyServiceName createPagerDutyIntegrationService(PagerDutyService body) throws ApiException {
        return this.createPagerDutyIntegrationServiceWithHttpInfo(body).getData();
    }

    public CompletableFuture<PagerDutyServiceName> createPagerDutyIntegrationServiceAsync(PagerDutyService body) {
        return this.createPagerDutyIntegrationServiceWithHttpInfoAsync(body).thenApply(response -> (PagerDutyServiceName)response.getData());
    }

    public ApiResponse<PagerDutyServiceName> createPagerDutyIntegrationServiceWithHttpInfo(PagerDutyService body) throws ApiException {
        PagerDutyService localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createPagerDutyIntegrationService");
        }
        String localVarPath = "/api/v1/integration/pagerduty/configuration/services";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.PagerDutyIntegrationApi.createPagerDutyIntegrationService", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<PagerDutyServiceName>(){});
    }

    public CompletableFuture<ApiResponse<PagerDutyServiceName>> createPagerDutyIntegrationServiceWithHttpInfoAsync(PagerDutyService body) {
        Invocation.Builder builder;
        PagerDutyService localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<PagerDutyServiceName>> result = new CompletableFuture<ApiResponse<PagerDutyServiceName>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createPagerDutyIntegrationService"));
            return result;
        }
        String localVarPath = "/api/v1/integration/pagerduty/configuration/services";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("PagerDutyIntegrationApi.createPagerDutyIntegrationService", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<PagerDutyServiceName>> result = new CompletableFuture<ApiResponse<PagerDutyServiceName>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<PagerDutyServiceName>(){});
    }

    public void deletePagerDutyIntegrationService(String serviceName) throws ApiException {
        this.deletePagerDutyIntegrationServiceWithHttpInfo(serviceName);
    }

    public CompletableFuture<Void> deletePagerDutyIntegrationServiceAsync(String serviceName) {
        return this.deletePagerDutyIntegrationServiceWithHttpInfoAsync(serviceName).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deletePagerDutyIntegrationServiceWithHttpInfo(String serviceName) throws ApiException {
        Object localVarPostBody = null;
        if (serviceName == null) {
            throw new ApiException(400, "Missing the required parameter 'serviceName' when calling deletePagerDutyIntegrationService");
        }
        String localVarPath = "/api/v1/integration/pagerduty/configuration/services/{service_name}".replaceAll("\\{service_name\\}", this.apiClient.escapeString(serviceName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.PagerDutyIntegrationApi.deletePagerDutyIntegrationService", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deletePagerDutyIntegrationServiceWithHttpInfoAsync(String serviceName) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (serviceName == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'serviceName' when calling deletePagerDutyIntegrationService"));
            return result;
        }
        String localVarPath = "/api/v1/integration/pagerduty/configuration/services/{service_name}".replaceAll("\\{service_name\\}", this.apiClient.escapeString(serviceName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("PagerDutyIntegrationApi.deletePagerDutyIntegrationService", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public PagerDutyServiceName getPagerDutyIntegrationService(String serviceName) throws ApiException {
        return this.getPagerDutyIntegrationServiceWithHttpInfo(serviceName).getData();
    }

    public CompletableFuture<PagerDutyServiceName> getPagerDutyIntegrationServiceAsync(String serviceName) {
        return this.getPagerDutyIntegrationServiceWithHttpInfoAsync(serviceName).thenApply(response -> (PagerDutyServiceName)response.getData());
    }

    public ApiResponse<PagerDutyServiceName> getPagerDutyIntegrationServiceWithHttpInfo(String serviceName) throws ApiException {
        Object localVarPostBody = null;
        if (serviceName == null) {
            throw new ApiException(400, "Missing the required parameter 'serviceName' when calling getPagerDutyIntegrationService");
        }
        String localVarPath = "/api/v1/integration/pagerduty/configuration/services/{service_name}".replaceAll("\\{service_name\\}", this.apiClient.escapeString(serviceName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.PagerDutyIntegrationApi.getPagerDutyIntegrationService", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<PagerDutyServiceName>(){});
    }

    public CompletableFuture<ApiResponse<PagerDutyServiceName>> getPagerDutyIntegrationServiceWithHttpInfoAsync(String serviceName) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (serviceName == null) {
            CompletableFuture<ApiResponse<PagerDutyServiceName>> result = new CompletableFuture<ApiResponse<PagerDutyServiceName>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'serviceName' when calling getPagerDutyIntegrationService"));
            return result;
        }
        String localVarPath = "/api/v1/integration/pagerduty/configuration/services/{service_name}".replaceAll("\\{service_name\\}", this.apiClient.escapeString(serviceName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("PagerDutyIntegrationApi.getPagerDutyIntegrationService", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<PagerDutyServiceName>> result = new CompletableFuture<ApiResponse<PagerDutyServiceName>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<PagerDutyServiceName>(){});
    }

    public void updatePagerDutyIntegrationService(String serviceName, PagerDutyServiceKey body) throws ApiException {
        this.updatePagerDutyIntegrationServiceWithHttpInfo(serviceName, body);
    }

    public CompletableFuture<Void> updatePagerDutyIntegrationServiceAsync(String serviceName, PagerDutyServiceKey body) {
        return this.updatePagerDutyIntegrationServiceWithHttpInfoAsync(serviceName, body).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> updatePagerDutyIntegrationServiceWithHttpInfo(String serviceName, PagerDutyServiceKey body) throws ApiException {
        PagerDutyServiceKey localVarPostBody = body;
        if (serviceName == null) {
            throw new ApiException(400, "Missing the required parameter 'serviceName' when calling updatePagerDutyIntegrationService");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updatePagerDutyIntegrationService");
        }
        String localVarPath = "/api/v1/integration/pagerduty/configuration/services/{service_name}".replaceAll("\\{service_name\\}", this.apiClient.escapeString(serviceName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.PagerDutyIntegrationApi.updatePagerDutyIntegrationService", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> updatePagerDutyIntegrationServiceWithHttpInfoAsync(String serviceName, PagerDutyServiceKey body) {
        Invocation.Builder builder;
        PagerDutyServiceKey localVarPostBody = body;
        if (serviceName == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'serviceName' when calling updatePagerDutyIntegrationService"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updatePagerDutyIntegrationService"));
            return result;
        }
        String localVarPath = "/api/v1/integration/pagerduty/configuration/services/{service_name}".replaceAll("\\{service_name\\}", this.apiClient.escapeString(serviceName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("PagerDutyIntegrationApi.updatePagerDutyIntegrationService", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }
}

