/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.CaseCreateAttributes;
import com.datadog.api.client.v2.model.CaseCreateRelationships;
import com.datadog.api.client.v2.model.CaseResourceType;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"attributes", "relationships", "type"})
public class CaseCreate {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private CaseCreateAttributes attributes;
    public static final String JSON_PROPERTY_RELATIONSHIPS = "relationships";
    private CaseCreateRelationships relationships;
    public static final String JSON_PROPERTY_TYPE = "type";
    private CaseResourceType type = CaseResourceType.CASE;
    private Map<String, Object> additionalProperties;

    public CaseCreate() {
    }

    @JsonCreator
    public CaseCreate(@JsonProperty(required=true, value="attributes") CaseCreateAttributes attributes, @JsonProperty(required=true, value="type") CaseResourceType type) {
        this.attributes = attributes;
        this.unparsed |= attributes.unparsed;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public CaseCreate attributes(CaseCreateAttributes attributes) {
        this.attributes = attributes;
        this.unparsed |= attributes.unparsed;
        return this;
    }

    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CaseCreateAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(CaseCreateAttributes attributes) {
        this.attributes = attributes;
    }

    public CaseCreate relationships(CaseCreateRelationships relationships) {
        this.relationships = relationships;
        this.unparsed |= relationships.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="relationships")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CaseCreateRelationships getRelationships() {
        return this.relationships;
    }

    public void setRelationships(CaseCreateRelationships relationships) {
        this.relationships = relationships;
    }

    public CaseCreate type(CaseResourceType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CaseResourceType getType() {
        return this.type;
    }

    public void setType(CaseResourceType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public CaseCreate putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CaseCreate caseCreate = (CaseCreate)o;
        return Objects.equals(this.attributes, caseCreate.attributes) && Objects.equals(this.relationships, caseCreate.relationships) && Objects.equals(this.type, caseCreate.type) && Objects.equals(this.additionalProperties, caseCreate.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.relationships, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CaseCreate {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    relationships: ").append(this.toIndentedString(this.relationships)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

