/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.Unit;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"group_tags", "query_index", "unit"})
public class TimeseriesResponseSeries {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_GROUP_TAGS = "group_tags";
    private List<String> groupTags = null;
    public static final String JSON_PROPERTY_QUERY_INDEX = "query_index";
    private Integer queryIndex;
    public static final String JSON_PROPERTY_UNIT = "unit";
    private List<Unit> unit = null;
    private Map<String, Object> additionalProperties;

    public TimeseriesResponseSeries groupTags(List<String> groupTags) {
        this.groupTags = groupTags;
        return this;
    }

    public TimeseriesResponseSeries addGroupTagsItem(String groupTagsItem) {
        if (this.groupTags == null) {
            this.groupTags = new ArrayList<String>();
        }
        this.groupTags.add(groupTagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="group_tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getGroupTags() {
        return this.groupTags;
    }

    public void setGroupTags(List<String> groupTags) {
        this.groupTags = groupTags;
    }

    public TimeseriesResponseSeries queryIndex(Integer queryIndex) {
        this.queryIndex = queryIndex;
        return this;
    }

    @Nullable
    @JsonProperty(value="query_index")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getQueryIndex() {
        return this.queryIndex;
    }

    public void setQueryIndex(Integer queryIndex) {
        this.queryIndex = queryIndex;
    }

    public TimeseriesResponseSeries unit(List<Unit> unit) {
        this.unit = unit;
        for (Unit item : unit) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public TimeseriesResponseSeries addUnitItem(Unit unitItem) {
        if (this.unit == null) {
            this.unit = new ArrayList<Unit>();
        }
        this.unit.add(unitItem);
        this.unparsed |= unitItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="unit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Unit> getUnit() {
        return this.unit;
    }

    public void setUnit(List<Unit> unit) {
        this.unit = unit;
    }

    @JsonAnySetter
    public TimeseriesResponseSeries putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeseriesResponseSeries timeseriesResponseSeries = (TimeseriesResponseSeries)o;
        return Objects.equals(this.groupTags, timeseriesResponseSeries.groupTags) && Objects.equals(this.queryIndex, timeseriesResponseSeries.queryIndex) && Objects.equals(this.unit, timeseriesResponseSeries.unit) && Objects.equals(this.additionalProperties, timeseriesResponseSeries.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.groupTags, this.queryIndex, this.unit, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TimeseriesResponseSeries {\n");
        sb.append("    groupTags: ").append(this.toIndentedString(this.groupTags)).append("\n");
        sb.append("    queryIndex: ").append(this.toIndentedString(this.queryIndex)).append("\n");
        sb.append("    unit: ").append(this.toIndentedString(this.unit)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

