/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.State;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"created_at", "modified_at", "remarks", "service_name", "state"})
public class OutcomesBatchResponseAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_MODIFIED_AT = "modified_at";
    private OffsetDateTime modifiedAt;
    public static final String JSON_PROPERTY_REMARKS = "remarks";
    private String remarks;
    public static final String JSON_PROPERTY_SERVICE_NAME = "service_name";
    private String serviceName;
    public static final String JSON_PROPERTY_STATE = "state";
    private State state;
    private Map<String, Object> additionalProperties;

    public OutcomesBatchResponseAttributes createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public OutcomesBatchResponseAttributes modifiedAt(OffsetDateTime modifiedAt) {
        this.modifiedAt = modifiedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="modified_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getModifiedAt() {
        return this.modifiedAt;
    }

    public void setModifiedAt(OffsetDateTime modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    public OutcomesBatchResponseAttributes remarks(String remarks) {
        this.remarks = remarks;
        return this;
    }

    @Nullable
    @JsonProperty(value="remarks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public OutcomesBatchResponseAttributes serviceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    @Nullable
    @JsonProperty(value="service_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public OutcomesBatchResponseAttributes state(State state) {
        this.state = state;
        this.unparsed |= !state.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        if (!state.isValid()) {
            this.unparsed = true;
        }
        this.state = state;
    }

    @JsonAnySetter
    public OutcomesBatchResponseAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutcomesBatchResponseAttributes outcomesBatchResponseAttributes = (OutcomesBatchResponseAttributes)o;
        return Objects.equals(this.createdAt, outcomesBatchResponseAttributes.createdAt) && Objects.equals(this.modifiedAt, outcomesBatchResponseAttributes.modifiedAt) && Objects.equals(this.remarks, outcomesBatchResponseAttributes.remarks) && Objects.equals(this.serviceName, outcomesBatchResponseAttributes.serviceName) && Objects.equals(this.state, outcomesBatchResponseAttributes.state) && Objects.equals(this.additionalProperties, outcomesBatchResponseAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.modifiedAt, this.remarks, this.serviceName, this.state, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OutcomesBatchResponseAttributes {\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    modifiedAt: ").append(this.toIndentedString(this.modifiedAt)).append("\n");
        sb.append("    remarks: ").append(this.toIndentedString(this.remarks)).append("\n");
        sb.append("    serviceName: ").append(this.toIndentedString(this.serviceName)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

