/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.ChargebackBreakdown;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"charges", "date", "org_name", "public_id", "region", "total_cost"})
public class CostByOrgAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CHARGES = "charges";
    private List<ChargebackBreakdown> charges = null;
    public static final String JSON_PROPERTY_DATE = "date";
    private OffsetDateTime date;
    public static final String JSON_PROPERTY_ORG_NAME = "org_name";
    private String orgName;
    public static final String JSON_PROPERTY_PUBLIC_ID = "public_id";
    private String publicId;
    public static final String JSON_PROPERTY_REGION = "region";
    private String region;
    public static final String JSON_PROPERTY_TOTAL_COST = "total_cost";
    private Double totalCost;
    private Map<String, Object> additionalProperties;

    public CostByOrgAttributes charges(List<ChargebackBreakdown> charges) {
        this.charges = charges;
        for (ChargebackBreakdown item : charges) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public CostByOrgAttributes addChargesItem(ChargebackBreakdown chargesItem) {
        if (this.charges == null) {
            this.charges = new ArrayList<ChargebackBreakdown>();
        }
        this.charges.add(chargesItem);
        this.unparsed |= chargesItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="charges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ChargebackBreakdown> getCharges() {
        return this.charges;
    }

    public void setCharges(List<ChargebackBreakdown> charges) {
        this.charges = charges;
    }

    public CostByOrgAttributes date(OffsetDateTime date) {
        this.date = date;
        return this;
    }

    @Nullable
    @JsonProperty(value="date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getDate() {
        return this.date;
    }

    public void setDate(OffsetDateTime date) {
        this.date = date;
    }

    public CostByOrgAttributes orgName(String orgName) {
        this.orgName = orgName;
        return this;
    }

    @Nullable
    @JsonProperty(value="org_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public CostByOrgAttributes publicId(String publicId) {
        this.publicId = publicId;
        return this;
    }

    @Nullable
    @JsonProperty(value="public_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPublicId() {
        return this.publicId;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public CostByOrgAttributes region(String region) {
        this.region = region;
        return this;
    }

    @Nullable
    @JsonProperty(value="region")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public CostByOrgAttributes totalCost(Double totalCost) {
        this.totalCost = totalCost;
        return this;
    }

    @Nullable
    @JsonProperty(value="total_cost")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getTotalCost() {
        return this.totalCost;
    }

    public void setTotalCost(Double totalCost) {
        this.totalCost = totalCost;
    }

    @JsonAnySetter
    public CostByOrgAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CostByOrgAttributes costByOrgAttributes = (CostByOrgAttributes)o;
        return Objects.equals(this.charges, costByOrgAttributes.charges) && Objects.equals(this.date, costByOrgAttributes.date) && Objects.equals(this.orgName, costByOrgAttributes.orgName) && Objects.equals(this.publicId, costByOrgAttributes.publicId) && Objects.equals(this.region, costByOrgAttributes.region) && Objects.equals(this.totalCost, costByOrgAttributes.totalCost) && Objects.equals(this.additionalProperties, costByOrgAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.charges, this.date, this.orgName, this.publicId, this.region, this.totalCost, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CostByOrgAttributes {\n");
        sb.append("    charges: ").append(this.toIndentedString(this.charges)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    orgName: ").append(this.toIndentedString(this.orgName)).append("\n");
        sb.append("    publicId: ").append(this.toIndentedString(this.publicId)).append("\n");
        sb.append("    region: ").append(this.toIndentedString(this.region)).append("\n");
        sb.append("    totalCost: ").append(this.toIndentedString(this.totalCost)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

