/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.SLORawErrorBudgetRemaining;
import com.datadog.api.client.v1.model.SLOState;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"calculation_error", "error_budget_remaining", "indexed_at", "raw_error_budget_remaining", "sli", "span_precision", "state"})
public class SLOStatus {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CALCULATION_ERROR = "calculation_error";
    private JsonNullable<String> calculationError = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ERROR_BUDGET_REMAINING = "error_budget_remaining";
    private JsonNullable<Double> errorBudgetRemaining = JsonNullable.undefined();
    public static final String JSON_PROPERTY_INDEXED_AT = "indexed_at";
    private Long indexedAt;
    public static final String JSON_PROPERTY_RAW_ERROR_BUDGET_REMAINING = "raw_error_budget_remaining";
    private JsonNullable<SLORawErrorBudgetRemaining> rawErrorBudgetRemaining = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SLI = "sli";
    private JsonNullable<Double> sli = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SPAN_PRECISION = "span_precision";
    private JsonNullable<Long> spanPrecision = JsonNullable.undefined();
    public static final String JSON_PROPERTY_STATE = "state";
    private SLOState state;
    private Map<String, Object> additionalProperties;

    public SLOStatus calculationError(String calculationError) {
        this.calculationError = JsonNullable.of((Object)calculationError);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getCalculationError() {
        return (String)this.calculationError.orElse(null);
    }

    @JsonProperty(value="calculation_error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getCalculationError_JsonNullable() {
        return this.calculationError;
    }

    @JsonProperty(value="calculation_error")
    public void setCalculationError_JsonNullable(JsonNullable<String> calculationError) {
        this.calculationError = calculationError;
    }

    public void setCalculationError(String calculationError) {
        this.calculationError = JsonNullable.of((Object)calculationError);
    }

    public SLOStatus errorBudgetRemaining(Double errorBudgetRemaining) {
        this.errorBudgetRemaining = JsonNullable.of((Object)errorBudgetRemaining);
        return this;
    }

    @Nullable
    @JsonIgnore
    public Double getErrorBudgetRemaining() {
        return (Double)this.errorBudgetRemaining.orElse(null);
    }

    @JsonProperty(value="error_budget_remaining")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Double> getErrorBudgetRemaining_JsonNullable() {
        return this.errorBudgetRemaining;
    }

    @JsonProperty(value="error_budget_remaining")
    public void setErrorBudgetRemaining_JsonNullable(JsonNullable<Double> errorBudgetRemaining) {
        this.errorBudgetRemaining = errorBudgetRemaining;
    }

    public void setErrorBudgetRemaining(Double errorBudgetRemaining) {
        this.errorBudgetRemaining = JsonNullable.of((Object)errorBudgetRemaining);
    }

    public SLOStatus indexedAt(Long indexedAt) {
        this.indexedAt = indexedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="indexed_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getIndexedAt() {
        return this.indexedAt;
    }

    public void setIndexedAt(Long indexedAt) {
        this.indexedAt = indexedAt;
    }

    public SLOStatus rawErrorBudgetRemaining(SLORawErrorBudgetRemaining rawErrorBudgetRemaining) {
        this.rawErrorBudgetRemaining = JsonNullable.of((Object)rawErrorBudgetRemaining);
        return this;
    }

    @Nullable
    @JsonIgnore
    public SLORawErrorBudgetRemaining getRawErrorBudgetRemaining() {
        return (SLORawErrorBudgetRemaining)this.rawErrorBudgetRemaining.orElse(null);
    }

    @JsonProperty(value="raw_error_budget_remaining")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<SLORawErrorBudgetRemaining> getRawErrorBudgetRemaining_JsonNullable() {
        return this.rawErrorBudgetRemaining;
    }

    @JsonProperty(value="raw_error_budget_remaining")
    public void setRawErrorBudgetRemaining_JsonNullable(JsonNullable<SLORawErrorBudgetRemaining> rawErrorBudgetRemaining) {
        this.rawErrorBudgetRemaining = rawErrorBudgetRemaining;
    }

    public void setRawErrorBudgetRemaining(SLORawErrorBudgetRemaining rawErrorBudgetRemaining) {
        this.rawErrorBudgetRemaining = JsonNullable.of((Object)rawErrorBudgetRemaining);
    }

    public SLOStatus sli(Double sli) {
        this.sli = JsonNullable.of((Object)sli);
        return this;
    }

    @Nullable
    @JsonIgnore
    public Double getSli() {
        return (Double)this.sli.orElse(null);
    }

    @JsonProperty(value="sli")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Double> getSli_JsonNullable() {
        return this.sli;
    }

    @JsonProperty(value="sli")
    public void setSli_JsonNullable(JsonNullable<Double> sli) {
        this.sli = sli;
    }

    public void setSli(Double sli) {
        this.sli = JsonNullable.of((Object)sli);
    }

    public SLOStatus spanPrecision(Long spanPrecision) {
        this.spanPrecision = JsonNullable.of((Object)spanPrecision);
        return this;
    }

    @Nullable
    @JsonIgnore
    public Long getSpanPrecision() {
        return (Long)this.spanPrecision.orElse(null);
    }

    @JsonProperty(value="span_precision")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Long> getSpanPrecision_JsonNullable() {
        return this.spanPrecision;
    }

    @JsonProperty(value="span_precision")
    public void setSpanPrecision_JsonNullable(JsonNullable<Long> spanPrecision) {
        this.spanPrecision = spanPrecision;
    }

    public void setSpanPrecision(Long spanPrecision) {
        this.spanPrecision = JsonNullable.of((Object)spanPrecision);
    }

    public SLOStatus state(SLOState state) {
        this.state = state;
        this.unparsed |= !state.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SLOState getState() {
        return this.state;
    }

    public void setState(SLOState state) {
        if (!state.isValid()) {
            this.unparsed = true;
        }
        this.state = state;
    }

    @JsonAnySetter
    public SLOStatus putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SLOStatus sloStatus = (SLOStatus)o;
        return Objects.equals(this.calculationError, sloStatus.calculationError) && Objects.equals(this.errorBudgetRemaining, sloStatus.errorBudgetRemaining) && Objects.equals(this.indexedAt, sloStatus.indexedAt) && Objects.equals(this.rawErrorBudgetRemaining, sloStatus.rawErrorBudgetRemaining) && Objects.equals(this.sli, sloStatus.sli) && Objects.equals(this.spanPrecision, sloStatus.spanPrecision) && Objects.equals(this.state, sloStatus.state) && Objects.equals(this.additionalProperties, sloStatus.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.calculationError, this.errorBudgetRemaining, this.indexedAt, this.rawErrorBudgetRemaining, this.sli, this.spanPrecision, this.state, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SLOStatus {\n");
        sb.append("    calculationError: ").append(this.toIndentedString(this.calculationError)).append("\n");
        sb.append("    errorBudgetRemaining: ").append(this.toIndentedString(this.errorBudgetRemaining)).append("\n");
        sb.append("    indexedAt: ").append(this.toIndentedString(this.indexedAt)).append("\n");
        sb.append("    rawErrorBudgetRemaining: ").append(this.toIndentedString(this.rawErrorBudgetRemaining)).append("\n");
        sb.append("    sli: ").append(this.toIndentedString(this.sli)).append("\n");
        sb.append("    spanPrecision: ").append(this.toIndentedString(this.spanPrecision)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

