/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.TimeseriesResponseSeries;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"series", "times", "values"})
public class TimeseriesResponseAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_SERIES = "series";
    private List<TimeseriesResponseSeries> series = null;
    public static final String JSON_PROPERTY_TIMES = "times";
    private List<Long> times = null;
    public static final String JSON_PROPERTY_VALUES = "values";
    private List<List<Double>> values = null;
    private Map<String, Object> additionalProperties;

    public TimeseriesResponseAttributes series(List<TimeseriesResponseSeries> series) {
        this.series = series;
        for (TimeseriesResponseSeries item : series) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public TimeseriesResponseAttributes addSeriesItem(TimeseriesResponseSeries seriesItem) {
        if (this.series == null) {
            this.series = new ArrayList<TimeseriesResponseSeries>();
        }
        this.series.add(seriesItem);
        this.unparsed |= seriesItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="series")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TimeseriesResponseSeries> getSeries() {
        return this.series;
    }

    public void setSeries(List<TimeseriesResponseSeries> series) {
        this.series = series;
    }

    public TimeseriesResponseAttributes times(List<Long> times) {
        this.times = times;
        return this;
    }

    public TimeseriesResponseAttributes addTimesItem(Long timesItem) {
        if (this.times == null) {
            this.times = new ArrayList<Long>();
        }
        this.times.add(timesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="times")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Long> getTimes() {
        return this.times;
    }

    public void setTimes(List<Long> times) {
        this.times = times;
    }

    public TimeseriesResponseAttributes values(List<List<Double>> values) {
        this.values = values;
        return this;
    }

    public TimeseriesResponseAttributes addValuesItem(List<Double> valuesItem) {
        if (this.values == null) {
            this.values = new ArrayList<List<Double>>();
        }
        this.values.add(valuesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="values")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<List<Double>> getValues() {
        return this.values;
    }

    public void setValues(List<List<Double>> values) {
        this.values = values;
    }

    @JsonAnySetter
    public TimeseriesResponseAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeseriesResponseAttributes timeseriesResponseAttributes = (TimeseriesResponseAttributes)o;
        return Objects.equals(this.series, timeseriesResponseAttributes.series) && Objects.equals(this.times, timeseriesResponseAttributes.times) && Objects.equals(this.values, timeseriesResponseAttributes.values) && Objects.equals(this.additionalProperties, timeseriesResponseAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.series, this.times, this.values, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TimeseriesResponseAttributes {\n");
        sb.append("    series: ").append(this.toIndentedString(this.series)).append("\n");
        sb.append("    times: ").append(this.toIndentedString(this.times)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

