/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.MetricCustomAggregation;
import com.datadog.api.client.v2.model.MetricTagConfigurationMetricTypes;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"aggregations", "include_percentiles", "metric_type", "tags"})
public class MetricTagConfigurationCreateAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_AGGREGATIONS = "aggregations";
    private List<MetricCustomAggregation> aggregations = null;
    public static final String JSON_PROPERTY_INCLUDE_PERCENTILES = "include_percentiles";
    private Boolean includePercentiles;
    public static final String JSON_PROPERTY_METRIC_TYPE = "metric_type";
    private MetricTagConfigurationMetricTypes metricType = MetricTagConfigurationMetricTypes.GAUGE;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public MetricTagConfigurationCreateAttributes() {
    }

    @JsonCreator
    public MetricTagConfigurationCreateAttributes(@JsonProperty(required=true, value="metric_type") MetricTagConfigurationMetricTypes metricType, @JsonProperty(required=true, value="tags") List<String> tags) {
        this.metricType = metricType;
        this.unparsed |= !metricType.isValid();
        this.tags = tags;
    }

    public MetricTagConfigurationCreateAttributes aggregations(List<MetricCustomAggregation> aggregations) {
        this.aggregations = aggregations;
        for (MetricCustomAggregation item : aggregations) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public MetricTagConfigurationCreateAttributes addAggregationsItem(MetricCustomAggregation aggregationsItem) {
        if (this.aggregations == null) {
            this.aggregations = new ArrayList<MetricCustomAggregation>();
        }
        this.aggregations.add(aggregationsItem);
        this.unparsed |= aggregationsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="aggregations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<MetricCustomAggregation> getAggregations() {
        return this.aggregations;
    }

    public void setAggregations(List<MetricCustomAggregation> aggregations) {
        this.aggregations = aggregations;
    }

    public MetricTagConfigurationCreateAttributes includePercentiles(Boolean includePercentiles) {
        this.includePercentiles = includePercentiles;
        return this;
    }

    @Nullable
    @JsonProperty(value="include_percentiles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludePercentiles() {
        return this.includePercentiles;
    }

    public void setIncludePercentiles(Boolean includePercentiles) {
        this.includePercentiles = includePercentiles;
    }

    public MetricTagConfigurationCreateAttributes metricType(MetricTagConfigurationMetricTypes metricType) {
        this.metricType = metricType;
        this.unparsed |= !metricType.isValid();
        return this;
    }

    @JsonProperty(value="metric_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MetricTagConfigurationMetricTypes getMetricType() {
        return this.metricType;
    }

    public void setMetricType(MetricTagConfigurationMetricTypes metricType) {
        if (!metricType.isValid()) {
            this.unparsed = true;
        }
        this.metricType = metricType;
    }

    public MetricTagConfigurationCreateAttributes tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public MetricTagConfigurationCreateAttributes addTagsItem(String tagsItem) {
        this.tags.add(tagsItem);
        return this;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @JsonAnySetter
    public MetricTagConfigurationCreateAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricTagConfigurationCreateAttributes metricTagConfigurationCreateAttributes = (MetricTagConfigurationCreateAttributes)o;
        return Objects.equals(this.aggregations, metricTagConfigurationCreateAttributes.aggregations) && Objects.equals(this.includePercentiles, metricTagConfigurationCreateAttributes.includePercentiles) && Objects.equals(this.metricType, metricTagConfigurationCreateAttributes.metricType) && Objects.equals(this.tags, metricTagConfigurationCreateAttributes.tags) && Objects.equals(this.additionalProperties, metricTagConfigurationCreateAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.aggregations, this.includePercentiles, this.metricType, this.tags, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetricTagConfigurationCreateAttributes {\n");
        sb.append("    aggregations: ").append(this.toIndentedString(this.aggregations)).append("\n");
        sb.append("    includePercentiles: ").append(this.toIndentedString(this.includePercentiles)).append("\n");
        sb.append("    metricType: ").append(this.toIndentedString(this.metricType)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

