/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.TeamCreateAttributes;
import com.datadog.api.client.v2.model.TeamCreateRelationships;
import com.datadog.api.client.v2.model.TeamType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.Objects;

@JsonPropertyOrder(value={"attributes", "relationships", "type"})
public class TeamCreate {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private TeamCreateAttributes attributes;
    public static final String JSON_PROPERTY_RELATIONSHIPS = "relationships";
    private TeamCreateRelationships relationships;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TeamType type = TeamType.TEAM;

    public TeamCreate() {
    }

    @JsonCreator
    public TeamCreate(@JsonProperty(required=true, value="attributes") TeamCreateAttributes attributes, @JsonProperty(required=true, value="type") TeamType type) {
        this.attributes = attributes;
        this.unparsed |= attributes.unparsed;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public TeamCreate attributes(TeamCreateAttributes attributes) {
        this.attributes = attributes;
        this.unparsed |= attributes.unparsed;
        return this;
    }

    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TeamCreateAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(TeamCreateAttributes attributes) {
        this.attributes = attributes;
    }

    public TeamCreate relationships(TeamCreateRelationships relationships) {
        this.relationships = relationships;
        this.unparsed |= relationships.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="relationships")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TeamCreateRelationships getRelationships() {
        return this.relationships;
    }

    public void setRelationships(TeamCreateRelationships relationships) {
        this.relationships = relationships;
    }

    public TeamCreate type(TeamType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TeamType getType() {
        return this.type;
    }

    public void setType(TeamType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TeamCreate teamCreate = (TeamCreate)o;
        return Objects.equals(this.attributes, teamCreate.attributes) && Objects.equals(this.relationships, teamCreate.relationships) && Objects.equals(this.type, teamCreate.type);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.relationships, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TeamCreate {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    relationships: ").append(this.toIndentedString(this.relationships)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

