/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.WidgetDefinition;
import com.datadog.api.client.v1.model.WidgetLayout;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.Objects;

@JsonPropertyOrder(value={"definition", "id", "layout"})
public class Widget {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DEFINITION = "definition";
    private WidgetDefinition definition;
    public static final String JSON_PROPERTY_ID = "id";
    private Long id;
    public static final String JSON_PROPERTY_LAYOUT = "layout";
    private WidgetLayout layout;

    public Widget() {
    }

    @JsonCreator
    public Widget(@JsonProperty(required=true, value="definition") WidgetDefinition definition) {
        this.definition = definition;
        this.unparsed |= definition.unparsed;
    }

    public Widget definition(WidgetDefinition definition) {
        this.definition = definition;
        this.unparsed |= definition.unparsed;
        return this;
    }

    @JsonProperty(value="definition")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public WidgetDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(WidgetDefinition definition) {
        this.definition = definition;
    }

    public Widget id(Long id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Widget layout(WidgetLayout layout) {
        this.layout = layout;
        this.unparsed |= layout.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="layout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetLayout getLayout() {
        return this.layout;
    }

    public void setLayout(WidgetLayout layout) {
        this.layout = layout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Widget widget = (Widget)o;
        return Objects.equals(this.definition, widget.definition) && Objects.equals(this.id, widget.id) && Objects.equals(this.layout, widget.layout);
    }

    public int hashCode() {
        return Objects.hash(this.definition, this.id, this.layout);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Widget {\n");
        sb.append("    definition: ").append(this.toIndentedString(this.definition)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    layout: ").append(this.toIndentedString(this.layout)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

