/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.TeamType;
import com.datadog.api.client.v2.model.TeamUpdateAttributes;
import com.datadog.api.client.v2.model.TeamUpdateRelationships;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.Objects;

@JsonPropertyOrder(value={"attributes", "relationships", "type"})
public class TeamUpdate {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private TeamUpdateAttributes attributes;
    public static final String JSON_PROPERTY_RELATIONSHIPS = "relationships";
    private TeamUpdateRelationships relationships;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TeamType type = TeamType.TEAM;

    public TeamUpdate() {
    }

    @JsonCreator
    public TeamUpdate(@JsonProperty(required=true, value="attributes") TeamUpdateAttributes attributes, @JsonProperty(required=true, value="type") TeamType type) {
        this.attributes = attributes;
        this.unparsed |= attributes.unparsed;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public TeamUpdate attributes(TeamUpdateAttributes attributes) {
        this.attributes = attributes;
        this.unparsed |= attributes.unparsed;
        return this;
    }

    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TeamUpdateAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(TeamUpdateAttributes attributes) {
        this.attributes = attributes;
    }

    public TeamUpdate relationships(TeamUpdateRelationships relationships) {
        this.relationships = relationships;
        this.unparsed |= relationships.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="relationships")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TeamUpdateRelationships getRelationships() {
        return this.relationships;
    }

    public void setRelationships(TeamUpdateRelationships relationships) {
        this.relationships = relationships;
    }

    public TeamUpdate type(TeamType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TeamType getType() {
        return this.type;
    }

    public void setType(TeamType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TeamUpdate teamUpdate = (TeamUpdate)o;
        return Objects.equals(this.attributes, teamUpdate.attributes) && Objects.equals(this.relationships, teamUpdate.relationships) && Objects.equals(this.type, teamUpdate.type);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.relationships, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TeamUpdate {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    relationships: ").append(this.toIndentedString(this.relationships)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

