/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonSerialize(using=WidgetVerticalAlignSerializer.class)
public class WidgetVerticalAlign {
    public static final WidgetVerticalAlign CENTER = new WidgetVerticalAlign("center");
    public static final WidgetVerticalAlign TOP = new WidgetVerticalAlign("top");
    public static final WidgetVerticalAlign BOTTOM = new WidgetVerticalAlign("bottom");
    private static final Set<String> allowedValues = new HashSet<String>(Arrays.asList("center", "top", "bottom"));
    private String value;

    public boolean isValid() {
        return allowedValues.contains(this.value);
    }

    WidgetVerticalAlign(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.value.equals(((WidgetVerticalAlign)o).value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static WidgetVerticalAlign fromValue(String value) {
        return new WidgetVerticalAlign(value);
    }

    public static class WidgetVerticalAlignSerializer
    extends StdSerializer<WidgetVerticalAlign> {
        public WidgetVerticalAlignSerializer(Class<WidgetVerticalAlign> t) {
            super(t);
        }

        public WidgetVerticalAlignSerializer() {
            this(null);
        }

        public void serialize(WidgetVerticalAlign value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject((Object)value.value);
        }
    }
}

