/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.LogsArchiveDestinationAzureType;
import com.datadog.api.client.v2.model.LogsArchiveIntegrationAzure;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"container", "integration", "path", "region", "storage_account", "type"})
public class LogsArchiveDestinationAzure {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CONTAINER = "container";
    private String container;
    public static final String JSON_PROPERTY_INTEGRATION = "integration";
    private LogsArchiveIntegrationAzure integration;
    public static final String JSON_PROPERTY_PATH = "path";
    private String path;
    public static final String JSON_PROPERTY_REGION = "region";
    private String region;
    public static final String JSON_PROPERTY_STORAGE_ACCOUNT = "storage_account";
    private String storageAccount;
    public static final String JSON_PROPERTY_TYPE = "type";
    private LogsArchiveDestinationAzureType type = LogsArchiveDestinationAzureType.AZURE;

    public LogsArchiveDestinationAzure() {
    }

    @JsonCreator
    public LogsArchiveDestinationAzure(@JsonProperty(required=true, value="container") String container, @JsonProperty(required=true, value="integration") LogsArchiveIntegrationAzure integration, @JsonProperty(required=true, value="storage_account") String storageAccount, @JsonProperty(required=true, value="type") LogsArchiveDestinationAzureType type) {
        this.container = container;
        this.integration = integration;
        this.unparsed |= integration.unparsed;
        this.storageAccount = storageAccount;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public LogsArchiveDestinationAzure container(String container) {
        this.container = container;
        return this;
    }

    @JsonProperty(value="container")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getContainer() {
        return this.container;
    }

    public void setContainer(String container) {
        this.container = container;
    }

    public LogsArchiveDestinationAzure integration(LogsArchiveIntegrationAzure integration) {
        this.integration = integration;
        this.unparsed |= integration.unparsed;
        return this;
    }

    @JsonProperty(value="integration")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LogsArchiveIntegrationAzure getIntegration() {
        return this.integration;
    }

    public void setIntegration(LogsArchiveIntegrationAzure integration) {
        this.integration = integration;
    }

    public LogsArchiveDestinationAzure path(String path) {
        this.path = path;
        return this;
    }

    @Nullable
    @JsonProperty(value="path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public LogsArchiveDestinationAzure region(String region) {
        this.region = region;
        return this;
    }

    @Nullable
    @JsonProperty(value="region")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public LogsArchiveDestinationAzure storageAccount(String storageAccount) {
        this.storageAccount = storageAccount;
        return this;
    }

    @JsonProperty(value="storage_account")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getStorageAccount() {
        return this.storageAccount;
    }

    public void setStorageAccount(String storageAccount) {
        this.storageAccount = storageAccount;
    }

    public LogsArchiveDestinationAzure type(LogsArchiveDestinationAzureType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LogsArchiveDestinationAzureType getType() {
        return this.type;
    }

    public void setType(LogsArchiveDestinationAzureType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsArchiveDestinationAzure logsArchiveDestinationAzure = (LogsArchiveDestinationAzure)o;
        return Objects.equals(this.container, logsArchiveDestinationAzure.container) && Objects.equals(this.integration, logsArchiveDestinationAzure.integration) && Objects.equals(this.path, logsArchiveDestinationAzure.path) && Objects.equals(this.region, logsArchiveDestinationAzure.region) && Objects.equals(this.storageAccount, logsArchiveDestinationAzure.storageAccount) && Objects.equals(this.type, logsArchiveDestinationAzure.type);
    }

    public int hashCode() {
        return Objects.hash(this.container, this.integration, this.path, this.region, this.storageAccount, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsArchiveDestinationAzure {\n");
        sb.append("    container: ").append(this.toIndentedString(this.container)).append("\n");
        sb.append("    integration: ").append(this.toIndentedString(this.integration)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    region: ").append(this.toIndentedString(this.region)).append("\n");
        sb.append("    storageAccount: ").append(this.toIndentedString(this.storageAccount)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

