/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.SyntheticsAssertion;
import com.datadog.api.client.v1.model.SyntheticsBrowserVariable;
import com.datadog.api.client.v1.model.SyntheticsConfigVariable;
import com.datadog.api.client.v1.model.SyntheticsTestRequest;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"assertions", "configVariables", "request", "variables"})
public class SyntheticsTestConfig {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ASSERTIONS = "assertions";
    private List<SyntheticsAssertion> assertions = null;
    public static final String JSON_PROPERTY_CONFIG_VARIABLES = "configVariables";
    private List<SyntheticsConfigVariable> configVariables = null;
    public static final String JSON_PROPERTY_REQUEST = "request";
    private SyntheticsTestRequest request;
    public static final String JSON_PROPERTY_VARIABLES = "variables";
    private List<SyntheticsBrowserVariable> variables = null;

    public SyntheticsTestConfig assertions(List<SyntheticsAssertion> assertions) {
        this.assertions = assertions;
        for (SyntheticsAssertion item : assertions) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SyntheticsTestConfig addAssertionsItem(SyntheticsAssertion assertionsItem) {
        if (this.assertions == null) {
            this.assertions = new ArrayList<SyntheticsAssertion>();
        }
        this.assertions.add(assertionsItem);
        this.unparsed |= assertionsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="assertions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SyntheticsAssertion> getAssertions() {
        return this.assertions;
    }

    public void setAssertions(List<SyntheticsAssertion> assertions) {
        this.assertions = assertions;
    }

    public SyntheticsTestConfig configVariables(List<SyntheticsConfigVariable> configVariables) {
        this.configVariables = configVariables;
        for (SyntheticsConfigVariable item : configVariables) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SyntheticsTestConfig addConfigVariablesItem(SyntheticsConfigVariable configVariablesItem) {
        if (this.configVariables == null) {
            this.configVariables = new ArrayList<SyntheticsConfigVariable>();
        }
        this.configVariables.add(configVariablesItem);
        this.unparsed |= configVariablesItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="configVariables")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SyntheticsConfigVariable> getConfigVariables() {
        return this.configVariables;
    }

    public void setConfigVariables(List<SyntheticsConfigVariable> configVariables) {
        this.configVariables = configVariables;
    }

    public SyntheticsTestConfig request(SyntheticsTestRequest request) {
        this.request = request;
        this.unparsed |= request.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="request")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsTestRequest getRequest() {
        return this.request;
    }

    public void setRequest(SyntheticsTestRequest request) {
        this.request = request;
    }

    public SyntheticsTestConfig variables(List<SyntheticsBrowserVariable> variables) {
        this.variables = variables;
        for (SyntheticsBrowserVariable item : variables) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SyntheticsTestConfig addVariablesItem(SyntheticsBrowserVariable variablesItem) {
        if (this.variables == null) {
            this.variables = new ArrayList<SyntheticsBrowserVariable>();
        }
        this.variables.add(variablesItem);
        this.unparsed |= variablesItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="variables")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SyntheticsBrowserVariable> getVariables() {
        return this.variables;
    }

    public void setVariables(List<SyntheticsBrowserVariable> variables) {
        this.variables = variables;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticsTestConfig syntheticsTestConfig = (SyntheticsTestConfig)o;
        return Objects.equals(this.assertions, syntheticsTestConfig.assertions) && Objects.equals(this.configVariables, syntheticsTestConfig.configVariables) && Objects.equals(this.request, syntheticsTestConfig.request) && Objects.equals(this.variables, syntheticsTestConfig.variables);
    }

    public int hashCode() {
        return Objects.hash(this.assertions, this.configVariables, this.request, this.variables);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SyntheticsTestConfig {\n");
        sb.append("    assertions: ").append(this.toIndentedString(this.assertions)).append("\n");
        sb.append("    configVariables: ").append(this.toIndentedString(this.configVariables)).append("\n");
        sb.append("    request: ").append(this.toIndentedString(this.request)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

