/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.SyntheticsBrowserTestResultFailure;
import com.datadog.api.client.v1.model.SyntheticsDevice;
import com.datadog.api.client.v1.model.SyntheticsStepDetail;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"browserType", "browserVersion", "device", "duration", "error", "failure", "passed", "receivedEmailCount", "startUrl", "stepDetails", "thumbnailsBucketKey", "timeToInteractive"})
public class SyntheticsBrowserTestResultData {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_BROWSER_TYPE = "browserType";
    private String browserType;
    public static final String JSON_PROPERTY_BROWSER_VERSION = "browserVersion";
    private String browserVersion;
    public static final String JSON_PROPERTY_DEVICE = "device";
    private SyntheticsDevice device;
    public static final String JSON_PROPERTY_DURATION = "duration";
    private Double duration;
    public static final String JSON_PROPERTY_ERROR = "error";
    private String error;
    public static final String JSON_PROPERTY_FAILURE = "failure";
    private SyntheticsBrowserTestResultFailure failure;
    public static final String JSON_PROPERTY_PASSED = "passed";
    private Boolean passed;
    public static final String JSON_PROPERTY_RECEIVED_EMAIL_COUNT = "receivedEmailCount";
    private Long receivedEmailCount;
    public static final String JSON_PROPERTY_START_URL = "startUrl";
    private String startUrl;
    public static final String JSON_PROPERTY_STEP_DETAILS = "stepDetails";
    private List<SyntheticsStepDetail> stepDetails = null;
    public static final String JSON_PROPERTY_THUMBNAILS_BUCKET_KEY = "thumbnailsBucketKey";
    private Boolean thumbnailsBucketKey;
    public static final String JSON_PROPERTY_TIME_TO_INTERACTIVE = "timeToInteractive";
    private Double timeToInteractive;

    public SyntheticsBrowserTestResultData browserType(String browserType) {
        this.browserType = browserType;
        return this;
    }

    @Nullable
    @JsonProperty(value="browserType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBrowserType() {
        return this.browserType;
    }

    public void setBrowserType(String browserType) {
        this.browserType = browserType;
    }

    public SyntheticsBrowserTestResultData browserVersion(String browserVersion) {
        this.browserVersion = browserVersion;
        return this;
    }

    @Nullable
    @JsonProperty(value="browserVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBrowserVersion() {
        return this.browserVersion;
    }

    public void setBrowserVersion(String browserVersion) {
        this.browserVersion = browserVersion;
    }

    public SyntheticsBrowserTestResultData device(SyntheticsDevice device) {
        this.device = device;
        this.unparsed |= device.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="device")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsDevice getDevice() {
        return this.device;
    }

    public void setDevice(SyntheticsDevice device) {
        this.device = device;
    }

    public SyntheticsBrowserTestResultData duration(Double duration) {
        this.duration = duration;
        return this;
    }

    @Nullable
    @JsonProperty(value="duration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getDuration() {
        return this.duration;
    }

    public void setDuration(Double duration) {
        this.duration = duration;
    }

    public SyntheticsBrowserTestResultData error(String error) {
        this.error = error;
        return this;
    }

    @Nullable
    @JsonProperty(value="error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public SyntheticsBrowserTestResultData failure(SyntheticsBrowserTestResultFailure failure) {
        this.failure = failure;
        this.unparsed |= failure.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="failure")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsBrowserTestResultFailure getFailure() {
        return this.failure;
    }

    public void setFailure(SyntheticsBrowserTestResultFailure failure) {
        this.failure = failure;
    }

    public SyntheticsBrowserTestResultData passed(Boolean passed) {
        this.passed = passed;
        return this;
    }

    @Nullable
    @JsonProperty(value="passed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPassed() {
        return this.passed;
    }

    public void setPassed(Boolean passed) {
        this.passed = passed;
    }

    public SyntheticsBrowserTestResultData receivedEmailCount(Long receivedEmailCount) {
        this.receivedEmailCount = receivedEmailCount;
        return this;
    }

    @Nullable
    @JsonProperty(value="receivedEmailCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getReceivedEmailCount() {
        return this.receivedEmailCount;
    }

    public void setReceivedEmailCount(Long receivedEmailCount) {
        this.receivedEmailCount = receivedEmailCount;
    }

    public SyntheticsBrowserTestResultData startUrl(String startUrl) {
        this.startUrl = startUrl;
        return this;
    }

    @Nullable
    @JsonProperty(value="startUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStartUrl() {
        return this.startUrl;
    }

    public void setStartUrl(String startUrl) {
        this.startUrl = startUrl;
    }

    public SyntheticsBrowserTestResultData stepDetails(List<SyntheticsStepDetail> stepDetails) {
        this.stepDetails = stepDetails;
        for (SyntheticsStepDetail item : stepDetails) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SyntheticsBrowserTestResultData addStepDetailsItem(SyntheticsStepDetail stepDetailsItem) {
        if (this.stepDetails == null) {
            this.stepDetails = new ArrayList<SyntheticsStepDetail>();
        }
        this.stepDetails.add(stepDetailsItem);
        this.unparsed |= stepDetailsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="stepDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SyntheticsStepDetail> getStepDetails() {
        return this.stepDetails;
    }

    public void setStepDetails(List<SyntheticsStepDetail> stepDetails) {
        this.stepDetails = stepDetails;
    }

    public SyntheticsBrowserTestResultData thumbnailsBucketKey(Boolean thumbnailsBucketKey) {
        this.thumbnailsBucketKey = thumbnailsBucketKey;
        return this;
    }

    @Nullable
    @JsonProperty(value="thumbnailsBucketKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getThumbnailsBucketKey() {
        return this.thumbnailsBucketKey;
    }

    public void setThumbnailsBucketKey(Boolean thumbnailsBucketKey) {
        this.thumbnailsBucketKey = thumbnailsBucketKey;
    }

    public SyntheticsBrowserTestResultData timeToInteractive(Double timeToInteractive) {
        this.timeToInteractive = timeToInteractive;
        return this;
    }

    @Nullable
    @JsonProperty(value="timeToInteractive")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getTimeToInteractive() {
        return this.timeToInteractive;
    }

    public void setTimeToInteractive(Double timeToInteractive) {
        this.timeToInteractive = timeToInteractive;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticsBrowserTestResultData syntheticsBrowserTestResultData = (SyntheticsBrowserTestResultData)o;
        return Objects.equals(this.browserType, syntheticsBrowserTestResultData.browserType) && Objects.equals(this.browserVersion, syntheticsBrowserTestResultData.browserVersion) && Objects.equals(this.device, syntheticsBrowserTestResultData.device) && Objects.equals(this.duration, syntheticsBrowserTestResultData.duration) && Objects.equals(this.error, syntheticsBrowserTestResultData.error) && Objects.equals(this.failure, syntheticsBrowserTestResultData.failure) && Objects.equals(this.passed, syntheticsBrowserTestResultData.passed) && Objects.equals(this.receivedEmailCount, syntheticsBrowserTestResultData.receivedEmailCount) && Objects.equals(this.startUrl, syntheticsBrowserTestResultData.startUrl) && Objects.equals(this.stepDetails, syntheticsBrowserTestResultData.stepDetails) && Objects.equals(this.thumbnailsBucketKey, syntheticsBrowserTestResultData.thumbnailsBucketKey) && Objects.equals(this.timeToInteractive, syntheticsBrowserTestResultData.timeToInteractive);
    }

    public int hashCode() {
        return Objects.hash(this.browserType, this.browserVersion, this.device, this.duration, this.error, this.failure, this.passed, this.receivedEmailCount, this.startUrl, this.stepDetails, this.thumbnailsBucketKey, this.timeToInteractive);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SyntheticsBrowserTestResultData {\n");
        sb.append("    browserType: ").append(this.toIndentedString(this.browserType)).append("\n");
        sb.append("    browserVersion: ").append(this.toIndentedString(this.browserVersion)).append("\n");
        sb.append("    device: ").append(this.toIndentedString(this.device)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    failure: ").append(this.toIndentedString(this.failure)).append("\n");
        sb.append("    passed: ").append(this.toIndentedString(this.passed)).append("\n");
        sb.append("    receivedEmailCount: ").append(this.toIndentedString(this.receivedEmailCount)).append("\n");
        sb.append("    startUrl: ").append(this.toIndentedString(this.startUrl)).append("\n");
        sb.append("    stepDetails: ").append(this.toIndentedString(this.stepDetails)).append("\n");
        sb.append("    thumbnailsBucketKey: ").append(this.toIndentedString(this.thumbnailsBucketKey)).append("\n");
        sb.append("    timeToInteractive: ").append(this.toIndentedString(this.timeToInteractive)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

