/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.AWSAccount;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"accounts"})
public class AWSAccountListResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ACCOUNTS = "accounts";
    private List<AWSAccount> accounts = null;

    public AWSAccountListResponse accounts(List<AWSAccount> accounts) {
        this.accounts = accounts;
        for (AWSAccount item : accounts) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public AWSAccountListResponse addAccountsItem(AWSAccount accountsItem) {
        if (this.accounts == null) {
            this.accounts = new ArrayList<AWSAccount>();
        }
        this.accounts.add(accountsItem);
        this.unparsed |= accountsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="accounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AWSAccount> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(List<AWSAccount> accounts) {
        this.accounts = accounts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AWSAccountListResponse awsAccountListResponse = (AWSAccountListResponse)o;
        return Objects.equals(this.accounts, awsAccountListResponse.accounts);
    }

    public int hashCode() {
        return Objects.hash(this.accounts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AWSAccountListResponse {\n");
        sb.append("    accounts: ").append(this.toIndentedString(this.accounts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

