/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v1.model.SlackIntegrationChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.GenericType;

public class SlackIntegrationApi {
    private ApiClient apiClient;

    public SlackIntegrationApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public SlackIntegrationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public SlackIntegrationChannel createSlackIntegrationChannel(String accountName, SlackIntegrationChannel body) throws ApiException {
        return this.createSlackIntegrationChannelWithHttpInfo(accountName, body).getData();
    }

    public CompletableFuture<SlackIntegrationChannel> createSlackIntegrationChannelAsync(String accountName, SlackIntegrationChannel body) {
        return this.createSlackIntegrationChannelWithHttpInfoAsync(accountName, body).thenApply(response -> (SlackIntegrationChannel)response.getData());
    }

    public ApiResponse<SlackIntegrationChannel> createSlackIntegrationChannelWithHttpInfo(String accountName, SlackIntegrationChannel body) throws ApiException {
        SlackIntegrationChannel localVarPostBody = body;
        if (accountName == null) {
            throw new ApiException(400, "Missing the required parameter 'accountName' when calling createSlackIntegrationChannel");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createSlackIntegrationChannel");
        }
        String localVarPath = "/api/v1/integration/slack/configuration/accounts/{account_name}/channels".replaceAll("\\{account_name\\}", this.apiClient.escapeString(accountName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.SlackIntegrationApi.createSlackIntegrationChannel", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SlackIntegrationChannel>(){});
    }

    public CompletableFuture<ApiResponse<SlackIntegrationChannel>> createSlackIntegrationChannelWithHttpInfoAsync(String accountName, SlackIntegrationChannel body) {
        Invocation.Builder builder;
        SlackIntegrationChannel localVarPostBody = body;
        if (accountName == null) {
            CompletableFuture<ApiResponse<SlackIntegrationChannel>> result = new CompletableFuture<ApiResponse<SlackIntegrationChannel>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'accountName' when calling createSlackIntegrationChannel"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<SlackIntegrationChannel>> result = new CompletableFuture<ApiResponse<SlackIntegrationChannel>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createSlackIntegrationChannel"));
            return result;
        }
        String localVarPath = "/api/v1/integration/slack/configuration/accounts/{account_name}/channels".replaceAll("\\{account_name\\}", this.apiClient.escapeString(accountName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SlackIntegrationApi.createSlackIntegrationChannel", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SlackIntegrationChannel>> result = new CompletableFuture<ApiResponse<SlackIntegrationChannel>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SlackIntegrationChannel>(){});
    }

    public SlackIntegrationChannel getSlackIntegrationChannel(String accountName, String channelName) throws ApiException {
        return this.getSlackIntegrationChannelWithHttpInfo(accountName, channelName).getData();
    }

    public CompletableFuture<SlackIntegrationChannel> getSlackIntegrationChannelAsync(String accountName, String channelName) {
        return this.getSlackIntegrationChannelWithHttpInfoAsync(accountName, channelName).thenApply(response -> (SlackIntegrationChannel)response.getData());
    }

    public ApiResponse<SlackIntegrationChannel> getSlackIntegrationChannelWithHttpInfo(String accountName, String channelName) throws ApiException {
        Object localVarPostBody = null;
        if (accountName == null) {
            throw new ApiException(400, "Missing the required parameter 'accountName' when calling getSlackIntegrationChannel");
        }
        if (channelName == null) {
            throw new ApiException(400, "Missing the required parameter 'channelName' when calling getSlackIntegrationChannel");
        }
        String localVarPath = "/api/v1/integration/slack/configuration/accounts/{account_name}/channels/{channel_name}".replaceAll("\\{account_name\\}", this.apiClient.escapeString(accountName.toString())).replaceAll("\\{channel_name\\}", this.apiClient.escapeString(channelName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.SlackIntegrationApi.getSlackIntegrationChannel", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SlackIntegrationChannel>(){});
    }

    public CompletableFuture<ApiResponse<SlackIntegrationChannel>> getSlackIntegrationChannelWithHttpInfoAsync(String accountName, String channelName) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (accountName == null) {
            CompletableFuture<ApiResponse<SlackIntegrationChannel>> result = new CompletableFuture<ApiResponse<SlackIntegrationChannel>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'accountName' when calling getSlackIntegrationChannel"));
            return result;
        }
        if (channelName == null) {
            CompletableFuture<ApiResponse<SlackIntegrationChannel>> result = new CompletableFuture<ApiResponse<SlackIntegrationChannel>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'channelName' when calling getSlackIntegrationChannel"));
            return result;
        }
        String localVarPath = "/api/v1/integration/slack/configuration/accounts/{account_name}/channels/{channel_name}".replaceAll("\\{account_name\\}", this.apiClient.escapeString(accountName.toString())).replaceAll("\\{channel_name\\}", this.apiClient.escapeString(channelName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SlackIntegrationApi.getSlackIntegrationChannel", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SlackIntegrationChannel>> result = new CompletableFuture<ApiResponse<SlackIntegrationChannel>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SlackIntegrationChannel>(){});
    }

    public List<SlackIntegrationChannel> getSlackIntegrationChannels(String accountName) throws ApiException {
        return this.getSlackIntegrationChannelsWithHttpInfo(accountName).getData();
    }

    public CompletableFuture<List<SlackIntegrationChannel>> getSlackIntegrationChannelsAsync(String accountName) {
        return this.getSlackIntegrationChannelsWithHttpInfoAsync(accountName).thenApply(response -> (List)response.getData());
    }

    public ApiResponse<List<SlackIntegrationChannel>> getSlackIntegrationChannelsWithHttpInfo(String accountName) throws ApiException {
        Object localVarPostBody = null;
        if (accountName == null) {
            throw new ApiException(400, "Missing the required parameter 'accountName' when calling getSlackIntegrationChannels");
        }
        String localVarPath = "/api/v1/integration/slack/configuration/accounts/{account_name}/channels".replaceAll("\\{account_name\\}", this.apiClient.escapeString(accountName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.SlackIntegrationApi.getSlackIntegrationChannels", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<List<SlackIntegrationChannel>>(){});
    }

    public CompletableFuture<ApiResponse<List<SlackIntegrationChannel>>> getSlackIntegrationChannelsWithHttpInfoAsync(String accountName) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (accountName == null) {
            CompletableFuture<ApiResponse<List<SlackIntegrationChannel>>> result = new CompletableFuture<ApiResponse<List<SlackIntegrationChannel>>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'accountName' when calling getSlackIntegrationChannels"));
            return result;
        }
        String localVarPath = "/api/v1/integration/slack/configuration/accounts/{account_name}/channels".replaceAll("\\{account_name\\}", this.apiClient.escapeString(accountName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SlackIntegrationApi.getSlackIntegrationChannels", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<List<SlackIntegrationChannel>>> result = new CompletableFuture<ApiResponse<List<SlackIntegrationChannel>>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<List<SlackIntegrationChannel>>(){});
    }

    public void removeSlackIntegrationChannel(String accountName, String channelName) throws ApiException {
        this.removeSlackIntegrationChannelWithHttpInfo(accountName, channelName);
    }

    public CompletableFuture<Void> removeSlackIntegrationChannelAsync(String accountName, String channelName) {
        return this.removeSlackIntegrationChannelWithHttpInfoAsync(accountName, channelName).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> removeSlackIntegrationChannelWithHttpInfo(String accountName, String channelName) throws ApiException {
        Object localVarPostBody = null;
        if (accountName == null) {
            throw new ApiException(400, "Missing the required parameter 'accountName' when calling removeSlackIntegrationChannel");
        }
        if (channelName == null) {
            throw new ApiException(400, "Missing the required parameter 'channelName' when calling removeSlackIntegrationChannel");
        }
        String localVarPath = "/api/v1/integration/slack/configuration/accounts/{account_name}/channels/{channel_name}".replaceAll("\\{account_name\\}", this.apiClient.escapeString(accountName.toString())).replaceAll("\\{channel_name\\}", this.apiClient.escapeString(channelName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.SlackIntegrationApi.removeSlackIntegrationChannel", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> removeSlackIntegrationChannelWithHttpInfoAsync(String accountName, String channelName) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (accountName == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'accountName' when calling removeSlackIntegrationChannel"));
            return result;
        }
        if (channelName == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'channelName' when calling removeSlackIntegrationChannel"));
            return result;
        }
        String localVarPath = "/api/v1/integration/slack/configuration/accounts/{account_name}/channels/{channel_name}".replaceAll("\\{account_name\\}", this.apiClient.escapeString(accountName.toString())).replaceAll("\\{channel_name\\}", this.apiClient.escapeString(channelName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SlackIntegrationApi.removeSlackIntegrationChannel", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public SlackIntegrationChannel updateSlackIntegrationChannel(String accountName, String channelName, SlackIntegrationChannel body) throws ApiException {
        return this.updateSlackIntegrationChannelWithHttpInfo(accountName, channelName, body).getData();
    }

    public CompletableFuture<SlackIntegrationChannel> updateSlackIntegrationChannelAsync(String accountName, String channelName, SlackIntegrationChannel body) {
        return this.updateSlackIntegrationChannelWithHttpInfoAsync(accountName, channelName, body).thenApply(response -> (SlackIntegrationChannel)response.getData());
    }

    public ApiResponse<SlackIntegrationChannel> updateSlackIntegrationChannelWithHttpInfo(String accountName, String channelName, SlackIntegrationChannel body) throws ApiException {
        SlackIntegrationChannel localVarPostBody = body;
        if (accountName == null) {
            throw new ApiException(400, "Missing the required parameter 'accountName' when calling updateSlackIntegrationChannel");
        }
        if (channelName == null) {
            throw new ApiException(400, "Missing the required parameter 'channelName' when calling updateSlackIntegrationChannel");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateSlackIntegrationChannel");
        }
        String localVarPath = "/api/v1/integration/slack/configuration/accounts/{account_name}/channels/{channel_name}".replaceAll("\\{account_name\\}", this.apiClient.escapeString(accountName.toString())).replaceAll("\\{channel_name\\}", this.apiClient.escapeString(channelName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.SlackIntegrationApi.updateSlackIntegrationChannel", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SlackIntegrationChannel>(){});
    }

    public CompletableFuture<ApiResponse<SlackIntegrationChannel>> updateSlackIntegrationChannelWithHttpInfoAsync(String accountName, String channelName, SlackIntegrationChannel body) {
        Invocation.Builder builder;
        SlackIntegrationChannel localVarPostBody = body;
        if (accountName == null) {
            CompletableFuture<ApiResponse<SlackIntegrationChannel>> result = new CompletableFuture<ApiResponse<SlackIntegrationChannel>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'accountName' when calling updateSlackIntegrationChannel"));
            return result;
        }
        if (channelName == null) {
            CompletableFuture<ApiResponse<SlackIntegrationChannel>> result = new CompletableFuture<ApiResponse<SlackIntegrationChannel>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'channelName' when calling updateSlackIntegrationChannel"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<SlackIntegrationChannel>> result = new CompletableFuture<ApiResponse<SlackIntegrationChannel>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateSlackIntegrationChannel"));
            return result;
        }
        String localVarPath = "/api/v1/integration/slack/configuration/accounts/{account_name}/channels/{channel_name}".replaceAll("\\{account_name\\}", this.apiClient.escapeString(accountName.toString())).replaceAll("\\{channel_name\\}", this.apiClient.escapeString(channelName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SlackIntegrationApi.updateSlackIntegrationChannel", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SlackIntegrationChannel>> result = new CompletableFuture<ApiResponse<SlackIntegrationChannel>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SlackIntegrationChannel>(){});
    }
}

