/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v1.model.LogsPipeline;
import com.datadog.api.client.v1.model.LogsPipelinesOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.GenericType;

public class LogsPipelinesApi {
    private ApiClient apiClient;

    public LogsPipelinesApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public LogsPipelinesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public LogsPipeline createLogsPipeline(LogsPipeline body) throws ApiException {
        return this.createLogsPipelineWithHttpInfo(body).getData();
    }

    public CompletableFuture<LogsPipeline> createLogsPipelineAsync(LogsPipeline body) {
        return this.createLogsPipelineWithHttpInfoAsync(body).thenApply(response -> (LogsPipeline)response.getData());
    }

    public ApiResponse<LogsPipeline> createLogsPipelineWithHttpInfo(LogsPipeline body) throws ApiException {
        LogsPipeline localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createLogsPipeline");
        }
        String localVarPath = "/api/v1/logs/config/pipelines";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.LogsPipelinesApi.createLogsPipeline", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsPipeline>(){});
    }

    public CompletableFuture<ApiResponse<LogsPipeline>> createLogsPipelineWithHttpInfoAsync(LogsPipeline body) {
        Invocation.Builder builder;
        LogsPipeline localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<LogsPipeline>> result = new CompletableFuture<ApiResponse<LogsPipeline>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createLogsPipeline"));
            return result;
        }
        String localVarPath = "/api/v1/logs/config/pipelines";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("LogsPipelinesApi.createLogsPipeline", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<LogsPipeline>> result = new CompletableFuture<ApiResponse<LogsPipeline>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsPipeline>(){});
    }

    public void deleteLogsPipeline(String pipelineId) throws ApiException {
        this.deleteLogsPipelineWithHttpInfo(pipelineId);
    }

    public CompletableFuture<Void> deleteLogsPipelineAsync(String pipelineId) {
        return this.deleteLogsPipelineWithHttpInfoAsync(pipelineId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteLogsPipelineWithHttpInfo(String pipelineId) throws ApiException {
        Object localVarPostBody = null;
        if (pipelineId == null) {
            throw new ApiException(400, "Missing the required parameter 'pipelineId' when calling deleteLogsPipeline");
        }
        String localVarPath = "/api/v1/logs/config/pipelines/{pipeline_id}".replaceAll("\\{pipeline_id\\}", this.apiClient.escapeString(pipelineId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.LogsPipelinesApi.deleteLogsPipeline", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteLogsPipelineWithHttpInfoAsync(String pipelineId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (pipelineId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'pipelineId' when calling deleteLogsPipeline"));
            return result;
        }
        String localVarPath = "/api/v1/logs/config/pipelines/{pipeline_id}".replaceAll("\\{pipeline_id\\}", this.apiClient.escapeString(pipelineId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("LogsPipelinesApi.deleteLogsPipeline", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public LogsPipeline getLogsPipeline(String pipelineId) throws ApiException {
        return this.getLogsPipelineWithHttpInfo(pipelineId).getData();
    }

    public CompletableFuture<LogsPipeline> getLogsPipelineAsync(String pipelineId) {
        return this.getLogsPipelineWithHttpInfoAsync(pipelineId).thenApply(response -> (LogsPipeline)response.getData());
    }

    public ApiResponse<LogsPipeline> getLogsPipelineWithHttpInfo(String pipelineId) throws ApiException {
        Object localVarPostBody = null;
        if (pipelineId == null) {
            throw new ApiException(400, "Missing the required parameter 'pipelineId' when calling getLogsPipeline");
        }
        String localVarPath = "/api/v1/logs/config/pipelines/{pipeline_id}".replaceAll("\\{pipeline_id\\}", this.apiClient.escapeString(pipelineId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.LogsPipelinesApi.getLogsPipeline", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsPipeline>(){});
    }

    public CompletableFuture<ApiResponse<LogsPipeline>> getLogsPipelineWithHttpInfoAsync(String pipelineId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (pipelineId == null) {
            CompletableFuture<ApiResponse<LogsPipeline>> result = new CompletableFuture<ApiResponse<LogsPipeline>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'pipelineId' when calling getLogsPipeline"));
            return result;
        }
        String localVarPath = "/api/v1/logs/config/pipelines/{pipeline_id}".replaceAll("\\{pipeline_id\\}", this.apiClient.escapeString(pipelineId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("LogsPipelinesApi.getLogsPipeline", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<LogsPipeline>> result = new CompletableFuture<ApiResponse<LogsPipeline>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsPipeline>(){});
    }

    public LogsPipelinesOrder getLogsPipelineOrder() throws ApiException {
        return this.getLogsPipelineOrderWithHttpInfo().getData();
    }

    public CompletableFuture<LogsPipelinesOrder> getLogsPipelineOrderAsync() {
        return this.getLogsPipelineOrderWithHttpInfoAsync().thenApply(response -> (LogsPipelinesOrder)response.getData());
    }

    public ApiResponse<LogsPipelinesOrder> getLogsPipelineOrderWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/logs/config/pipeline-order";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.LogsPipelinesApi.getLogsPipelineOrder", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsPipelinesOrder>(){});
    }

    public CompletableFuture<ApiResponse<LogsPipelinesOrder>> getLogsPipelineOrderWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/logs/config/pipeline-order";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("LogsPipelinesApi.getLogsPipelineOrder", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<LogsPipelinesOrder>> result = new CompletableFuture<ApiResponse<LogsPipelinesOrder>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsPipelinesOrder>(){});
    }

    public List<LogsPipeline> listLogsPipelines() throws ApiException {
        return this.listLogsPipelinesWithHttpInfo().getData();
    }

    public CompletableFuture<List<LogsPipeline>> listLogsPipelinesAsync() {
        return this.listLogsPipelinesWithHttpInfoAsync().thenApply(response -> (List)response.getData());
    }

    public ApiResponse<List<LogsPipeline>> listLogsPipelinesWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/logs/config/pipelines";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.LogsPipelinesApi.listLogsPipelines", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<List<LogsPipeline>>(){});
    }

    public CompletableFuture<ApiResponse<List<LogsPipeline>>> listLogsPipelinesWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/logs/config/pipelines";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("LogsPipelinesApi.listLogsPipelines", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<List<LogsPipeline>>> result = new CompletableFuture<ApiResponse<List<LogsPipeline>>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<List<LogsPipeline>>(){});
    }

    public LogsPipeline updateLogsPipeline(String pipelineId, LogsPipeline body) throws ApiException {
        return this.updateLogsPipelineWithHttpInfo(pipelineId, body).getData();
    }

    public CompletableFuture<LogsPipeline> updateLogsPipelineAsync(String pipelineId, LogsPipeline body) {
        return this.updateLogsPipelineWithHttpInfoAsync(pipelineId, body).thenApply(response -> (LogsPipeline)response.getData());
    }

    public ApiResponse<LogsPipeline> updateLogsPipelineWithHttpInfo(String pipelineId, LogsPipeline body) throws ApiException {
        LogsPipeline localVarPostBody = body;
        if (pipelineId == null) {
            throw new ApiException(400, "Missing the required parameter 'pipelineId' when calling updateLogsPipeline");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateLogsPipeline");
        }
        String localVarPath = "/api/v1/logs/config/pipelines/{pipeline_id}".replaceAll("\\{pipeline_id\\}", this.apiClient.escapeString(pipelineId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.LogsPipelinesApi.updateLogsPipeline", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsPipeline>(){});
    }

    public CompletableFuture<ApiResponse<LogsPipeline>> updateLogsPipelineWithHttpInfoAsync(String pipelineId, LogsPipeline body) {
        Invocation.Builder builder;
        LogsPipeline localVarPostBody = body;
        if (pipelineId == null) {
            CompletableFuture<ApiResponse<LogsPipeline>> result = new CompletableFuture<ApiResponse<LogsPipeline>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'pipelineId' when calling updateLogsPipeline"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<LogsPipeline>> result = new CompletableFuture<ApiResponse<LogsPipeline>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateLogsPipeline"));
            return result;
        }
        String localVarPath = "/api/v1/logs/config/pipelines/{pipeline_id}".replaceAll("\\{pipeline_id\\}", this.apiClient.escapeString(pipelineId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("LogsPipelinesApi.updateLogsPipeline", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<LogsPipeline>> result = new CompletableFuture<ApiResponse<LogsPipeline>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsPipeline>(){});
    }

    public LogsPipelinesOrder updateLogsPipelineOrder(LogsPipelinesOrder body) throws ApiException {
        return this.updateLogsPipelineOrderWithHttpInfo(body).getData();
    }

    public CompletableFuture<LogsPipelinesOrder> updateLogsPipelineOrderAsync(LogsPipelinesOrder body) {
        return this.updateLogsPipelineOrderWithHttpInfoAsync(body).thenApply(response -> (LogsPipelinesOrder)response.getData());
    }

    public ApiResponse<LogsPipelinesOrder> updateLogsPipelineOrderWithHttpInfo(LogsPipelinesOrder body) throws ApiException {
        LogsPipelinesOrder localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateLogsPipelineOrder");
        }
        String localVarPath = "/api/v1/logs/config/pipeline-order";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.LogsPipelinesApi.updateLogsPipelineOrder", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsPipelinesOrder>(){});
    }

    public CompletableFuture<ApiResponse<LogsPipelinesOrder>> updateLogsPipelineOrderWithHttpInfoAsync(LogsPipelinesOrder body) {
        Invocation.Builder builder;
        LogsPipelinesOrder localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<LogsPipelinesOrder>> result = new CompletableFuture<ApiResponse<LogsPipelinesOrder>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateLogsPipelineOrder"));
            return result;
        }
        String localVarPath = "/api/v1/logs/config/pipeline-order";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("LogsPipelinesApi.updateLogsPipelineOrder", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<LogsPipelinesOrder>> result = new CompletableFuture<ApiResponse<LogsPipelinesOrder>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsPipelinesOrder>(){});
    }
}

