/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.api;

import com.datadog.api.v2.client.ApiClient;
import com.datadog.api.v2.client.ApiException;
import com.datadog.api.v2.client.ApiResponse;
import com.datadog.api.v2.client.Configuration;
import com.datadog.api.v2.client.Pair;
import com.datadog.api.v2.client.model.ProcessSummariesResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.GenericType;

public class ProcessesApi {
    private ApiClient apiClient;

    public ProcessesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProcessesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ProcessSummariesResponse listProcesses() throws ApiException {
        return this.listProcessesWithHttpInfo(new ListProcessesOptionalParameters()).getData();
    }

    public CompletableFuture<ProcessSummariesResponse> listProcessesAsync() {
        return this.listProcessesWithHttpInfoAsync(new ListProcessesOptionalParameters()).thenApply(response -> (ProcessSummariesResponse)response.getData());
    }

    public ProcessSummariesResponse listProcesses(ListProcessesOptionalParameters parameters) throws ApiException {
        return this.listProcessesWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<ProcessSummariesResponse> listProcessesAsync(ListProcessesOptionalParameters parameters) {
        return this.listProcessesWithHttpInfoAsync(parameters).thenApply(response -> (ProcessSummariesResponse)response.getData());
    }

    public ApiResponse<ProcessSummariesResponse> listProcessesWithHttpInfo(ListProcessesOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        String search = parameters.search;
        String tags = parameters.tags;
        Long from = parameters.from;
        Long to = parameters.to;
        Integer pageLimit = parameters.pageLimit;
        String pageCursor = parameters.pageCursor;
        String localVarPath = "/api/v2/processes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "search", search));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "tags", tags));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "from", from));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "to", to));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[cursor]", pageCursor));
        Invocation.Builder builder = this.apiClient.createBuilder("ProcessesApi.listProcesses", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ProcessSummariesResponse>(){});
    }

    public CompletableFuture<ApiResponse<ProcessSummariesResponse>> listProcessesWithHttpInfoAsync(ListProcessesOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String search = parameters.search;
        String tags = parameters.tags;
        Long from = parameters.from;
        Long to = parameters.to;
        Integer pageLimit = parameters.pageLimit;
        String pageCursor = parameters.pageCursor;
        String localVarPath = "/api/v2/processes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "search", search));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "tags", tags));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "from", from));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "to", to));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[cursor]", pageCursor));
        try {
            builder = this.apiClient.createBuilder("ProcessesApi.listProcesses", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ProcessSummariesResponse>> result = new CompletableFuture<ApiResponse<ProcessSummariesResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ProcessSummariesResponse>(){});
    }

    public static class ListProcessesOptionalParameters {
        private String search;
        private String tags;
        private Long from;
        private Long to;
        private Integer pageLimit;
        private String pageCursor;

        public ListProcessesOptionalParameters search(String search) {
            this.search = search;
            return this;
        }

        public ListProcessesOptionalParameters tags(String tags) {
            this.tags = tags;
            return this;
        }

        public ListProcessesOptionalParameters from(Long from) {
            this.from = from;
            return this;
        }

        public ListProcessesOptionalParameters to(Long to) {
            this.to = to;
            return this;
        }

        public ListProcessesOptionalParameters pageLimit(Integer pageLimit) {
            this.pageLimit = pageLimit;
            return this;
        }

        public ListProcessesOptionalParameters pageCursor(String pageCursor) {
            this.pageCursor = pageCursor;
            return this;
        }
    }
}

