/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.AuditLogsQueryFilter;
import com.datadog.api.v2.client.model.AuditLogsQueryOptions;
import com.datadog.api.v2.client.model.AuditLogsQueryPageOptions;
import com.datadog.api.v2.client.model.AuditLogsSort;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"filter", "options", "page", "sort"})
public class AuditLogsSearchEventsRequest {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_FILTER = "filter";
    private AuditLogsQueryFilter filter;
    public static final String JSON_PROPERTY_OPTIONS = "options";
    private AuditLogsQueryOptions options;
    public static final String JSON_PROPERTY_PAGE = "page";
    private AuditLogsQueryPageOptions page;
    public static final String JSON_PROPERTY_SORT = "sort";
    private AuditLogsSort sort;

    public AuditLogsSearchEventsRequest filter(AuditLogsQueryFilter filter) {
        this.filter = filter;
        this.unparsed |= filter.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AuditLogsQueryFilter getFilter() {
        return this.filter;
    }

    public void setFilter(AuditLogsQueryFilter filter) {
        this.filter = filter;
    }

    public AuditLogsSearchEventsRequest options(AuditLogsQueryOptions options) {
        this.options = options;
        this.unparsed |= options.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AuditLogsQueryOptions getOptions() {
        return this.options;
    }

    public void setOptions(AuditLogsQueryOptions options) {
        this.options = options;
    }

    public AuditLogsSearchEventsRequest page(AuditLogsQueryPageOptions page) {
        this.page = page;
        this.unparsed |= page.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AuditLogsQueryPageOptions getPage() {
        return this.page;
    }

    public void setPage(AuditLogsQueryPageOptions page) {
        this.page = page;
    }

    public AuditLogsSearchEventsRequest sort(AuditLogsSort sort) {
        this.sort = sort;
        this.unparsed |= !sort.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AuditLogsSort getSort() {
        return this.sort;
    }

    public void setSort(AuditLogsSort sort) {
        if (!sort.isValid()) {
            this.unparsed = true;
        }
        this.sort = sort;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuditLogsSearchEventsRequest auditLogsSearchEventsRequest = (AuditLogsSearchEventsRequest)o;
        return Objects.equals(this.filter, auditLogsSearchEventsRequest.filter) && Objects.equals(this.options, auditLogsSearchEventsRequest.options) && Objects.equals(this.page, auditLogsSearchEventsRequest.page) && Objects.equals(this.sort, auditLogsSearchEventsRequest.sort);
    }

    public int hashCode() {
        return Objects.hash(this.filter, this.options, this.page, this.sort);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuditLogsSearchEventsRequest {\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

