/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.AWSLogsLambda;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"account_id", "lambdas", "services"})
public class AWSLogsListResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ACCOUNT_ID = "account_id";
    private String accountId;
    public static final String JSON_PROPERTY_LAMBDAS = "lambdas";
    private List<AWSLogsLambda> lambdas = null;
    public static final String JSON_PROPERTY_SERVICES = "services";
    private List<String> services = null;

    public AWSLogsListResponse accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @JsonProperty(value="account_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public AWSLogsListResponse lambdas(List<AWSLogsLambda> lambdas) {
        this.lambdas = lambdas;
        for (AWSLogsLambda item : lambdas) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public AWSLogsListResponse addLambdasItem(AWSLogsLambda lambdasItem) {
        if (this.lambdas == null) {
            this.lambdas = new ArrayList<AWSLogsLambda>();
        }
        this.lambdas.add(lambdasItem);
        this.unparsed |= lambdasItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="lambdas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AWSLogsLambda> getLambdas() {
        return this.lambdas;
    }

    public void setLambdas(List<AWSLogsLambda> lambdas) {
        this.lambdas = lambdas;
    }

    public AWSLogsListResponse services(List<String> services) {
        this.services = services;
        return this;
    }

    public AWSLogsListResponse addServicesItem(String servicesItem) {
        if (this.services == null) {
            this.services = new ArrayList<String>();
        }
        this.services.add(servicesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="services")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getServices() {
        return this.services;
    }

    public void setServices(List<String> services) {
        this.services = services;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AWSLogsListResponse awsLogsListResponse = (AWSLogsListResponse)o;
        return Objects.equals(this.accountId, awsLogsListResponse.accountId) && Objects.equals(this.lambdas, awsLogsListResponse.lambdas) && Objects.equals(this.services, awsLogsListResponse.services);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.lambdas, this.services);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AWSLogsListResponse {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    lambdas: ").append(this.toIndentedString(this.lambdas)).append("\n");
        sb.append("    services: ").append(this.toIndentedString(this.services)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

