/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.IncidentServiceCreateAttributes;
import com.datadog.api.v2.client.model.IncidentServiceRelationships;
import com.datadog.api.v2.client.model.IncidentServiceType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Incident Service payload for create requests.")
@JsonPropertyOrder(value={"attributes", "relationships", "type"})
public class IncidentServiceCreateData {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private IncidentServiceCreateAttributes attributes;
    public static final String JSON_PROPERTY_RELATIONSHIPS = "relationships";
    private IncidentServiceRelationships relationships;
    public static final String JSON_PROPERTY_TYPE = "type";
    private IncidentServiceType type = IncidentServiceType.SERVICES;

    public IncidentServiceCreateData() {
    }

    @JsonCreator
    public IncidentServiceCreateData(@JsonProperty(required=true, value="type") IncidentServiceType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public IncidentServiceCreateData attributes(IncidentServiceCreateAttributes attributes) {
        this.attributes = attributes;
        this.unparsed |= attributes.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IncidentServiceCreateAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(IncidentServiceCreateAttributes attributes) {
        this.attributes = attributes;
    }

    public IncidentServiceCreateData relationships(IncidentServiceRelationships relationships) {
        this.relationships = relationships;
        this.unparsed |= relationships.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="relationships")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IncidentServiceRelationships getRelationships() {
        return this.relationships;
    }

    public void setRelationships(IncidentServiceRelationships relationships) {
        this.relationships = relationships;
    }

    public IncidentServiceCreateData type(IncidentServiceType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public IncidentServiceType getType() {
        return this.type;
    }

    public void setType(IncidentServiceType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncidentServiceCreateData incidentServiceCreateData = (IncidentServiceCreateData)o;
        return Objects.equals(this.attributes, incidentServiceCreateData.attributes) && Objects.equals(this.relationships, incidentServiceCreateData.relationships) && Objects.equals(this.type, incidentServiceCreateData.type);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.relationships, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IncidentServiceCreateData {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    relationships: ").append(this.toIndentedString(this.relationships)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

