/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.api;

import com.datadog.api.v2.client.ApiClient;
import com.datadog.api.v2.client.ApiException;
import com.datadog.api.v2.client.ApiResponse;
import com.datadog.api.v2.client.Configuration;
import com.datadog.api.v2.client.Pair;
import com.datadog.api.v2.client.model.LogsMetricCreateRequest;
import com.datadog.api.v2.client.model.LogsMetricResponse;
import com.datadog.api.v2.client.model.LogsMetricUpdateRequest;
import com.datadog.api.v2.client.model.LogsMetricsResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.GenericType;

public class LogsMetricsApi {
    private ApiClient apiClient;

    public LogsMetricsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public LogsMetricsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public LogsMetricResponse createLogsMetric(LogsMetricCreateRequest body) throws ApiException {
        return this.createLogsMetricWithHttpInfo(body).getData();
    }

    public CompletableFuture<LogsMetricResponse> createLogsMetricAsync(LogsMetricCreateRequest body) {
        return this.createLogsMetricWithHttpInfoAsync(body).thenApply(response -> (LogsMetricResponse)response.getData());
    }

    public ApiResponse<LogsMetricResponse> createLogsMetricWithHttpInfo(LogsMetricCreateRequest body) throws ApiException {
        LogsMetricCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createLogsMetric");
        }
        String localVarPath = "/api/v2/logs/config/metrics";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createLogsMetric");
        Invocation.Builder builder = this.apiClient.createBuilder("LogsMetricsApi.createLogsMetric", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsMetricResponse>(){});
    }

    public CompletableFuture<ApiResponse<LogsMetricResponse>> createLogsMetricWithHttpInfoAsync(LogsMetricCreateRequest body) {
        Invocation.Builder builder;
        LogsMetricCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<LogsMetricResponse>> result = new CompletableFuture<ApiResponse<LogsMetricResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createLogsMetric"));
            return result;
        }
        String localVarPath = "/api/v2/logs/config/metrics";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createLogsMetric");
        try {
            builder = this.apiClient.createBuilder("LogsMetricsApi.createLogsMetric", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<LogsMetricResponse>> result = new CompletableFuture<ApiResponse<LogsMetricResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsMetricResponse>(){});
    }

    public void deleteLogsMetric(String metricId) throws ApiException {
        this.deleteLogsMetricWithHttpInfo(metricId);
    }

    public CompletableFuture<Void> deleteLogsMetricAsync(String metricId) {
        return this.deleteLogsMetricWithHttpInfoAsync(metricId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteLogsMetricWithHttpInfo(String metricId) throws ApiException {
        Object localVarPostBody = null;
        if (metricId == null) {
            throw new ApiException(400, "Missing the required parameter 'metricId' when calling deleteLogsMetric");
        }
        String localVarPath = "/api/v2/logs/config/metrics/{metric_id}".replaceAll("\\{metric_id\\}", this.apiClient.escapeString(metricId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteLogsMetric");
        Invocation.Builder builder = this.apiClient.createBuilder("LogsMetricsApi.deleteLogsMetric", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteLogsMetricWithHttpInfoAsync(String metricId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (metricId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'metricId' when calling deleteLogsMetric"));
            return result;
        }
        String localVarPath = "/api/v2/logs/config/metrics/{metric_id}".replaceAll("\\{metric_id\\}", this.apiClient.escapeString(metricId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteLogsMetric");
        try {
            builder = this.apiClient.createBuilder("LogsMetricsApi.deleteLogsMetric", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public LogsMetricResponse getLogsMetric(String metricId) throws ApiException {
        return this.getLogsMetricWithHttpInfo(metricId).getData();
    }

    public CompletableFuture<LogsMetricResponse> getLogsMetricAsync(String metricId) {
        return this.getLogsMetricWithHttpInfoAsync(metricId).thenApply(response -> (LogsMetricResponse)response.getData());
    }

    public ApiResponse<LogsMetricResponse> getLogsMetricWithHttpInfo(String metricId) throws ApiException {
        Object localVarPostBody = null;
        if (metricId == null) {
            throw new ApiException(400, "Missing the required parameter 'metricId' when calling getLogsMetric");
        }
        String localVarPath = "/api/v2/logs/config/metrics/{metric_id}".replaceAll("\\{metric_id\\}", this.apiClient.escapeString(metricId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getLogsMetric");
        Invocation.Builder builder = this.apiClient.createBuilder("LogsMetricsApi.getLogsMetric", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsMetricResponse>(){});
    }

    public CompletableFuture<ApiResponse<LogsMetricResponse>> getLogsMetricWithHttpInfoAsync(String metricId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (metricId == null) {
            CompletableFuture<ApiResponse<LogsMetricResponse>> result = new CompletableFuture<ApiResponse<LogsMetricResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'metricId' when calling getLogsMetric"));
            return result;
        }
        String localVarPath = "/api/v2/logs/config/metrics/{metric_id}".replaceAll("\\{metric_id\\}", this.apiClient.escapeString(metricId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getLogsMetric");
        try {
            builder = this.apiClient.createBuilder("LogsMetricsApi.getLogsMetric", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<LogsMetricResponse>> result = new CompletableFuture<ApiResponse<LogsMetricResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsMetricResponse>(){});
    }

    public LogsMetricsResponse listLogsMetrics() throws ApiException {
        return this.listLogsMetricsWithHttpInfo().getData();
    }

    public CompletableFuture<LogsMetricsResponse> listLogsMetricsAsync() {
        return this.listLogsMetricsWithHttpInfoAsync().thenApply(response -> (LogsMetricsResponse)response.getData());
    }

    public ApiResponse<LogsMetricsResponse> listLogsMetricsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/logs/config/metrics";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listLogsMetrics");
        Invocation.Builder builder = this.apiClient.createBuilder("LogsMetricsApi.listLogsMetrics", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsMetricsResponse>(){});
    }

    public CompletableFuture<ApiResponse<LogsMetricsResponse>> listLogsMetricsWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/logs/config/metrics";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listLogsMetrics");
        try {
            builder = this.apiClient.createBuilder("LogsMetricsApi.listLogsMetrics", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<LogsMetricsResponse>> result = new CompletableFuture<ApiResponse<LogsMetricsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsMetricsResponse>(){});
    }

    public LogsMetricResponse updateLogsMetric(String metricId, LogsMetricUpdateRequest body) throws ApiException {
        return this.updateLogsMetricWithHttpInfo(metricId, body).getData();
    }

    public CompletableFuture<LogsMetricResponse> updateLogsMetricAsync(String metricId, LogsMetricUpdateRequest body) {
        return this.updateLogsMetricWithHttpInfoAsync(metricId, body).thenApply(response -> (LogsMetricResponse)response.getData());
    }

    public ApiResponse<LogsMetricResponse> updateLogsMetricWithHttpInfo(String metricId, LogsMetricUpdateRequest body) throws ApiException {
        LogsMetricUpdateRequest localVarPostBody = body;
        if (metricId == null) {
            throw new ApiException(400, "Missing the required parameter 'metricId' when calling updateLogsMetric");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateLogsMetric");
        }
        String localVarPath = "/api/v2/logs/config/metrics/{metric_id}".replaceAll("\\{metric_id\\}", this.apiClient.escapeString(metricId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateLogsMetric");
        Invocation.Builder builder = this.apiClient.createBuilder("LogsMetricsApi.updateLogsMetric", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsMetricResponse>(){});
    }

    public CompletableFuture<ApiResponse<LogsMetricResponse>> updateLogsMetricWithHttpInfoAsync(String metricId, LogsMetricUpdateRequest body) {
        Invocation.Builder builder;
        LogsMetricUpdateRequest localVarPostBody = body;
        if (metricId == null) {
            CompletableFuture<ApiResponse<LogsMetricResponse>> result = new CompletableFuture<ApiResponse<LogsMetricResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'metricId' when calling updateLogsMetric"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<LogsMetricResponse>> result = new CompletableFuture<ApiResponse<LogsMetricResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateLogsMetric"));
            return result;
        }
        String localVarPath = "/api/v2/logs/config/metrics/{metric_id}".replaceAll("\\{metric_id\\}", this.apiClient.escapeString(metricId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateLogsMetric");
        try {
            builder = this.apiClient.createBuilder("LogsMetricsApi.updateLogsMetric", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<LogsMetricResponse>> result = new CompletableFuture<ApiResponse<LogsMetricResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsMetricResponse>(){});
    }
}

