/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.SyntheticsBrowserTestFailureCode;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The browser test failure details.")
@JsonPropertyOrder(value={"code", "message"})
public class SyntheticsBrowserTestResultFailure {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CODE = "code";
    private SyntheticsBrowserTestFailureCode code;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;

    public SyntheticsBrowserTestResultFailure code(SyntheticsBrowserTestFailureCode code) {
        this.code = code;
        this.unparsed |= !code.isValid();
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsBrowserTestFailureCode getCode() {
        return this.code;
    }

    public void setCode(SyntheticsBrowserTestFailureCode code) {
        if (!code.isValid()) {
            this.unparsed = true;
        }
        this.code = code;
    }

    public SyntheticsBrowserTestResultFailure message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Error during DNS resolution (ENOTFOUND).", value="The browser test error message.")
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticsBrowserTestResultFailure syntheticsBrowserTestResultFailure = (SyntheticsBrowserTestResultFailure)o;
        return Objects.equals(this.code, syntheticsBrowserTestResultFailure.code) && Objects.equals(this.message, syntheticsBrowserTestResultFailure.message);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SyntheticsBrowserTestResultFailure {\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

