/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonSerialize(using=ScatterplotDimensionSerializer.class)
public class ScatterplotDimension {
    public static final ScatterplotDimension X = new ScatterplotDimension("x");
    public static final ScatterplotDimension Y = new ScatterplotDimension("y");
    public static final ScatterplotDimension RADIUS = new ScatterplotDimension("radius");
    public static final ScatterplotDimension COLOR = new ScatterplotDimension("color");
    private static final Set<String> allowedValues = new HashSet<String>(Arrays.asList("x", "y", "radius", "color"));
    private String value;

    public boolean isValid() {
        return allowedValues.contains(this.value);
    }

    ScatterplotDimension(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.value.equals(((ScatterplotDimension)o).value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static ScatterplotDimension fromValue(String value) {
        return new ScatterplotDimension(value);
    }

    public static class ScatterplotDimensionSerializer
    extends StdSerializer<ScatterplotDimension> {
        public ScatterplotDimensionSerializer(Class<ScatterplotDimension> t) {
            super(t);
        }

        public ScatterplotDimensionSerializer() {
            this(null);
        }

        public void serialize(ScatterplotDimension value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject((Object)value.value);
        }
    }
}

