/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.FunnelSource;
import com.datadog.api.v1.client.model.FunnelStep;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Updated funnel widget.")
@JsonPropertyOrder(value={"data_source", "query_string", "steps"})
public class FunnelQuery {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DATA_SOURCE = "data_source";
    private FunnelSource dataSource = FunnelSource.RUM;
    public static final String JSON_PROPERTY_QUERY_STRING = "query_string";
    private String queryString;
    public static final String JSON_PROPERTY_STEPS = "steps";
    private List<FunnelStep> steps = new ArrayList<FunnelStep>();

    public FunnelQuery() {
    }

    @JsonCreator
    public FunnelQuery(@JsonProperty(required=true, value="data_source") FunnelSource dataSource, @JsonProperty(required=true, value="query_string") String queryString, @JsonProperty(required=true, value="steps") List<FunnelStep> steps) {
        this.dataSource = dataSource;
        this.unparsed |= !dataSource.isValid();
        this.queryString = queryString;
        this.steps = steps;
    }

    public FunnelQuery dataSource(FunnelSource dataSource) {
        this.dataSource = dataSource;
        this.unparsed |= !dataSource.isValid();
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="data_source")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public FunnelSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(FunnelSource dataSource) {
        if (!dataSource.isValid()) {
            this.unparsed = true;
        }
        this.dataSource = dataSource;
    }

    public FunnelQuery queryString(String queryString) {
        this.queryString = queryString;
        return this;
    }

    @ApiModelProperty(example="@browser.name:Chrome", required=true, value="The widget query.")
    @JsonProperty(value="query_string")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public FunnelQuery steps(List<FunnelStep> steps) {
        this.steps = steps;
        for (FunnelStep item : steps) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public FunnelQuery addStepsItem(FunnelStep stepsItem) {
        this.steps.add(stepsItem);
        this.unparsed |= stepsItem.unparsed;
        return this;
    }

    @ApiModelProperty(required=true, value="List of funnel steps.")
    @JsonProperty(value="steps")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<FunnelStep> getSteps() {
        return this.steps;
    }

    public void setSteps(List<FunnelStep> steps) {
        this.steps = steps;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunnelQuery funnelQuery = (FunnelQuery)o;
        return Objects.equals(this.dataSource, funnelQuery.dataSource) && Objects.equals(this.queryString, funnelQuery.queryString) && Objects.equals(this.steps, funnelQuery.steps);
    }

    public int hashCode() {
        return Objects.hash(this.dataSource, this.queryString, this.steps);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FunnelQuery {\n");
        sb.append("    dataSource: ").append(this.toIndentedString(this.dataSource)).append("\n");
        sb.append("    queryString: ").append(this.toIndentedString(this.queryString)).append("\n");
        sb.append("    steps: ").append(this.toIndentedString(this.steps)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

