/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.AlertGraphWidgetDefinitionType;
import com.datadog.api.v1.client.model.WidgetTextAlign;
import com.datadog.api.v1.client.model.WidgetTime;
import com.datadog.api.v1.client.model.WidgetVizType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Alert graphs are timeseries graphs showing the current status of any monitor defined on your system.")
@JsonPropertyOrder(value={"alert_id", "time", "title", "title_align", "title_size", "type", "viz_type"})
public class AlertGraphWidgetDefinition {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ALERT_ID = "alert_id";
    private String alertId;
    public static final String JSON_PROPERTY_TIME = "time";
    private WidgetTime time;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_TITLE_ALIGN = "title_align";
    private WidgetTextAlign titleAlign;
    public static final String JSON_PROPERTY_TITLE_SIZE = "title_size";
    private String titleSize;
    public static final String JSON_PROPERTY_TYPE = "type";
    private AlertGraphWidgetDefinitionType type = AlertGraphWidgetDefinitionType.ALERT_GRAPH;
    public static final String JSON_PROPERTY_VIZ_TYPE = "viz_type";
    private WidgetVizType vizType;

    public AlertGraphWidgetDefinition() {
    }

    @JsonCreator
    public AlertGraphWidgetDefinition(@JsonProperty(required=true, value="alert_id") String alertId, @JsonProperty(required=true, value="type") AlertGraphWidgetDefinitionType type, @JsonProperty(required=true, value="viz_type") WidgetVizType vizType) {
        this.alertId = alertId;
        this.type = type;
        this.unparsed |= !type.isValid();
        this.vizType = vizType;
        this.unparsed |= !vizType.isValid();
    }

    public AlertGraphWidgetDefinition alertId(String alertId) {
        this.alertId = alertId;
        return this;
    }

    @ApiModelProperty(example="", required=true, value="ID of the alert to use in the widget.")
    @JsonProperty(value="alert_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAlertId() {
        return this.alertId;
    }

    public void setAlertId(String alertId) {
        this.alertId = alertId;
    }

    public AlertGraphWidgetDefinition time(WidgetTime time) {
        this.time = time;
        this.unparsed |= time.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="time")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTime getTime() {
        return this.time;
    }

    public void setTime(WidgetTime time) {
        this.time = time;
    }

    public AlertGraphWidgetDefinition title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The title of the widget.")
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public AlertGraphWidgetDefinition titleAlign(WidgetTextAlign titleAlign) {
        this.titleAlign = titleAlign;
        this.unparsed |= !titleAlign.isValid();
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="title_align")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTextAlign getTitleAlign() {
        return this.titleAlign;
    }

    public void setTitleAlign(WidgetTextAlign titleAlign) {
        if (!titleAlign.isValid()) {
            this.unparsed = true;
        }
        this.titleAlign = titleAlign;
    }

    public AlertGraphWidgetDefinition titleSize(String titleSize) {
        this.titleSize = titleSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Size of the title.")
    @JsonProperty(value="title_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitleSize() {
        return this.titleSize;
    }

    public void setTitleSize(String titleSize) {
        this.titleSize = titleSize;
    }

    public AlertGraphWidgetDefinition type(AlertGraphWidgetDefinitionType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AlertGraphWidgetDefinitionType getType() {
        return this.type;
    }

    public void setType(AlertGraphWidgetDefinitionType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public AlertGraphWidgetDefinition vizType(WidgetVizType vizType) {
        this.vizType = vizType;
        this.unparsed |= !vizType.isValid();
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="viz_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public WidgetVizType getVizType() {
        return this.vizType;
    }

    public void setVizType(WidgetVizType vizType) {
        if (!vizType.isValid()) {
            this.unparsed = true;
        }
        this.vizType = vizType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlertGraphWidgetDefinition alertGraphWidgetDefinition = (AlertGraphWidgetDefinition)o;
        return Objects.equals(this.alertId, alertGraphWidgetDefinition.alertId) && Objects.equals(this.time, alertGraphWidgetDefinition.time) && Objects.equals(this.title, alertGraphWidgetDefinition.title) && Objects.equals(this.titleAlign, alertGraphWidgetDefinition.titleAlign) && Objects.equals(this.titleSize, alertGraphWidgetDefinition.titleSize) && Objects.equals(this.type, alertGraphWidgetDefinition.type) && Objects.equals(this.vizType, alertGraphWidgetDefinition.vizType);
    }

    public int hashCode() {
        return Objects.hash(this.alertId, this.time, this.title, this.titleAlign, this.titleSize, this.type, this.vizType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AlertGraphWidgetDefinition {\n");
        sb.append("    alertId: ").append(this.toIndentedString(this.alertId)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    titleAlign: ").append(this.toIndentedString(this.titleAlign)).append("\n");
        sb.append("    titleSize: ").append(this.toIndentedString(this.titleSize)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    vizType: ").append(this.toIndentedString(this.vizType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

