/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.Dashboard;
import com.datadog.api.v1.client.model.DashboardBulkDeleteRequest;
import com.datadog.api.v1.client.model.DashboardDeleteResponse;
import com.datadog.api.v1.client.model.DashboardRestoreRequest;
import com.datadog.api.v1.client.model.DashboardSummary;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.GenericType;

public class DashboardsApi {
    private ApiClient apiClient;

    public DashboardsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DashboardsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Dashboard createDashboard(Dashboard body) throws ApiException {
        return this.createDashboardWithHttpInfo(body).getData();
    }

    public CompletableFuture<Dashboard> createDashboardAsync(Dashboard body) {
        return this.createDashboardWithHttpInfoAsync(body).thenApply(response -> (Dashboard)response.getData());
    }

    public ApiResponse<Dashboard> createDashboardWithHttpInfo(Dashboard body) throws ApiException {
        Dashboard localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createDashboard");
        }
        String localVarPath = "/api/v1/dashboard";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createDashboard");
        Invocation.Builder builder = this.apiClient.createBuilder("DashboardsApi.createDashboard", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Dashboard>(){});
    }

    public CompletableFuture<ApiResponse<Dashboard>> createDashboardWithHttpInfoAsync(Dashboard body) {
        Invocation.Builder builder;
        Dashboard localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<Dashboard>> result = new CompletableFuture<ApiResponse<Dashboard>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createDashboard"));
            return result;
        }
        String localVarPath = "/api/v1/dashboard";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createDashboard");
        try {
            builder = this.apiClient.createBuilder("DashboardsApi.createDashboard", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Dashboard>> result = new CompletableFuture<ApiResponse<Dashboard>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Dashboard>(){});
    }

    public DashboardDeleteResponse deleteDashboard(String dashboardId) throws ApiException {
        return this.deleteDashboardWithHttpInfo(dashboardId).getData();
    }

    public CompletableFuture<DashboardDeleteResponse> deleteDashboardAsync(String dashboardId) {
        return this.deleteDashboardWithHttpInfoAsync(dashboardId).thenApply(response -> (DashboardDeleteResponse)response.getData());
    }

    public ApiResponse<DashboardDeleteResponse> deleteDashboardWithHttpInfo(String dashboardId) throws ApiException {
        Object localVarPostBody = null;
        if (dashboardId == null) {
            throw new ApiException(400, "Missing the required parameter 'dashboardId' when calling deleteDashboard");
        }
        String localVarPath = "/api/v1/dashboard/{dashboard_id}".replaceAll("\\{dashboard_id\\}", this.apiClient.escapeString(dashboardId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteDashboard");
        Invocation.Builder builder = this.apiClient.createBuilder("DashboardsApi.deleteDashboard", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DashboardDeleteResponse>(){});
    }

    public CompletableFuture<ApiResponse<DashboardDeleteResponse>> deleteDashboardWithHttpInfoAsync(String dashboardId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (dashboardId == null) {
            CompletableFuture<ApiResponse<DashboardDeleteResponse>> result = new CompletableFuture<ApiResponse<DashboardDeleteResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'dashboardId' when calling deleteDashboard"));
            return result;
        }
        String localVarPath = "/api/v1/dashboard/{dashboard_id}".replaceAll("\\{dashboard_id\\}", this.apiClient.escapeString(dashboardId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteDashboard");
        try {
            builder = this.apiClient.createBuilder("DashboardsApi.deleteDashboard", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DashboardDeleteResponse>> result = new CompletableFuture<ApiResponse<DashboardDeleteResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DashboardDeleteResponse>(){});
    }

    public void deleteDashboards(DashboardBulkDeleteRequest body) throws ApiException {
        this.deleteDashboardsWithHttpInfo(body);
    }

    public CompletableFuture<Void> deleteDashboardsAsync(DashboardBulkDeleteRequest body) {
        return this.deleteDashboardsWithHttpInfoAsync(body).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteDashboardsWithHttpInfo(DashboardBulkDeleteRequest body) throws ApiException {
        DashboardBulkDeleteRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling deleteDashboards");
        }
        String localVarPath = "/api/v1/dashboard";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteDashboards");
        Invocation.Builder builder = this.apiClient.createBuilder("DashboardsApi.deleteDashboards", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteDashboardsWithHttpInfoAsync(DashboardBulkDeleteRequest body) {
        Invocation.Builder builder;
        DashboardBulkDeleteRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling deleteDashboards"));
            return result;
        }
        String localVarPath = "/api/v1/dashboard";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteDashboards");
        try {
            builder = this.apiClient.createBuilder("DashboardsApi.deleteDashboards", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public Dashboard getDashboard(String dashboardId) throws ApiException {
        return this.getDashboardWithHttpInfo(dashboardId).getData();
    }

    public CompletableFuture<Dashboard> getDashboardAsync(String dashboardId) {
        return this.getDashboardWithHttpInfoAsync(dashboardId).thenApply(response -> (Dashboard)response.getData());
    }

    public ApiResponse<Dashboard> getDashboardWithHttpInfo(String dashboardId) throws ApiException {
        Object localVarPostBody = null;
        if (dashboardId == null) {
            throw new ApiException(400, "Missing the required parameter 'dashboardId' when calling getDashboard");
        }
        String localVarPath = "/api/v1/dashboard/{dashboard_id}".replaceAll("\\{dashboard_id\\}", this.apiClient.escapeString(dashboardId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getDashboard");
        Invocation.Builder builder = this.apiClient.createBuilder("DashboardsApi.getDashboard", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Dashboard>(){});
    }

    public CompletableFuture<ApiResponse<Dashboard>> getDashboardWithHttpInfoAsync(String dashboardId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (dashboardId == null) {
            CompletableFuture<ApiResponse<Dashboard>> result = new CompletableFuture<ApiResponse<Dashboard>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'dashboardId' when calling getDashboard"));
            return result;
        }
        String localVarPath = "/api/v1/dashboard/{dashboard_id}".replaceAll("\\{dashboard_id\\}", this.apiClient.escapeString(dashboardId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getDashboard");
        try {
            builder = this.apiClient.createBuilder("DashboardsApi.getDashboard", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Dashboard>> result = new CompletableFuture<ApiResponse<Dashboard>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Dashboard>(){});
    }

    public DashboardSummary listDashboards() throws ApiException {
        return this.listDashboardsWithHttpInfo(new ListDashboardsOptionalParameters()).getData();
    }

    public CompletableFuture<DashboardSummary> listDashboardsAsync() {
        return this.listDashboardsWithHttpInfoAsync(new ListDashboardsOptionalParameters()).thenApply(response -> (DashboardSummary)response.getData());
    }

    public DashboardSummary listDashboards(ListDashboardsOptionalParameters parameters) throws ApiException {
        return this.listDashboardsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<DashboardSummary> listDashboardsAsync(ListDashboardsOptionalParameters parameters) {
        return this.listDashboardsWithHttpInfoAsync(parameters).thenApply(response -> (DashboardSummary)response.getData());
    }

    public ApiResponse<DashboardSummary> listDashboardsWithHttpInfo(ListDashboardsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Boolean filterShared = parameters.filterShared;
        Boolean filterDeleted = parameters.filterDeleted;
        String localVarPath = "/api/v1/dashboard";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[shared]", filterShared));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[deleted]", filterDeleted));
        localVarHeaderParams.put("DD-OPERATION-ID", "listDashboards");
        Invocation.Builder builder = this.apiClient.createBuilder("DashboardsApi.listDashboards", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DashboardSummary>(){});
    }

    public CompletableFuture<ApiResponse<DashboardSummary>> listDashboardsWithHttpInfoAsync(ListDashboardsOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        Boolean filterShared = parameters.filterShared;
        Boolean filterDeleted = parameters.filterDeleted;
        String localVarPath = "/api/v1/dashboard";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[shared]", filterShared));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[deleted]", filterDeleted));
        localVarHeaderParams.put("DD-OPERATION-ID", "listDashboards");
        try {
            builder = this.apiClient.createBuilder("DashboardsApi.listDashboards", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DashboardSummary>> result = new CompletableFuture<ApiResponse<DashboardSummary>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DashboardSummary>(){});
    }

    public void restoreDashboards(DashboardRestoreRequest body) throws ApiException {
        this.restoreDashboardsWithHttpInfo(body);
    }

    public CompletableFuture<Void> restoreDashboardsAsync(DashboardRestoreRequest body) {
        return this.restoreDashboardsWithHttpInfoAsync(body).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> restoreDashboardsWithHttpInfo(DashboardRestoreRequest body) throws ApiException {
        DashboardRestoreRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling restoreDashboards");
        }
        String localVarPath = "/api/v1/dashboard";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "restoreDashboards");
        Invocation.Builder builder = this.apiClient.createBuilder("DashboardsApi.restoreDashboards", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> restoreDashboardsWithHttpInfoAsync(DashboardRestoreRequest body) {
        Invocation.Builder builder;
        DashboardRestoreRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling restoreDashboards"));
            return result;
        }
        String localVarPath = "/api/v1/dashboard";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "restoreDashboards");
        try {
            builder = this.apiClient.createBuilder("DashboardsApi.restoreDashboards", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public Dashboard updateDashboard(String dashboardId, Dashboard body) throws ApiException {
        return this.updateDashboardWithHttpInfo(dashboardId, body).getData();
    }

    public CompletableFuture<Dashboard> updateDashboardAsync(String dashboardId, Dashboard body) {
        return this.updateDashboardWithHttpInfoAsync(dashboardId, body).thenApply(response -> (Dashboard)response.getData());
    }

    public ApiResponse<Dashboard> updateDashboardWithHttpInfo(String dashboardId, Dashboard body) throws ApiException {
        Dashboard localVarPostBody = body;
        if (dashboardId == null) {
            throw new ApiException(400, "Missing the required parameter 'dashboardId' when calling updateDashboard");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateDashboard");
        }
        String localVarPath = "/api/v1/dashboard/{dashboard_id}".replaceAll("\\{dashboard_id\\}", this.apiClient.escapeString(dashboardId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateDashboard");
        Invocation.Builder builder = this.apiClient.createBuilder("DashboardsApi.updateDashboard", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Dashboard>(){});
    }

    public CompletableFuture<ApiResponse<Dashboard>> updateDashboardWithHttpInfoAsync(String dashboardId, Dashboard body) {
        Invocation.Builder builder;
        Dashboard localVarPostBody = body;
        if (dashboardId == null) {
            CompletableFuture<ApiResponse<Dashboard>> result = new CompletableFuture<ApiResponse<Dashboard>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'dashboardId' when calling updateDashboard"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<Dashboard>> result = new CompletableFuture<ApiResponse<Dashboard>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateDashboard"));
            return result;
        }
        String localVarPath = "/api/v1/dashboard/{dashboard_id}".replaceAll("\\{dashboard_id\\}", this.apiClient.escapeString(dashboardId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateDashboard");
        try {
            builder = this.apiClient.createBuilder("DashboardsApi.updateDashboard", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Dashboard>> result = new CompletableFuture<ApiResponse<Dashboard>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Dashboard>(){});
    }

    public static class ListDashboardsOptionalParameters {
        private Boolean filterShared;
        private Boolean filterDeleted;

        public ListDashboardsOptionalParameters filterShared(Boolean filterShared) {
            this.filterShared = filterShared;
            return this;
        }

        public ListDashboardsOptionalParameters filterDeleted(Boolean filterDeleted) {
            this.filterDeleted = filterDeleted;
            return this;
        }
    }
}

