/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Global query options that are used during the query. Note: You should only supply timezone or time offset but not both otherwise the query will fail.")
@JsonPropertyOrder(value={"timeOffset", "timezone"})
public class LogsQueryOptions {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_TIME_OFFSET = "timeOffset";
    private Long timeOffset;
    public static final String JSON_PROPERTY_TIMEZONE = "timezone";
    private String timezone = "UTC";

    public LogsQueryOptions timeOffset(Long timeOffset) {
        this.timeOffset = timeOffset;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time offset (in seconds) to apply to the query.")
    @JsonProperty(value="timeOffset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getTimeOffset() {
        return this.timeOffset;
    }

    public void setTimeOffset(Long timeOffset) {
        this.timeOffset = timeOffset;
    }

    public LogsQueryOptions timezone(String timezone) {
        this.timezone = timezone;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="GMT", value="The timezone can be specified both as an offset, for example: \"UTC+03:00\".")
    @JsonProperty(value="timezone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsQueryOptions logsQueryOptions = (LogsQueryOptions)o;
        return Objects.equals(this.timeOffset, logsQueryOptions.timeOffset) && Objects.equals(this.timezone, logsQueryOptions.timezone);
    }

    public int hashCode() {
        return Objects.hash(this.timeOffset, this.timezone);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsQueryOptions {\n");
        sb.append("    timeOffset: ").append(this.toIndentedString(this.timeOffset)).append("\n");
        sb.append("    timezone: ").append(this.toIndentedString(this.timezone)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

