/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.User;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Array of Datadog users for a given organization.")
@JsonPropertyOrder(value={"users"})
public class UserListResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_USERS = "users";
    private List<User> users = null;

    public UserListResponse users(List<User> users) {
        this.users = users;
        for (User item : users) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public UserListResponse addUsersItem(User usersItem) {
        if (this.users == null) {
            this.users = new ArrayList<User>();
        }
        this.users.add(usersItem);
        this.unparsed |= usersItem.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of users.")
    @JsonProperty(value="users")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<User> getUsers() {
        return this.users;
    }

    public void setUsers(List<User> users) {
        this.users = users;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserListResponse userListResponse = (UserListResponse)o;
        return Objects.equals(this.users, userListResponse.users);
    }

    public int hashCode() {
        return Objects.hash(this.users);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserListResponse {\n");
        sb.append("    users: ").append(this.toIndentedString(this.users)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

