/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Incident management usage for a given organization for a given hour.")
@JsonPropertyOrder(value={"hour", "monthly_active_users"})
public class UsageIncidentManagementHour {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_HOUR = "hour";
    private OffsetDateTime hour;
    public static final String JSON_PROPERTY_MONTHLY_ACTIVE_USERS = "monthly_active_users";
    private Long monthlyActiveUsers;

    public UsageIncidentManagementHour hour(OffsetDateTime hour) {
        this.hour = hour;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The hour for the usage.")
    @JsonProperty(value="hour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getHour() {
        return this.hour;
    }

    public void setHour(OffsetDateTime hour) {
        this.hour = hour;
    }

    public UsageIncidentManagementHour monthlyActiveUsers(Long monthlyActiveUsers) {
        this.monthlyActiveUsers = monthlyActiveUsers;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contains the total number monthly active users from the start of the given hour's month until the given hour.")
    @JsonProperty(value="monthly_active_users")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getMonthlyActiveUsers() {
        return this.monthlyActiveUsers;
    }

    public void setMonthlyActiveUsers(Long monthlyActiveUsers) {
        this.monthlyActiveUsers = monthlyActiveUsers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageIncidentManagementHour usageIncidentManagementHour = (UsageIncidentManagementHour)o;
        return Objects.equals(this.hour, usageIncidentManagementHour.hour) && Objects.equals(this.monthlyActiveUsers, usageIncidentManagementHour.monthlyActiveUsers);
    }

    public int hashCode() {
        return Objects.hash(this.hour, this.monthlyActiveUsers);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageIncidentManagementHour {\n");
        sb.append("    hour: ").append(this.toIndentedString(this.hour)).append("\n");
        sb.append("    monthlyActiveUsers: ").append(this.toIndentedString(this.monthlyActiveUsers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

