/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonSerialize(using=SLOErrorTimeframeSerializer.class)
public class SLOErrorTimeframe {
    public static final SLOErrorTimeframe SEVEN_DAYS = new SLOErrorTimeframe("7d");
    public static final SLOErrorTimeframe THIRTY_DAYS = new SLOErrorTimeframe("30d");
    public static final SLOErrorTimeframe NINETY_DAYS = new SLOErrorTimeframe("90d");
    public static final SLOErrorTimeframe ALL = new SLOErrorTimeframe("all");
    private static final Set<String> allowedValues = new HashSet<String>(Arrays.asList("7d", "30d", "90d", "all"));
    private String value;

    public boolean isValid() {
        return allowedValues.contains(this.value);
    }

    SLOErrorTimeframe(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.value.equals(((SLOErrorTimeframe)o).value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static SLOErrorTimeframe fromValue(String value) {
        return new SLOErrorTimeframe(value);
    }

    public static class SLOErrorTimeframeSerializer
    extends StdSerializer<SLOErrorTimeframe> {
        public SLOErrorTimeframeSerializer(Class<SLOErrorTimeframe> t) {
            super(t);
        }

        public SLOErrorTimeframeSerializer() {
            this(null);
        }

        public void serialize(SLOErrorTimeframe value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject((Object)value.value);
        }
    }
}

