/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.SecurityFilterExclusionFilter;
import com.datadog.api.v2.client.model.SecurityFilterFilteredDataType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Object containing the attributes of the security filter to be created.")
@JsonPropertyOrder(value={"exclusion_filters", "filtered_data_type", "is_enabled", "name", "query"})
public class SecurityFilterCreateAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_EXCLUSION_FILTERS = "exclusion_filters";
    private List<SecurityFilterExclusionFilter> exclusionFilters = new ArrayList<SecurityFilterExclusionFilter>();
    public static final String JSON_PROPERTY_FILTERED_DATA_TYPE = "filtered_data_type";
    private SecurityFilterFilteredDataType filteredDataType;
    public static final String JSON_PROPERTY_IS_ENABLED = "is_enabled";
    private Boolean isEnabled;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_QUERY = "query";
    private String query;

    public SecurityFilterCreateAttributes() {
    }

    @JsonCreator
    public SecurityFilterCreateAttributes(@JsonProperty(required=true, value="exclusion_filters") List<SecurityFilterExclusionFilter> exclusionFilters, @JsonProperty(required=true, value="filtered_data_type") SecurityFilterFilteredDataType filteredDataType, @JsonProperty(required=true, value="is_enabled") Boolean isEnabled, @JsonProperty(required=true, value="name") String name, @JsonProperty(required=true, value="query") String query) {
        this.exclusionFilters = exclusionFilters;
        this.filteredDataType = filteredDataType;
        this.unparsed |= !filteredDataType.isValid();
        this.isEnabled = isEnabled;
        this.name = name;
        this.query = query;
    }

    public SecurityFilterCreateAttributes exclusionFilters(List<SecurityFilterExclusionFilter> exclusionFilters) {
        this.exclusionFilters = exclusionFilters;
        for (SecurityFilterExclusionFilter item : exclusionFilters) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SecurityFilterCreateAttributes addExclusionFiltersItem(SecurityFilterExclusionFilter exclusionFiltersItem) {
        this.exclusionFilters.add(exclusionFiltersItem);
        this.unparsed |= exclusionFiltersItem.unparsed;
        return this;
    }

    @ApiModelProperty(example="[{\"name\":\"Exclude staging\",\"query\":\"source:staging\"}]", required=true, value="Exclusion filters to exclude some logs from the security filter.")
    @JsonProperty(value="exclusion_filters")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SecurityFilterExclusionFilter> getExclusionFilters() {
        return this.exclusionFilters;
    }

    public void setExclusionFilters(List<SecurityFilterExclusionFilter> exclusionFilters) {
        this.exclusionFilters = exclusionFilters;
    }

    public SecurityFilterCreateAttributes filteredDataType(SecurityFilterFilteredDataType filteredDataType) {
        this.filteredDataType = filteredDataType;
        this.unparsed |= !filteredDataType.isValid();
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="filtered_data_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SecurityFilterFilteredDataType getFilteredDataType() {
        return this.filteredDataType;
    }

    public void setFilteredDataType(SecurityFilterFilteredDataType filteredDataType) {
        if (!filteredDataType.isValid()) {
            this.unparsed = true;
        }
        this.filteredDataType = filteredDataType;
    }

    public SecurityFilterCreateAttributes isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @ApiModelProperty(example="true", required=true, value="Whether the security filter is enabled.")
    @JsonProperty(value="is_enabled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public SecurityFilterCreateAttributes name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="Custom security filter", required=true, value="The name of the security filter.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SecurityFilterCreateAttributes query(String query) {
        this.query = query;
        return this;
    }

    @ApiModelProperty(example="service:api", required=true, value="The query of the security filter.")
    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityFilterCreateAttributes securityFilterCreateAttributes = (SecurityFilterCreateAttributes)o;
        return Objects.equals(this.exclusionFilters, securityFilterCreateAttributes.exclusionFilters) && Objects.equals(this.filteredDataType, securityFilterCreateAttributes.filteredDataType) && Objects.equals(this.isEnabled, securityFilterCreateAttributes.isEnabled) && Objects.equals(this.name, securityFilterCreateAttributes.name) && Objects.equals(this.query, securityFilterCreateAttributes.query);
    }

    public int hashCode() {
        return Objects.hash(this.exclusionFilters, this.filteredDataType, this.isEnabled, this.name, this.query);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityFilterCreateAttributes {\n");
        sb.append("    exclusionFilters: ").append(this.toIndentedString(this.exclusionFilters)).append("\n");
        sb.append("    filteredDataType: ").append(this.toIndentedString(this.filteredDataType)).append("\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

