/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.APIKeyRelationships;
import com.datadog.api.v2.client.model.APIKeysType;
import com.datadog.api.v2.client.model.PartialAPIKeyAttributes;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Partial Datadog API key.")
@JsonPropertyOrder(value={"attributes", "id", "relationships", "type"})
public class PartialAPIKey {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private PartialAPIKeyAttributes attributes;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_RELATIONSHIPS = "relationships";
    private APIKeyRelationships relationships;
    public static final String JSON_PROPERTY_TYPE = "type";
    private APIKeysType type = APIKeysType.API_KEYS;

    public PartialAPIKey attributes(PartialAPIKeyAttributes attributes) {
        this.attributes = attributes;
        this.unparsed |= attributes.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PartialAPIKeyAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(PartialAPIKeyAttributes attributes) {
        this.attributes = attributes;
    }

    public PartialAPIKey id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of the API key.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public PartialAPIKey relationships(APIKeyRelationships relationships) {
        this.relationships = relationships;
        this.unparsed |= relationships.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="relationships")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public APIKeyRelationships getRelationships() {
        return this.relationships;
    }

    public void setRelationships(APIKeyRelationships relationships) {
        this.relationships = relationships;
    }

    public PartialAPIKey type(APIKeysType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public APIKeysType getType() {
        return this.type;
    }

    public void setType(APIKeysType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartialAPIKey partialAPIKey = (PartialAPIKey)o;
        return Objects.equals(this.attributes, partialAPIKey.attributes) && Objects.equals(this.id, partialAPIKey.id) && Objects.equals(this.relationships, partialAPIKey.relationships) && Objects.equals(this.type, partialAPIKey.type);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.id, this.relationships, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PartialAPIKey {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    relationships: ").append(this.toIndentedString(this.relationships)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

