/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.LogsArchiveAttributes;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The definition of an archive.")
@JsonPropertyOrder(value={"attributes", "id", "type"})
public class LogsArchiveDefinition {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private LogsArchiveAttributes attributes;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type = "archives";

    public LogsArchiveDefinition() {
    }

    @JsonCreator
    public LogsArchiveDefinition(@JsonProperty(required=true, value="type") String type) {
        this.type = type;
    }

    public LogsArchiveDefinition attributes(LogsArchiveAttributes attributes) {
        this.attributes = attributes;
        this.unparsed |= attributes.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogsArchiveAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(LogsArchiveAttributes attributes) {
        this.attributes = attributes;
    }

    @Nullable
    @ApiModelProperty(example="a2zcMylnM4OCHpYusxIi3g", value="The archive ID.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="archives", required=true, value="The type of the resource. The value should always be archives.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsArchiveDefinition logsArchiveDefinition = (LogsArchiveDefinition)o;
        return Objects.equals(this.attributes, logsArchiveDefinition.attributes) && Objects.equals(this.id, logsArchiveDefinition.id) && Objects.equals(this.type, logsArchiveDefinition.type);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.id, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsArchiveDefinition {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

