/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Database Monitoring usage for a given organization for a given hour.")
@JsonPropertyOrder(value={"dbm_host_count", "dbm_queries_count", "hour"})
public class UsageDBMHour {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DBM_HOST_COUNT = "dbm_host_count";
    private Long dbmHostCount;
    public static final String JSON_PROPERTY_DBM_QUERIES_COUNT = "dbm_queries_count";
    private Long dbmQueriesCount;
    public static final String JSON_PROPERTY_HOUR = "hour";
    private OffsetDateTime hour;

    public UsageDBMHour dbmHostCount(Long dbmHostCount) {
        this.dbmHostCount = dbmHostCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of Database Monitoring host hours from the start of the given hour\u2019s month until the given hour.")
    @JsonProperty(value="dbm_host_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getDbmHostCount() {
        return this.dbmHostCount;
    }

    public void setDbmHostCount(Long dbmHostCount) {
        this.dbmHostCount = dbmHostCount;
    }

    public UsageDBMHour dbmQueriesCount(Long dbmQueriesCount) {
        this.dbmQueriesCount = dbmQueriesCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of normalized Database Monitoring queries from the start of the given hour\u2019s month until the given hour.")
    @JsonProperty(value="dbm_queries_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getDbmQueriesCount() {
        return this.dbmQueriesCount;
    }

    public void setDbmQueriesCount(Long dbmQueriesCount) {
        this.dbmQueriesCount = dbmQueriesCount;
    }

    public UsageDBMHour hour(OffsetDateTime hour) {
        this.hour = hour;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The hour for the usage.")
    @JsonProperty(value="hour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getHour() {
        return this.hour;
    }

    public void setHour(OffsetDateTime hour) {
        this.hour = hour;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageDBMHour usageDBMHour = (UsageDBMHour)o;
        return Objects.equals(this.dbmHostCount, usageDBMHour.dbmHostCount) && Objects.equals(this.dbmQueriesCount, usageDBMHour.dbmQueriesCount) && Objects.equals(this.hour, usageDBMHour.hour);
    }

    public int hashCode() {
        return Objects.hash(this.dbmHostCount, this.dbmQueriesCount, this.hour);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageDBMHour {\n");
        sb.append("    dbmHostCount: ").append(this.toIndentedString(this.dbmHostCount)).append("\n");
        sb.append("    dbmQueriesCount: ").append(this.toIndentedString(this.dbmQueriesCount)).append("\n");
        sb.append("    hour: ").append(this.toIndentedString(this.hour)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

