/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An array of service level objective objects.")
@JsonPropertyOrder(value={"deleted", "updated"})
public class SLOBulkDeleteResponseData {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DELETED = "deleted";
    private List<String> deleted = null;
    public static final String JSON_PROPERTY_UPDATED = "updated";
    private List<String> updated = null;

    public SLOBulkDeleteResponseData deleted(List<String> deleted) {
        this.deleted = deleted;
        return this;
    }

    public SLOBulkDeleteResponseData addDeletedItem(String deletedItem) {
        if (this.deleted == null) {
            this.deleted = new ArrayList<String>();
        }
        this.deleted.add(deletedItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of service level objective object IDs that indicates which objects that were completely deleted.")
    @JsonProperty(value="deleted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDeleted() {
        return this.deleted;
    }

    public void setDeleted(List<String> deleted) {
        this.deleted = deleted;
    }

    public SLOBulkDeleteResponseData updated(List<String> updated) {
        this.updated = updated;
        return this;
    }

    public SLOBulkDeleteResponseData addUpdatedItem(String updatedItem) {
        if (this.updated == null) {
            this.updated = new ArrayList<String>();
        }
        this.updated.add(updatedItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of service level objective object IDs that indicates which objects that were modified (objects for which at least one threshold was deleted, but that were not completely deleted).")
    @JsonProperty(value="updated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getUpdated() {
        return this.updated;
    }

    public void setUpdated(List<String> updated) {
        this.updated = updated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SLOBulkDeleteResponseData slOBulkDeleteResponseData = (SLOBulkDeleteResponseData)o;
        return Objects.equals(this.deleted, slOBulkDeleteResponseData.deleted) && Objects.equals(this.updated, slOBulkDeleteResponseData.updated);
    }

    public int hashCode() {
        return Objects.hash(this.deleted, this.updated);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SLOBulkDeleteResponseData {\n");
        sb.append("    deleted: ").append(this.toIndentedString(this.deleted)).append("\n");
        sb.append("    updated: ").append(this.toIndentedString(this.updated)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

