/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Global hourly report of all data billed by Datadog for a given organization.")
@JsonPropertyOrder(value={"agent_host_top99p", "apm_azure_app_service_host_top99p", "apm_host_top99p", "audit_logs_lines_indexed_sum", "aws_host_top99p", "aws_lambda_func_count", "aws_lambda_invocations_sum", "azure_app_service_top99p", "billable_ingested_bytes_sum", "container_avg", "container_hwm", "cspm_container_avg", "cspm_container_hwm", "cspm_host_top99p", "custom_ts_avg", "cws_container_count_avg", "cws_host_top99p", "dbm_host_top99p_sum", "dbm_queries_avg_sum", "fargate_tasks_count_avg", "fargate_tasks_count_hwm", "gcp_host_top99p", "heroku_host_top99p", "id", "incident_management_monthly_active_users_hwm", "indexed_events_count_sum", "infra_host_top99p", "ingested_events_bytes_sum", "iot_device_agg_sum", "iot_device_top99p_sum", "mobile_rum_session_count_android_sum", "mobile_rum_session_count_ios_sum", "mobile_rum_session_count_sum", "name", "netflow_indexed_events_count_sum", "npm_host_top99p", "opentelemetry_host_top99p", "profiling_host_top99p", "public_id", "rum_session_count_sum", "rum_total_session_count_sum", "synthetics_browser_check_calls_count_sum", "synthetics_check_calls_count_sum", "trace_search_indexed_events_count_sum", "twol_ingested_events_bytes_sum", "vsphere_host_top99p"})
public class UsageSummaryDateOrg {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_AGENT_HOST_TOP99P = "agent_host_top99p";
    private Long agentHostTop99p;
    public static final String JSON_PROPERTY_APM_AZURE_APP_SERVICE_HOST_TOP99P = "apm_azure_app_service_host_top99p";
    private Long apmAzureAppServiceHostTop99p;
    public static final String JSON_PROPERTY_APM_HOST_TOP99P = "apm_host_top99p";
    private Long apmHostTop99p;
    public static final String JSON_PROPERTY_AUDIT_LOGS_LINES_INDEXED_SUM = "audit_logs_lines_indexed_sum";
    private Long auditLogsLinesIndexedSum;
    public static final String JSON_PROPERTY_AWS_HOST_TOP99P = "aws_host_top99p";
    private Long awsHostTop99p;
    public static final String JSON_PROPERTY_AWS_LAMBDA_FUNC_COUNT = "aws_lambda_func_count";
    private Long awsLambdaFuncCount;
    public static final String JSON_PROPERTY_AWS_LAMBDA_INVOCATIONS_SUM = "aws_lambda_invocations_sum";
    private Long awsLambdaInvocationsSum;
    public static final String JSON_PROPERTY_AZURE_APP_SERVICE_TOP99P = "azure_app_service_top99p";
    private Long azureAppServiceTop99p;
    public static final String JSON_PROPERTY_BILLABLE_INGESTED_BYTES_SUM = "billable_ingested_bytes_sum";
    private Long billableIngestedBytesSum;
    public static final String JSON_PROPERTY_CONTAINER_AVG = "container_avg";
    private Long containerAvg;
    public static final String JSON_PROPERTY_CONTAINER_HWM = "container_hwm";
    private Long containerHwm;
    public static final String JSON_PROPERTY_CSPM_CONTAINER_AVG = "cspm_container_avg";
    private Long cspmContainerAvg;
    public static final String JSON_PROPERTY_CSPM_CONTAINER_HWM = "cspm_container_hwm";
    private Long cspmContainerHwm;
    public static final String JSON_PROPERTY_CSPM_HOST_TOP99P = "cspm_host_top99p";
    private Long cspmHostTop99p;
    public static final String JSON_PROPERTY_CUSTOM_TS_AVG = "custom_ts_avg";
    private Long customTsAvg;
    public static final String JSON_PROPERTY_CWS_CONTAINER_COUNT_AVG = "cws_container_count_avg";
    private Long cwsContainerCountAvg;
    public static final String JSON_PROPERTY_CWS_HOST_TOP99P = "cws_host_top99p";
    private Long cwsHostTop99p;
    public static final String JSON_PROPERTY_DBM_HOST_TOP99P_SUM = "dbm_host_top99p_sum";
    private Long dbmHostTop99pSum;
    public static final String JSON_PROPERTY_DBM_QUERIES_AVG_SUM = "dbm_queries_avg_sum";
    private Long dbmQueriesAvgSum;
    public static final String JSON_PROPERTY_FARGATE_TASKS_COUNT_AVG = "fargate_tasks_count_avg";
    private Long fargateTasksCountAvg;
    public static final String JSON_PROPERTY_FARGATE_TASKS_COUNT_HWM = "fargate_tasks_count_hwm";
    private Long fargateTasksCountHwm;
    public static final String JSON_PROPERTY_GCP_HOST_TOP99P = "gcp_host_top99p";
    private Long gcpHostTop99p;
    public static final String JSON_PROPERTY_HEROKU_HOST_TOP99P = "heroku_host_top99p";
    private Long herokuHostTop99p;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_INCIDENT_MANAGEMENT_MONTHLY_ACTIVE_USERS_HWM = "incident_management_monthly_active_users_hwm";
    private Long incidentManagementMonthlyActiveUsersHwm;
    public static final String JSON_PROPERTY_INDEXED_EVENTS_COUNT_SUM = "indexed_events_count_sum";
    private Long indexedEventsCountSum;
    public static final String JSON_PROPERTY_INFRA_HOST_TOP99P = "infra_host_top99p";
    private Long infraHostTop99p;
    public static final String JSON_PROPERTY_INGESTED_EVENTS_BYTES_SUM = "ingested_events_bytes_sum";
    private Long ingestedEventsBytesSum;
    public static final String JSON_PROPERTY_IOT_DEVICE_AGG_SUM = "iot_device_agg_sum";
    private Long iotDeviceAggSum;
    public static final String JSON_PROPERTY_IOT_DEVICE_TOP99P_SUM = "iot_device_top99p_sum";
    private Long iotDeviceTop99pSum;
    public static final String JSON_PROPERTY_MOBILE_RUM_SESSION_COUNT_ANDROID_SUM = "mobile_rum_session_count_android_sum";
    private Long mobileRumSessionCountAndroidSum;
    public static final String JSON_PROPERTY_MOBILE_RUM_SESSION_COUNT_IOS_SUM = "mobile_rum_session_count_ios_sum";
    private Long mobileRumSessionCountIosSum;
    public static final String JSON_PROPERTY_MOBILE_RUM_SESSION_COUNT_SUM = "mobile_rum_session_count_sum";
    private Long mobileRumSessionCountSum;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_NETFLOW_INDEXED_EVENTS_COUNT_SUM = "netflow_indexed_events_count_sum";
    private Long netflowIndexedEventsCountSum;
    public static final String JSON_PROPERTY_NPM_HOST_TOP99P = "npm_host_top99p";
    private Long npmHostTop99p;
    public static final String JSON_PROPERTY_OPENTELEMETRY_HOST_TOP99P = "opentelemetry_host_top99p";
    private Long opentelemetryHostTop99p;
    public static final String JSON_PROPERTY_PROFILING_HOST_TOP99P = "profiling_host_top99p";
    private Long profilingHostTop99p;
    public static final String JSON_PROPERTY_PUBLIC_ID = "public_id";
    private String publicId;
    public static final String JSON_PROPERTY_RUM_SESSION_COUNT_SUM = "rum_session_count_sum";
    private Long rumSessionCountSum;
    public static final String JSON_PROPERTY_RUM_TOTAL_SESSION_COUNT_SUM = "rum_total_session_count_sum";
    private Long rumTotalSessionCountSum;
    public static final String JSON_PROPERTY_SYNTHETICS_BROWSER_CHECK_CALLS_COUNT_SUM = "synthetics_browser_check_calls_count_sum";
    private Long syntheticsBrowserCheckCallsCountSum;
    public static final String JSON_PROPERTY_SYNTHETICS_CHECK_CALLS_COUNT_SUM = "synthetics_check_calls_count_sum";
    private Long syntheticsCheckCallsCountSum;
    public static final String JSON_PROPERTY_TRACE_SEARCH_INDEXED_EVENTS_COUNT_SUM = "trace_search_indexed_events_count_sum";
    private Long traceSearchIndexedEventsCountSum;
    public static final String JSON_PROPERTY_TWOL_INGESTED_EVENTS_BYTES_SUM = "twol_ingested_events_bytes_sum";
    private Long twolIngestedEventsBytesSum;
    public static final String JSON_PROPERTY_VSPHERE_HOST_TOP99P = "vsphere_host_top99p";
    private Long vsphereHostTop99p;

    public UsageSummaryDateOrg agentHostTop99p(Long agentHostTop99p) {
        this.agentHostTop99p = agentHostTop99p;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all agent hosts over all hours in the current date for the given org.")
    @JsonProperty(value="agent_host_top99p")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getAgentHostTop99p() {
        return this.agentHostTop99p;
    }

    public void setAgentHostTop99p(Long agentHostTop99p) {
        this.agentHostTop99p = agentHostTop99p;
    }

    public UsageSummaryDateOrg apmAzureAppServiceHostTop99p(Long apmAzureAppServiceHostTop99p) {
        this.apmAzureAppServiceHostTop99p = apmAzureAppServiceHostTop99p;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all Azure app services using APM over all hours in the current date for the given org.")
    @JsonProperty(value="apm_azure_app_service_host_top99p")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getApmAzureAppServiceHostTop99p() {
        return this.apmAzureAppServiceHostTop99p;
    }

    public void setApmAzureAppServiceHostTop99p(Long apmAzureAppServiceHostTop99p) {
        this.apmAzureAppServiceHostTop99p = apmAzureAppServiceHostTop99p;
    }

    public UsageSummaryDateOrg apmHostTop99p(Long apmHostTop99p) {
        this.apmHostTop99p = apmHostTop99p;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all distinct APM hosts over all hours in the current date for the given org.")
    @JsonProperty(value="apm_host_top99p")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getApmHostTop99p() {
        return this.apmHostTop99p;
    }

    public void setApmHostTop99p(Long apmHostTop99p) {
        this.apmHostTop99p = apmHostTop99p;
    }

    public UsageSummaryDateOrg auditLogsLinesIndexedSum(Long auditLogsLinesIndexedSum) {
        this.auditLogsLinesIndexedSum = auditLogsLinesIndexedSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all audit logs lines indexed over all hours in the current date for the given org.")
    @JsonProperty(value="audit_logs_lines_indexed_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getAuditLogsLinesIndexedSum() {
        return this.auditLogsLinesIndexedSum;
    }

    public void setAuditLogsLinesIndexedSum(Long auditLogsLinesIndexedSum) {
        this.auditLogsLinesIndexedSum = auditLogsLinesIndexedSum;
    }

    public UsageSummaryDateOrg awsHostTop99p(Long awsHostTop99p) {
        this.awsHostTop99p = awsHostTop99p;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all AWS hosts over all hours in the current date for the given org.")
    @JsonProperty(value="aws_host_top99p")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getAwsHostTop99p() {
        return this.awsHostTop99p;
    }

    public void setAwsHostTop99p(Long awsHostTop99p) {
        this.awsHostTop99p = awsHostTop99p;
    }

    public UsageSummaryDateOrg awsLambdaFuncCount(Long awsLambdaFuncCount) {
        this.awsLambdaFuncCount = awsLambdaFuncCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all AWS Lambda invocations over all hours in the current date for the given org.")
    @JsonProperty(value="aws_lambda_func_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getAwsLambdaFuncCount() {
        return this.awsLambdaFuncCount;
    }

    public void setAwsLambdaFuncCount(Long awsLambdaFuncCount) {
        this.awsLambdaFuncCount = awsLambdaFuncCount;
    }

    public UsageSummaryDateOrg awsLambdaInvocationsSum(Long awsLambdaInvocationsSum) {
        this.awsLambdaInvocationsSum = awsLambdaInvocationsSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all AWS Lambda invocations over all hours in the current date for the given org.")
    @JsonProperty(value="aws_lambda_invocations_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getAwsLambdaInvocationsSum() {
        return this.awsLambdaInvocationsSum;
    }

    public void setAwsLambdaInvocationsSum(Long awsLambdaInvocationsSum) {
        this.awsLambdaInvocationsSum = awsLambdaInvocationsSum;
    }

    public UsageSummaryDateOrg azureAppServiceTop99p(Long azureAppServiceTop99p) {
        this.azureAppServiceTop99p = azureAppServiceTop99p;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all Azure app services over all hours in the current date for the given org.")
    @JsonProperty(value="azure_app_service_top99p")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getAzureAppServiceTop99p() {
        return this.azureAppServiceTop99p;
    }

    public void setAzureAppServiceTop99p(Long azureAppServiceTop99p) {
        this.azureAppServiceTop99p = azureAppServiceTop99p;
    }

    public UsageSummaryDateOrg billableIngestedBytesSum(Long billableIngestedBytesSum) {
        this.billableIngestedBytesSum = billableIngestedBytesSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all log bytes ingested over all hours in the current date for the given org.")
    @JsonProperty(value="billable_ingested_bytes_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getBillableIngestedBytesSum() {
        return this.billableIngestedBytesSum;
    }

    public void setBillableIngestedBytesSum(Long billableIngestedBytesSum) {
        this.billableIngestedBytesSum = billableIngestedBytesSum;
    }

    public UsageSummaryDateOrg containerAvg(Long containerAvg) {
        this.containerAvg = containerAvg;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the average of all distinct containers over all hours in the current date for the given org.")
    @JsonProperty(value="container_avg")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getContainerAvg() {
        return this.containerAvg;
    }

    public void setContainerAvg(Long containerAvg) {
        this.containerAvg = containerAvg;
    }

    public UsageSummaryDateOrg containerHwm(Long containerHwm) {
        this.containerHwm = containerHwm;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the high-water mark of all distinct containers over all hours in the current date for the given org.")
    @JsonProperty(value="container_hwm")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getContainerHwm() {
        return this.containerHwm;
    }

    public void setContainerHwm(Long containerHwm) {
        this.containerHwm = containerHwm;
    }

    public UsageSummaryDateOrg cspmContainerAvg(Long cspmContainerAvg) {
        this.cspmContainerAvg = cspmContainerAvg;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the average number of Cloud Security Posture Management containers over all hours in the current date for the given org.")
    @JsonProperty(value="cspm_container_avg")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getCspmContainerAvg() {
        return this.cspmContainerAvg;
    }

    public void setCspmContainerAvg(Long cspmContainerAvg) {
        this.cspmContainerAvg = cspmContainerAvg;
    }

    public UsageSummaryDateOrg cspmContainerHwm(Long cspmContainerHwm) {
        this.cspmContainerHwm = cspmContainerHwm;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the high-water mark of Cloud Security Posture Management containers over all hours in the current date for the given org.")
    @JsonProperty(value="cspm_container_hwm")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getCspmContainerHwm() {
        return this.cspmContainerHwm;
    }

    public void setCspmContainerHwm(Long cspmContainerHwm) {
        this.cspmContainerHwm = cspmContainerHwm;
    }

    public UsageSummaryDateOrg cspmHostTop99p(Long cspmHostTop99p) {
        this.cspmHostTop99p = cspmHostTop99p;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all Cloud Security Posture Management hosts over all hours in the current date for the given org.")
    @JsonProperty(value="cspm_host_top99p")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getCspmHostTop99p() {
        return this.cspmHostTop99p;
    }

    public void setCspmHostTop99p(Long cspmHostTop99p) {
        this.cspmHostTop99p = cspmHostTop99p;
    }

    public UsageSummaryDateOrg customTsAvg(Long customTsAvg) {
        this.customTsAvg = customTsAvg;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the average number of distinct custom metrics over all hours in the current date for the given org.")
    @JsonProperty(value="custom_ts_avg")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getCustomTsAvg() {
        return this.customTsAvg;
    }

    public void setCustomTsAvg(Long customTsAvg) {
        this.customTsAvg = customTsAvg;
    }

    public UsageSummaryDateOrg cwsContainerCountAvg(Long cwsContainerCountAvg) {
        this.cwsContainerCountAvg = cwsContainerCountAvg;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the average of all distinct Cloud Workload Security containers over all hours in the current date for the given org.")
    @JsonProperty(value="cws_container_count_avg")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getCwsContainerCountAvg() {
        return this.cwsContainerCountAvg;
    }

    public void setCwsContainerCountAvg(Long cwsContainerCountAvg) {
        this.cwsContainerCountAvg = cwsContainerCountAvg;
    }

    public UsageSummaryDateOrg cwsHostTop99p(Long cwsHostTop99p) {
        this.cwsHostTop99p = cwsHostTop99p;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all Cloud Workload Security hosts over all hours in the current date for the given org.")
    @JsonProperty(value="cws_host_top99p")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getCwsHostTop99p() {
        return this.cwsHostTop99p;
    }

    public void setCwsHostTop99p(Long cwsHostTop99p) {
        this.cwsHostTop99p = cwsHostTop99p;
    }

    public UsageSummaryDateOrg dbmHostTop99pSum(Long dbmHostTop99pSum) {
        this.dbmHostTop99pSum = dbmHostTop99pSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all Database Monitoring hosts over all hours in the current month for all organizations.")
    @JsonProperty(value="dbm_host_top99p_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getDbmHostTop99pSum() {
        return this.dbmHostTop99pSum;
    }

    public void setDbmHostTop99pSum(Long dbmHostTop99pSum) {
        this.dbmHostTop99pSum = dbmHostTop99pSum;
    }

    public UsageSummaryDateOrg dbmQueriesAvgSum(Long dbmQueriesAvgSum) {
        this.dbmQueriesAvgSum = dbmQueriesAvgSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the average of all distinct Database Monitoring normalized queries over all hours in the current month for all organizations.")
    @JsonProperty(value="dbm_queries_avg_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getDbmQueriesAvgSum() {
        return this.dbmQueriesAvgSum;
    }

    public void setDbmQueriesAvgSum(Long dbmQueriesAvgSum) {
        this.dbmQueriesAvgSum = dbmQueriesAvgSum;
    }

    public UsageSummaryDateOrg fargateTasksCountAvg(Long fargateTasksCountAvg) {
        this.fargateTasksCountAvg = fargateTasksCountAvg;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The average task count for Fargate.")
    @JsonProperty(value="fargate_tasks_count_avg")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getFargateTasksCountAvg() {
        return this.fargateTasksCountAvg;
    }

    public void setFargateTasksCountAvg(Long fargateTasksCountAvg) {
        this.fargateTasksCountAvg = fargateTasksCountAvg;
    }

    public UsageSummaryDateOrg fargateTasksCountHwm(Long fargateTasksCountHwm) {
        this.fargateTasksCountHwm = fargateTasksCountHwm;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the high-water mark of all Fargate tasks over all hours in the current date for the given org.")
    @JsonProperty(value="fargate_tasks_count_hwm")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getFargateTasksCountHwm() {
        return this.fargateTasksCountHwm;
    }

    public void setFargateTasksCountHwm(Long fargateTasksCountHwm) {
        this.fargateTasksCountHwm = fargateTasksCountHwm;
    }

    public UsageSummaryDateOrg gcpHostTop99p(Long gcpHostTop99p) {
        this.gcpHostTop99p = gcpHostTop99p;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all GCP hosts over all hours in the current date for the given org.")
    @JsonProperty(value="gcp_host_top99p")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getGcpHostTop99p() {
        return this.gcpHostTop99p;
    }

    public void setGcpHostTop99p(Long gcpHostTop99p) {
        this.gcpHostTop99p = gcpHostTop99p;
    }

    public UsageSummaryDateOrg herokuHostTop99p(Long herokuHostTop99p) {
        this.herokuHostTop99p = herokuHostTop99p;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all Heroku dynos over all hours in the current date for the given org.")
    @JsonProperty(value="heroku_host_top99p")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getHerokuHostTop99p() {
        return this.herokuHostTop99p;
    }

    public void setHerokuHostTop99p(Long herokuHostTop99p) {
        this.herokuHostTop99p = herokuHostTop99p;
    }

    public UsageSummaryDateOrg id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The organization id.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public UsageSummaryDateOrg incidentManagementMonthlyActiveUsersHwm(Long incidentManagementMonthlyActiveUsersHwm) {
        this.incidentManagementMonthlyActiveUsersHwm = incidentManagementMonthlyActiveUsersHwm;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the high-water mark of incident management monthly active users over all hours in the current date for the given org.")
    @JsonProperty(value="incident_management_monthly_active_users_hwm")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getIncidentManagementMonthlyActiveUsersHwm() {
        return this.incidentManagementMonthlyActiveUsersHwm;
    }

    public void setIncidentManagementMonthlyActiveUsersHwm(Long incidentManagementMonthlyActiveUsersHwm) {
        this.incidentManagementMonthlyActiveUsersHwm = incidentManagementMonthlyActiveUsersHwm;
    }

    public UsageSummaryDateOrg indexedEventsCountSum(Long indexedEventsCountSum) {
        this.indexedEventsCountSum = indexedEventsCountSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all log events indexed over all hours in the current date for the given org.")
    @JsonProperty(value="indexed_events_count_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getIndexedEventsCountSum() {
        return this.indexedEventsCountSum;
    }

    public void setIndexedEventsCountSum(Long indexedEventsCountSum) {
        this.indexedEventsCountSum = indexedEventsCountSum;
    }

    public UsageSummaryDateOrg infraHostTop99p(Long infraHostTop99p) {
        this.infraHostTop99p = infraHostTop99p;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all distinct infrastructure hosts over all hours in the current date for the given org.")
    @JsonProperty(value="infra_host_top99p")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getInfraHostTop99p() {
        return this.infraHostTop99p;
    }

    public void setInfraHostTop99p(Long infraHostTop99p) {
        this.infraHostTop99p = infraHostTop99p;
    }

    public UsageSummaryDateOrg ingestedEventsBytesSum(Long ingestedEventsBytesSum) {
        this.ingestedEventsBytesSum = ingestedEventsBytesSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all log bytes ingested over all hours in the current date for the given org.")
    @JsonProperty(value="ingested_events_bytes_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getIngestedEventsBytesSum() {
        return this.ingestedEventsBytesSum;
    }

    public void setIngestedEventsBytesSum(Long ingestedEventsBytesSum) {
        this.ingestedEventsBytesSum = ingestedEventsBytesSum;
    }

    public UsageSummaryDateOrg iotDeviceAggSum(Long iotDeviceAggSum) {
        this.iotDeviceAggSum = iotDeviceAggSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all IoT devices over all hours in the current date for the given org.")
    @JsonProperty(value="iot_device_agg_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getIotDeviceAggSum() {
        return this.iotDeviceAggSum;
    }

    public void setIotDeviceAggSum(Long iotDeviceAggSum) {
        this.iotDeviceAggSum = iotDeviceAggSum;
    }

    public UsageSummaryDateOrg iotDeviceTop99pSum(Long iotDeviceTop99pSum) {
        this.iotDeviceTop99pSum = iotDeviceTop99pSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all IoT devices over all hours in the current date for the given org.")
    @JsonProperty(value="iot_device_top99p_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getIotDeviceTop99pSum() {
        return this.iotDeviceTop99pSum;
    }

    public void setIotDeviceTop99pSum(Long iotDeviceTop99pSum) {
        this.iotDeviceTop99pSum = iotDeviceTop99pSum;
    }

    public UsageSummaryDateOrg mobileRumSessionCountAndroidSum(Long mobileRumSessionCountAndroidSum) {
        this.mobileRumSessionCountAndroidSum = mobileRumSessionCountAndroidSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all mobile RUM Sessions on Android over all hours in the current date for the given org.")
    @JsonProperty(value="mobile_rum_session_count_android_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getMobileRumSessionCountAndroidSum() {
        return this.mobileRumSessionCountAndroidSum;
    }

    public void setMobileRumSessionCountAndroidSum(Long mobileRumSessionCountAndroidSum) {
        this.mobileRumSessionCountAndroidSum = mobileRumSessionCountAndroidSum;
    }

    public UsageSummaryDateOrg mobileRumSessionCountIosSum(Long mobileRumSessionCountIosSum) {
        this.mobileRumSessionCountIosSum = mobileRumSessionCountIosSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all mobile RUM Sessions on iOS over all hours in the current date for the given org.")
    @JsonProperty(value="mobile_rum_session_count_ios_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getMobileRumSessionCountIosSum() {
        return this.mobileRumSessionCountIosSum;
    }

    public void setMobileRumSessionCountIosSum(Long mobileRumSessionCountIosSum) {
        this.mobileRumSessionCountIosSum = mobileRumSessionCountIosSum;
    }

    public UsageSummaryDateOrg mobileRumSessionCountSum(Long mobileRumSessionCountSum) {
        this.mobileRumSessionCountSum = mobileRumSessionCountSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all mobile RUM Sessions over all hours in the current date for the given org.")
    @JsonProperty(value="mobile_rum_session_count_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getMobileRumSessionCountSum() {
        return this.mobileRumSessionCountSum;
    }

    public void setMobileRumSessionCountSum(Long mobileRumSessionCountSum) {
        this.mobileRumSessionCountSum = mobileRumSessionCountSum;
    }

    public UsageSummaryDateOrg name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The organization name.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UsageSummaryDateOrg netflowIndexedEventsCountSum(Long netflowIndexedEventsCountSum) {
        this.netflowIndexedEventsCountSum = netflowIndexedEventsCountSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all Network flows indexed over all hours in the current date for the given org.")
    @JsonProperty(value="netflow_indexed_events_count_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getNetflowIndexedEventsCountSum() {
        return this.netflowIndexedEventsCountSum;
    }

    public void setNetflowIndexedEventsCountSum(Long netflowIndexedEventsCountSum) {
        this.netflowIndexedEventsCountSum = netflowIndexedEventsCountSum;
    }

    public UsageSummaryDateOrg npmHostTop99p(Long npmHostTop99p) {
        this.npmHostTop99p = npmHostTop99p;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all distinct Networks hosts over all hours in the current date for the given org.")
    @JsonProperty(value="npm_host_top99p")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getNpmHostTop99p() {
        return this.npmHostTop99p;
    }

    public void setNpmHostTop99p(Long npmHostTop99p) {
        this.npmHostTop99p = npmHostTop99p;
    }

    public UsageSummaryDateOrg opentelemetryHostTop99p(Long opentelemetryHostTop99p) {
        this.opentelemetryHostTop99p = opentelemetryHostTop99p;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all hosts reported by the Datadog exporter for the OpenTelemetry Collector over all hours in the current date for the given org.")
    @JsonProperty(value="opentelemetry_host_top99p")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getOpentelemetryHostTop99p() {
        return this.opentelemetryHostTop99p;
    }

    public void setOpentelemetryHostTop99p(Long opentelemetryHostTop99p) {
        this.opentelemetryHostTop99p = opentelemetryHostTop99p;
    }

    public UsageSummaryDateOrg profilingHostTop99p(Long profilingHostTop99p) {
        this.profilingHostTop99p = profilingHostTop99p;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all profiled hosts over all hours in the current date for the given org.")
    @JsonProperty(value="profiling_host_top99p")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getProfilingHostTop99p() {
        return this.profilingHostTop99p;
    }

    public void setProfilingHostTop99p(Long profilingHostTop99p) {
        this.profilingHostTop99p = profilingHostTop99p;
    }

    public UsageSummaryDateOrg publicId(String publicId) {
        this.publicId = publicId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The organization public id.")
    @JsonProperty(value="public_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPublicId() {
        return this.publicId;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public UsageSummaryDateOrg rumSessionCountSum(Long rumSessionCountSum) {
        this.rumSessionCountSum = rumSessionCountSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all browser RUM Sessions over all hours in the current date for the given org.")
    @JsonProperty(value="rum_session_count_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getRumSessionCountSum() {
        return this.rumSessionCountSum;
    }

    public void setRumSessionCountSum(Long rumSessionCountSum) {
        this.rumSessionCountSum = rumSessionCountSum;
    }

    public UsageSummaryDateOrg rumTotalSessionCountSum(Long rumTotalSessionCountSum) {
        this.rumTotalSessionCountSum = rumTotalSessionCountSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of RUM Sessions (browser and mobile) over all hours in the current date for the given org.")
    @JsonProperty(value="rum_total_session_count_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getRumTotalSessionCountSum() {
        return this.rumTotalSessionCountSum;
    }

    public void setRumTotalSessionCountSum(Long rumTotalSessionCountSum) {
        this.rumTotalSessionCountSum = rumTotalSessionCountSum;
    }

    public UsageSummaryDateOrg syntheticsBrowserCheckCallsCountSum(Long syntheticsBrowserCheckCallsCountSum) {
        this.syntheticsBrowserCheckCallsCountSum = syntheticsBrowserCheckCallsCountSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all Synthetic browser tests over all hours in the current date for the given org.")
    @JsonProperty(value="synthetics_browser_check_calls_count_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getSyntheticsBrowserCheckCallsCountSum() {
        return this.syntheticsBrowserCheckCallsCountSum;
    }

    public void setSyntheticsBrowserCheckCallsCountSum(Long syntheticsBrowserCheckCallsCountSum) {
        this.syntheticsBrowserCheckCallsCountSum = syntheticsBrowserCheckCallsCountSum;
    }

    public UsageSummaryDateOrg syntheticsCheckCallsCountSum(Long syntheticsCheckCallsCountSum) {
        this.syntheticsCheckCallsCountSum = syntheticsCheckCallsCountSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all Synthetic API tests over all hours in the current date for the given org.")
    @JsonProperty(value="synthetics_check_calls_count_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getSyntheticsCheckCallsCountSum() {
        return this.syntheticsCheckCallsCountSum;
    }

    public void setSyntheticsCheckCallsCountSum(Long syntheticsCheckCallsCountSum) {
        this.syntheticsCheckCallsCountSum = syntheticsCheckCallsCountSum;
    }

    public UsageSummaryDateOrg traceSearchIndexedEventsCountSum(Long traceSearchIndexedEventsCountSum) {
        this.traceSearchIndexedEventsCountSum = traceSearchIndexedEventsCountSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all Indexed Spans indexed over all hours in the current date for the given org.")
    @JsonProperty(value="trace_search_indexed_events_count_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getTraceSearchIndexedEventsCountSum() {
        return this.traceSearchIndexedEventsCountSum;
    }

    public void setTraceSearchIndexedEventsCountSum(Long traceSearchIndexedEventsCountSum) {
        this.traceSearchIndexedEventsCountSum = traceSearchIndexedEventsCountSum;
    }

    public UsageSummaryDateOrg twolIngestedEventsBytesSum(Long twolIngestedEventsBytesSum) {
        this.twolIngestedEventsBytesSum = twolIngestedEventsBytesSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all tracing without limits bytes ingested over all hours in the current date for the given org.")
    @JsonProperty(value="twol_ingested_events_bytes_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getTwolIngestedEventsBytesSum() {
        return this.twolIngestedEventsBytesSum;
    }

    public void setTwolIngestedEventsBytesSum(Long twolIngestedEventsBytesSum) {
        this.twolIngestedEventsBytesSum = twolIngestedEventsBytesSum;
    }

    public UsageSummaryDateOrg vsphereHostTop99p(Long vsphereHostTop99p) {
        this.vsphereHostTop99p = vsphereHostTop99p;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all vSphere hosts over all hours in the current date for the given org.")
    @JsonProperty(value="vsphere_host_top99p")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getVsphereHostTop99p() {
        return this.vsphereHostTop99p;
    }

    public void setVsphereHostTop99p(Long vsphereHostTop99p) {
        this.vsphereHostTop99p = vsphereHostTop99p;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageSummaryDateOrg usageSummaryDateOrg = (UsageSummaryDateOrg)o;
        return Objects.equals(this.agentHostTop99p, usageSummaryDateOrg.agentHostTop99p) && Objects.equals(this.apmAzureAppServiceHostTop99p, usageSummaryDateOrg.apmAzureAppServiceHostTop99p) && Objects.equals(this.apmHostTop99p, usageSummaryDateOrg.apmHostTop99p) && Objects.equals(this.auditLogsLinesIndexedSum, usageSummaryDateOrg.auditLogsLinesIndexedSum) && Objects.equals(this.awsHostTop99p, usageSummaryDateOrg.awsHostTop99p) && Objects.equals(this.awsLambdaFuncCount, usageSummaryDateOrg.awsLambdaFuncCount) && Objects.equals(this.awsLambdaInvocationsSum, usageSummaryDateOrg.awsLambdaInvocationsSum) && Objects.equals(this.azureAppServiceTop99p, usageSummaryDateOrg.azureAppServiceTop99p) && Objects.equals(this.billableIngestedBytesSum, usageSummaryDateOrg.billableIngestedBytesSum) && Objects.equals(this.containerAvg, usageSummaryDateOrg.containerAvg) && Objects.equals(this.containerHwm, usageSummaryDateOrg.containerHwm) && Objects.equals(this.cspmContainerAvg, usageSummaryDateOrg.cspmContainerAvg) && Objects.equals(this.cspmContainerHwm, usageSummaryDateOrg.cspmContainerHwm) && Objects.equals(this.cspmHostTop99p, usageSummaryDateOrg.cspmHostTop99p) && Objects.equals(this.customTsAvg, usageSummaryDateOrg.customTsAvg) && Objects.equals(this.cwsContainerCountAvg, usageSummaryDateOrg.cwsContainerCountAvg) && Objects.equals(this.cwsHostTop99p, usageSummaryDateOrg.cwsHostTop99p) && Objects.equals(this.dbmHostTop99pSum, usageSummaryDateOrg.dbmHostTop99pSum) && Objects.equals(this.dbmQueriesAvgSum, usageSummaryDateOrg.dbmQueriesAvgSum) && Objects.equals(this.fargateTasksCountAvg, usageSummaryDateOrg.fargateTasksCountAvg) && Objects.equals(this.fargateTasksCountHwm, usageSummaryDateOrg.fargateTasksCountHwm) && Objects.equals(this.gcpHostTop99p, usageSummaryDateOrg.gcpHostTop99p) && Objects.equals(this.herokuHostTop99p, usageSummaryDateOrg.herokuHostTop99p) && Objects.equals(this.id, usageSummaryDateOrg.id) && Objects.equals(this.incidentManagementMonthlyActiveUsersHwm, usageSummaryDateOrg.incidentManagementMonthlyActiveUsersHwm) && Objects.equals(this.indexedEventsCountSum, usageSummaryDateOrg.indexedEventsCountSum) && Objects.equals(this.infraHostTop99p, usageSummaryDateOrg.infraHostTop99p) && Objects.equals(this.ingestedEventsBytesSum, usageSummaryDateOrg.ingestedEventsBytesSum) && Objects.equals(this.iotDeviceAggSum, usageSummaryDateOrg.iotDeviceAggSum) && Objects.equals(this.iotDeviceTop99pSum, usageSummaryDateOrg.iotDeviceTop99pSum) && Objects.equals(this.mobileRumSessionCountAndroidSum, usageSummaryDateOrg.mobileRumSessionCountAndroidSum) && Objects.equals(this.mobileRumSessionCountIosSum, usageSummaryDateOrg.mobileRumSessionCountIosSum) && Objects.equals(this.mobileRumSessionCountSum, usageSummaryDateOrg.mobileRumSessionCountSum) && Objects.equals(this.name, usageSummaryDateOrg.name) && Objects.equals(this.netflowIndexedEventsCountSum, usageSummaryDateOrg.netflowIndexedEventsCountSum) && Objects.equals(this.npmHostTop99p, usageSummaryDateOrg.npmHostTop99p) && Objects.equals(this.opentelemetryHostTop99p, usageSummaryDateOrg.opentelemetryHostTop99p) && Objects.equals(this.profilingHostTop99p, usageSummaryDateOrg.profilingHostTop99p) && Objects.equals(this.publicId, usageSummaryDateOrg.publicId) && Objects.equals(this.rumSessionCountSum, usageSummaryDateOrg.rumSessionCountSum) && Objects.equals(this.rumTotalSessionCountSum, usageSummaryDateOrg.rumTotalSessionCountSum) && Objects.equals(this.syntheticsBrowserCheckCallsCountSum, usageSummaryDateOrg.syntheticsBrowserCheckCallsCountSum) && Objects.equals(this.syntheticsCheckCallsCountSum, usageSummaryDateOrg.syntheticsCheckCallsCountSum) && Objects.equals(this.traceSearchIndexedEventsCountSum, usageSummaryDateOrg.traceSearchIndexedEventsCountSum) && Objects.equals(this.twolIngestedEventsBytesSum, usageSummaryDateOrg.twolIngestedEventsBytesSum) && Objects.equals(this.vsphereHostTop99p, usageSummaryDateOrg.vsphereHostTop99p);
    }

    public int hashCode() {
        return Objects.hash(this.agentHostTop99p, this.apmAzureAppServiceHostTop99p, this.apmHostTop99p, this.auditLogsLinesIndexedSum, this.awsHostTop99p, this.awsLambdaFuncCount, this.awsLambdaInvocationsSum, this.azureAppServiceTop99p, this.billableIngestedBytesSum, this.containerAvg, this.containerHwm, this.cspmContainerAvg, this.cspmContainerHwm, this.cspmHostTop99p, this.customTsAvg, this.cwsContainerCountAvg, this.cwsHostTop99p, this.dbmHostTop99pSum, this.dbmQueriesAvgSum, this.fargateTasksCountAvg, this.fargateTasksCountHwm, this.gcpHostTop99p, this.herokuHostTop99p, this.id, this.incidentManagementMonthlyActiveUsersHwm, this.indexedEventsCountSum, this.infraHostTop99p, this.ingestedEventsBytesSum, this.iotDeviceAggSum, this.iotDeviceTop99pSum, this.mobileRumSessionCountAndroidSum, this.mobileRumSessionCountIosSum, this.mobileRumSessionCountSum, this.name, this.netflowIndexedEventsCountSum, this.npmHostTop99p, this.opentelemetryHostTop99p, this.profilingHostTop99p, this.publicId, this.rumSessionCountSum, this.rumTotalSessionCountSum, this.syntheticsBrowserCheckCallsCountSum, this.syntheticsCheckCallsCountSum, this.traceSearchIndexedEventsCountSum, this.twolIngestedEventsBytesSum, this.vsphereHostTop99p);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageSummaryDateOrg {\n");
        sb.append("    agentHostTop99p: ").append(this.toIndentedString(this.agentHostTop99p)).append("\n");
        sb.append("    apmAzureAppServiceHostTop99p: ").append(this.toIndentedString(this.apmAzureAppServiceHostTop99p)).append("\n");
        sb.append("    apmHostTop99p: ").append(this.toIndentedString(this.apmHostTop99p)).append("\n");
        sb.append("    auditLogsLinesIndexedSum: ").append(this.toIndentedString(this.auditLogsLinesIndexedSum)).append("\n");
        sb.append("    awsHostTop99p: ").append(this.toIndentedString(this.awsHostTop99p)).append("\n");
        sb.append("    awsLambdaFuncCount: ").append(this.toIndentedString(this.awsLambdaFuncCount)).append("\n");
        sb.append("    awsLambdaInvocationsSum: ").append(this.toIndentedString(this.awsLambdaInvocationsSum)).append("\n");
        sb.append("    azureAppServiceTop99p: ").append(this.toIndentedString(this.azureAppServiceTop99p)).append("\n");
        sb.append("    billableIngestedBytesSum: ").append(this.toIndentedString(this.billableIngestedBytesSum)).append("\n");
        sb.append("    containerAvg: ").append(this.toIndentedString(this.containerAvg)).append("\n");
        sb.append("    containerHwm: ").append(this.toIndentedString(this.containerHwm)).append("\n");
        sb.append("    cspmContainerAvg: ").append(this.toIndentedString(this.cspmContainerAvg)).append("\n");
        sb.append("    cspmContainerHwm: ").append(this.toIndentedString(this.cspmContainerHwm)).append("\n");
        sb.append("    cspmHostTop99p: ").append(this.toIndentedString(this.cspmHostTop99p)).append("\n");
        sb.append("    customTsAvg: ").append(this.toIndentedString(this.customTsAvg)).append("\n");
        sb.append("    cwsContainerCountAvg: ").append(this.toIndentedString(this.cwsContainerCountAvg)).append("\n");
        sb.append("    cwsHostTop99p: ").append(this.toIndentedString(this.cwsHostTop99p)).append("\n");
        sb.append("    dbmHostTop99pSum: ").append(this.toIndentedString(this.dbmHostTop99pSum)).append("\n");
        sb.append("    dbmQueriesAvgSum: ").append(this.toIndentedString(this.dbmQueriesAvgSum)).append("\n");
        sb.append("    fargateTasksCountAvg: ").append(this.toIndentedString(this.fargateTasksCountAvg)).append("\n");
        sb.append("    fargateTasksCountHwm: ").append(this.toIndentedString(this.fargateTasksCountHwm)).append("\n");
        sb.append("    gcpHostTop99p: ").append(this.toIndentedString(this.gcpHostTop99p)).append("\n");
        sb.append("    herokuHostTop99p: ").append(this.toIndentedString(this.herokuHostTop99p)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    incidentManagementMonthlyActiveUsersHwm: ").append(this.toIndentedString(this.incidentManagementMonthlyActiveUsersHwm)).append("\n");
        sb.append("    indexedEventsCountSum: ").append(this.toIndentedString(this.indexedEventsCountSum)).append("\n");
        sb.append("    infraHostTop99p: ").append(this.toIndentedString(this.infraHostTop99p)).append("\n");
        sb.append("    ingestedEventsBytesSum: ").append(this.toIndentedString(this.ingestedEventsBytesSum)).append("\n");
        sb.append("    iotDeviceAggSum: ").append(this.toIndentedString(this.iotDeviceAggSum)).append("\n");
        sb.append("    iotDeviceTop99pSum: ").append(this.toIndentedString(this.iotDeviceTop99pSum)).append("\n");
        sb.append("    mobileRumSessionCountAndroidSum: ").append(this.toIndentedString(this.mobileRumSessionCountAndroidSum)).append("\n");
        sb.append("    mobileRumSessionCountIosSum: ").append(this.toIndentedString(this.mobileRumSessionCountIosSum)).append("\n");
        sb.append("    mobileRumSessionCountSum: ").append(this.toIndentedString(this.mobileRumSessionCountSum)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    netflowIndexedEventsCountSum: ").append(this.toIndentedString(this.netflowIndexedEventsCountSum)).append("\n");
        sb.append("    npmHostTop99p: ").append(this.toIndentedString(this.npmHostTop99p)).append("\n");
        sb.append("    opentelemetryHostTop99p: ").append(this.toIndentedString(this.opentelemetryHostTop99p)).append("\n");
        sb.append("    profilingHostTop99p: ").append(this.toIndentedString(this.profilingHostTop99p)).append("\n");
        sb.append("    publicId: ").append(this.toIndentedString(this.publicId)).append("\n");
        sb.append("    rumSessionCountSum: ").append(this.toIndentedString(this.rumSessionCountSum)).append("\n");
        sb.append("    rumTotalSessionCountSum: ").append(this.toIndentedString(this.rumTotalSessionCountSum)).append("\n");
        sb.append("    syntheticsBrowserCheckCallsCountSum: ").append(this.toIndentedString(this.syntheticsBrowserCheckCallsCountSum)).append("\n");
        sb.append("    syntheticsCheckCallsCountSum: ").append(this.toIndentedString(this.syntheticsCheckCallsCountSum)).append("\n");
        sb.append("    traceSearchIndexedEventsCountSum: ").append(this.toIndentedString(this.traceSearchIndexedEventsCountSum)).append("\n");
        sb.append("    twolIngestedEventsBytesSum: ").append(this.toIndentedString(this.twolIngestedEventsBytesSum)).append("\n");
        sb.append("    vsphereHostTop99p: ").append(this.toIndentedString(this.vsphereHostTop99p)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

