/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.LogsExclusionFilter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Represents the index exclusion filter object from configuration API.")
@JsonPropertyOrder(value={"filter", "is_enabled", "name"})
public class LogsExclusion {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_FILTER = "filter";
    private LogsExclusionFilter filter;
    public static final String JSON_PROPERTY_IS_ENABLED = "is_enabled";
    private Boolean isEnabled;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public LogsExclusion() {
    }

    @JsonCreator
    public LogsExclusion(@JsonProperty(required=true, value="name") String name) {
        this.name = name;
    }

    public LogsExclusion filter(LogsExclusionFilter filter) {
        this.filter = filter;
        this.unparsed |= filter.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogsExclusionFilter getFilter() {
        return this.filter;
    }

    public void setFilter(LogsExclusionFilter filter) {
        this.filter = filter;
    }

    public LogsExclusion isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether or not the exclusion filter is active.")
    @JsonProperty(value="is_enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public LogsExclusion name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="payment", required=true, value="Name of the index exclusion filter.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsExclusion logsExclusion = (LogsExclusion)o;
        return Objects.equals(this.filter, logsExclusion.filter) && Objects.equals(this.isEnabled, logsExclusion.isEnabled) && Objects.equals(this.name, logsExclusion.name);
    }

    public int hashCode() {
        return Objects.hash(this.filter, this.isEnabled, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsExclusion {\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

