/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Returns the AWS account associated with this integration.")
@JsonPropertyOrder(value={"access_key_id", "account_id", "account_specific_namespace_rules", "excluded_regions", "filter_tags", "host_tags", "role_name", "secret_access_key"})
public class AWSAccount {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ACCESS_KEY_ID = "access_key_id";
    private String accessKeyId;
    public static final String JSON_PROPERTY_ACCOUNT_ID = "account_id";
    private String accountId;
    public static final String JSON_PROPERTY_ACCOUNT_SPECIFIC_NAMESPACE_RULES = "account_specific_namespace_rules";
    private Map<String, Boolean> accountSpecificNamespaceRules = null;
    public static final String JSON_PROPERTY_EXCLUDED_REGIONS = "excluded_regions";
    private List<String> excludedRegions = null;
    public static final String JSON_PROPERTY_FILTER_TAGS = "filter_tags";
    private List<String> filterTags = null;
    public static final String JSON_PROPERTY_HOST_TAGS = "host_tags";
    private List<String> hostTags = null;
    public static final String JSON_PROPERTY_ROLE_NAME = "role_name";
    private String roleName;
    public static final String JSON_PROPERTY_SECRET_ACCESS_KEY = "secret_access_key";
    private String secretAccessKey;

    public AWSAccount accessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your AWS access key ID. Only required if your AWS account is a GovCloud or China account.")
    @JsonProperty(value="access_key_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public AWSAccount accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1234567", value="Your AWS Account ID without dashes.")
    @JsonProperty(value="account_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public AWSAccount accountSpecificNamespaceRules(Map<String, Boolean> accountSpecificNamespaceRules) {
        this.accountSpecificNamespaceRules = accountSpecificNamespaceRules;
        return this;
    }

    public AWSAccount putAccountSpecificNamespaceRulesItem(String key, Boolean accountSpecificNamespaceRulesItem) {
        if (this.accountSpecificNamespaceRules == null) {
            this.accountSpecificNamespaceRules = new HashMap<String, Boolean>();
        }
        this.accountSpecificNamespaceRules.put(key, accountSpecificNamespaceRulesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"auto_scaling\":false,\"opswork\":false}", value="An object, (in the form `{\"namespace1\":true/false, \"namespace2\":true/false}`), that enables or disables metric collection for specific AWS namespaces for this AWS account only.")
    @JsonProperty(value="account_specific_namespace_rules")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Boolean> getAccountSpecificNamespaceRules() {
        return this.accountSpecificNamespaceRules;
    }

    public void setAccountSpecificNamespaceRules(Map<String, Boolean> accountSpecificNamespaceRules) {
        this.accountSpecificNamespaceRules = accountSpecificNamespaceRules;
    }

    public AWSAccount excludedRegions(List<String> excludedRegions) {
        this.excludedRegions = excludedRegions;
        return this;
    }

    public AWSAccount addExcludedRegionsItem(String excludedRegionsItem) {
        if (this.excludedRegions == null) {
            this.excludedRegions = new ArrayList<String>();
        }
        this.excludedRegions.add(excludedRegionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"us-east-1\",\"us-west-2\"]", value="An array of AWS regions to exclude from metrics collection.")
    @JsonProperty(value="excluded_regions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getExcludedRegions() {
        return this.excludedRegions;
    }

    public void setExcludedRegions(List<String> excludedRegions) {
        this.excludedRegions = excludedRegions;
    }

    public AWSAccount filterTags(List<String> filterTags) {
        this.filterTags = filterTags;
        return this;
    }

    public AWSAccount addFilterTagsItem(String filterTagsItem) {
        if (this.filterTags == null) {
            this.filterTags = new ArrayList<String>();
        }
        this.filterTags.add(filterTagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"<KEY>:<VALUE>\"]", value="The array of EC2 tags (in the form `key:value`) defines a filter that Datadog uses when collecting metrics from EC2. Wildcards, such as `?` (for single characters) and `*` (for multiple characters) can also be used. Only hosts that match one of the defined tags will be imported into Datadog. The rest will be ignored. Host matching a given tag can also be excluded by adding `!` before the tag. For example, `env:production,instance-type:c1.*,!region:us-east-1`")
    @JsonProperty(value="filter_tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getFilterTags() {
        return this.filterTags;
    }

    public void setFilterTags(List<String> filterTags) {
        this.filterTags = filterTags;
    }

    public AWSAccount hostTags(List<String> hostTags) {
        this.hostTags = hostTags;
        return this;
    }

    public AWSAccount addHostTagsItem(String hostTagsItem) {
        if (this.hostTags == null) {
            this.hostTags = new ArrayList<String>();
        }
        this.hostTags.add(hostTagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"<KEY>:<VALUE>\"]", value="Array of tags (in the form `key:value`) to add to all hosts and metrics reporting through this integration.")
    @JsonProperty(value="host_tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getHostTags() {
        return this.hostTags;
    }

    public void setHostTags(List<String> hostTags) {
        this.hostTags = hostTags;
    }

    public AWSAccount roleName(String roleName) {
        this.roleName = roleName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="DatadogAWSIntegrationRole", value="Your Datadog role delegation name.")
    @JsonProperty(value="role_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public AWSAccount secretAccessKey(String secretAccessKey) {
        this.secretAccessKey = secretAccessKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your AWS secret access key. Only required if your AWS account is a GovCloud or China account.")
    @JsonProperty(value="secret_access_key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSecretAccessKey() {
        return this.secretAccessKey;
    }

    public void setSecretAccessKey(String secretAccessKey) {
        this.secretAccessKey = secretAccessKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AWSAccount awSAccount = (AWSAccount)o;
        return Objects.equals(this.accessKeyId, awSAccount.accessKeyId) && Objects.equals(this.accountId, awSAccount.accountId) && Objects.equals(this.accountSpecificNamespaceRules, awSAccount.accountSpecificNamespaceRules) && Objects.equals(this.excludedRegions, awSAccount.excludedRegions) && Objects.equals(this.filterTags, awSAccount.filterTags) && Objects.equals(this.hostTags, awSAccount.hostTags) && Objects.equals(this.roleName, awSAccount.roleName) && Objects.equals(this.secretAccessKey, awSAccount.secretAccessKey);
    }

    public int hashCode() {
        return Objects.hash(this.accessKeyId, this.accountId, this.accountSpecificNamespaceRules, this.excludedRegions, this.filterTags, this.hostTags, this.roleName, this.secretAccessKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AWSAccount {\n");
        sb.append("    accessKeyId: ").append(this.toIndentedString(this.accessKeyId)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    accountSpecificNamespaceRules: ").append(this.toIndentedString(this.accountSpecificNamespaceRules)).append("\n");
        sb.append("    excludedRegions: ").append(this.toIndentedString(this.excludedRegions)).append("\n");
        sb.append("    filterTags: ").append(this.toIndentedString(this.filterTags)).append("\n");
        sb.append("    hostTags: ").append(this.toIndentedString(this.hostTags)).append("\n");
        sb.append("    roleName: ").append(this.toIndentedString(this.roleName)).append("\n");
        sb.append("    secretAccessKey: ").append(this.toIndentedString(this.secretAccessKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

